/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.dbinterceptors;

import com.alibaba.druid.util.StringUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class KingbaseBatchSequenceIdInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        System.out.println("KingbaseBatchSequenceIdInterceptor\u62e6\u622a\u5668intercept()\u65b9\u6cd5\u6267\u884c\u4e86");
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        String originalSql = boundSql.getSql().trim();
        if (originalSql.toLowerCase().startsWith("insert")) {
            String modifiedSql = null;
            if (this.isBatchInsert(originalSql)) {
                Pattern pattern = Pattern.compile("(?i)INSERT\\s+INTO\\s+(\\S+)\\s+");
                Matcher matcher = pattern.matcher(originalSql);
                String tableName = "";
                if (matcher.find()) {
                    tableName = matcher.group(1);
                }
                if (StringUtils.isEmpty((CharSequence)tableName)) {
                    System.err.println("\u6ca1\u6709\u5339\u914d\u5230\u8868\u540d:" + originalSql);
                    return invocation.proceed();
                }
                String seqName = tableName + "_id_seq";
                System.out.println("seqName=" + seqName);
                List parameterMappings = boundSql.getParameterMappings();
                modifiedSql = this.replaceIdPlaceholdersWithSequence(originalSql, parameterMappings, seqName.toLowerCase());
            }
            metaObject.setValue("delegate.boundSql.sql", modifiedSql);
        }
        return invocation.proceed();
    }

    private boolean isBatchInsert(String sql) {
        Pattern pattern = Pattern.compile("\\s*VALUES\\s*\\(");
        Matcher matcher = pattern.matcher(sql);
        int count = 0;
        while (matcher.find()) {
            if (++count <= 1) continue;
            return true;
        }
        return false;
    }

    private String replaceIdPlaceholdersWithSequence(String sql, List<ParameterMapping> parameterMappings, String sequenceName) {
        Pattern pattern = Pattern.compile("\\(\\s*\\?\\s*(,\\s*\\?\\s*)*\\)");
        Matcher matcher = pattern.matcher(sql);
        StringBuffer buffer = new StringBuffer();
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        int parameterIndex = 0;
        while (matcher.find()) {
            String group = matcher.group();
            String replacement = matcher.group().replaceFirst("\\?", "nextval('" + sequenceName + "')");
            matcher.appendReplacement(buffer, replacement);
            indexesToRemove.add(parameterIndex);
            parameterIndex += this.countQuestionMarks(group);
        }
        matcher.appendTail(buffer);
        for (int i = indexesToRemove.size() - 1; i >= 0; --i) {
            int index = (Integer)indexesToRemove.get(i);
            if (index >= parameterMappings.size()) continue;
            parameterMappings.remove(index);
        }
        String newSql = buffer.toString();
        System.out.println("\u66ff\u6362\u540e\u5f97sql=" + newSql);
        return newSql;
    }

    private int countQuestionMarks(String group) {
        int count = 0;
        int index = 0;
        while ((index = group.indexOf("?", index)) != -1) {
            ++count;
            ++index;
        }
        return count;
    }

    private String modifyBatchInsertSql(String originalSql, String sequenceName) {
        int valuesPos = originalSql.indexOf("VALUES");
        if (valuesPos == -1) {
            return originalSql;
        }
        String valuesClause = originalSql.substring(valuesPos + "VALUES".length()).trim();
        System.out.println("valuesClause=" + valuesClause);
        String modifiedValuesClause = valuesClause.replaceAll("\\(?,", "(nextval('" + sequenceName + "'), ");
        String newSql = originalSql.substring(0, valuesPos) + "VALUES " + modifiedValuesClause;
        System.out.println("newSql=" + newSql);
        return newSql;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

