/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.dbinterceptors;

import com.alibaba.druid.util.StringUtils;
import com.chinamcloud.spider.system.config.dbinterceptors.kingbase.KingBaseDynamicBoundSql;
import com.chinamcloud.spider.system.config.dbinterceptors.kingbase.KingBaseDynamicSqlSource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class KingbaseKeywordInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Class<?> mappedStatementClass = mappedStatement.getClass();
        Field sqlSourceField = mappedStatementClass.getDeclaredField("sqlSource");
        sqlSourceField.setAccessible(true);
        SqlSource sqlSource = (SqlSource)sqlSourceField.get(mappedStatement);
        sqlSourceField.set(mappedStatement, KingBaseDynamicSqlSource.getDynamicSqlSource(sqlSource, invocation));
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static enum ProcessTokenEnum {
        SET_NULL_JDBC_TYPE{
            boolean processFlag = false;
            private final Field PARAMETERMAPPING_JDBC_FIELD;
            {
                try {
                    this.PARAMETERMAPPING_JDBC_FIELD = ParameterMapping.class.getDeclaredField("jdbcType");
                    this.PARAMETERMAPPING_JDBC_FIELD.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean shouldProcess(KingBaseDynamicBoundSql originSql, Invocation invocation) {
                return true;
            }

            @Override
            public KingBaseDynamicBoundSql process(KingBaseDynamicBoundSql oldSql, Invocation invocation) {
                if (!this.processFlag) {
                    MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
                    Configuration configuration = mappedStatement.getConfiguration();
                    configuration.setJdbcTypeForNull(JdbcType.OTHER);
                    this.processFlag = true;
                }
                List<ParameterMapping> parameterMappings = oldSql.getParameterMappings();
                ResultMap baseResultMap = ProcessTokenEnum.getBaseResultMap(invocation);
                if (baseResultMap == null) {
                    return oldSql;
                }
                List resultMappings = baseResultMap.getResultMappings();
                HashMap<String, JdbcType> propertyJdbcTypeMap = new HashMap<String, JdbcType>();
                for (ResultMapping resultMapping : resultMappings) {
                    String property = resultMapping.getProperty();
                    JdbcType jdbcType_act = resultMapping.getJdbcType();
                    propertyJdbcTypeMap.put(property, jdbcType_act);
                }
                for (ParameterMapping parameterMapping : parameterMappings) {
                    String property;
                    JdbcType type;
                    JdbcType jdbcType = parameterMapping.getJdbcType();
                    if (jdbcType != null || (type = (JdbcType)propertyJdbcTypeMap.get(property = parameterMapping.getProperty())) == null) continue;
                    this.PARAMETERMAPPING_JDBC_FIELD.set(parameterMapping, type);
                }
                return oldSql;
            }
        }
        ,
        KEYWORD{
            final String[] targetToken = new String[]{"COMMENT", "SYNONYM", "SYSTEM", "STAT", "RULE", "PAGE", "MAP", "JOB", "DAILY", "CATALOG"};

            @Override
            public boolean shouldProcess(KingBaseDynamicBoundSql originSql, Invocation invocation) {
                String upperCaseSql = originSql.getSql().toUpperCase();
                for (String token : this.targetToken) {
                    if (!upperCaseSql.contains(token)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public KingBaseDynamicBoundSql process(KingBaseDynamicBoundSql oldSql, Invocation invocation) {
                String processSql = oldSql.getSql();
                for (String s : this.targetToken) {
                    processSql = processSql.replaceAll("(?i)(?<=[\\s,.])+" + s + "(?=[\\s,])+", "\"" + s + "\"");
                }
                oldSql.setSql(processSql);
                return oldSql;
            }
        }
        ,
        SUBDATE,
        GROUP_BY{
            private final String COMPATIBILITY_IDENTIFICATION = "/*+ GROUP_OPT_FLAG(1)*/";

            @Override
            public boolean shouldProcess(KingBaseDynamicBoundSql dynamicSqlBound, Invocation invocation) {
                String originSql2 = dynamicSqlBound.getSql().replace(" ", "");
                return (originSql2 = originSql2.toUpperCase()).contains("GROUPBY") && !originSql2.contains("/*+ GROUP_OPT_FLAG(1)*/".toUpperCase());
            }

            @Override
            public KingBaseDynamicBoundSql process(KingBaseDynamicBoundSql dynamicSqlBound, Invocation invocation) {
                String sqlNew = dynamicSqlBound.getSql().replaceFirst("(?i)(?<=SELECT)[^aA]*?(?=FROM)", " /*+ GROUP_OPT_FLAG(1)*/ $0");
                dynamicSqlBound.setSql(sqlNew);
                return dynamicSqlBound;
            }
        }
        ,
        INSERT_PK{

            @Override
            public boolean shouldProcess(KingBaseDynamicBoundSql oldSql, Invocation invocation) {
                String upperSql = oldSql.getSql().toUpperCase();
                Object arg0 = invocation.getArgs()[0];
                if (!(arg0 instanceof MappedStatement)) {
                    return false;
                }
                MappedStatement statement = (MappedStatement)arg0;
                return statement.getSqlCommandType() == SqlCommandType.INSERT && (statement.getKeyGenerator() == null || statement.getKeyGenerator() instanceof NoKeyGenerator) && upperSql.contains("ID") && !upperSql.contains("IDENTITY_INSERT");
            }

            @Override
            public KingBaseDynamicBoundSql process(KingBaseDynamicBoundSql oldSqlBound, Invocation invocation) {
                MappedStatement statement;
                String id;
                Object arg0;
                System.out.println("\u4eba\u5927\u91d1\u4ed3\u62e6\u622a\u5668KingbaseKeywordInterceptor\u7684process\u65b9\u6cd5\u6267\u884c\u4e86");
                String sqlOld = oldSqlBound.getSql();
                Pattern pattern = Pattern.compile("(?i)INSERT\\s+INTO\\s+(\\S+)\\s+");
                Matcher matcher = pattern.matcher(sqlOld);
                String tableName = "";
                if (matcher.find()) {
                    tableName = matcher.group(1);
                }
                if (StringUtils.isEmpty((CharSequence)tableName)) {
                    System.err.println("\u6ca1\u6709\u5339\u914d\u5230\u8868\u540d:" + sqlOld);
                    return oldSqlBound;
                }
                String seqName = tableName + "_id_seq";
                System.out.println("seqName=" + seqName);
                if (!sqlOld.endsWith(";")) {
                    sqlOld = sqlOld + ";";
                }
                if ((arg0 = invocation.getArgs()[0]) instanceof MappedStatement && (id = (statement = (MappedStatement)arg0).getId()).endsWith("inserts")) {
                    Object arg1;
                    ResultMapping idResultMapping;
                    ResultMap baseResultMap = ProcessTokenEnum.getBaseResultMap(invocation);
                    ResultMapping resultMapping = idResultMapping = baseResultMap == null ? null : (ResultMapping)baseResultMap.getIdResultMappings().get(0);
                    if (idResultMapping != null && (arg1 = invocation.getArgs()[1]) instanceof Map) {
                        Map arg1Map = (Map)arg1;
                        List entities = (List)arg1Map.get("list");
                        if (entities == null) {
                            entities = (List)arg1Map.get("collection");
                        }
                        if (entities != null && !entities.isEmpty()) {
                            int size = entities.size();
                            boolean isAnyNullPK = false;
                            Field idField = baseResultMap.getType().getDeclaredField(idResultMapping.getProperty());
                            idField.setAccessible(true);
                            for (int i = 1; i <= size; ++i) {
                                boolean nullPk;
                                Object column_id = idField.get(entities.get(i - 1));
                                boolean bl = nullPk = column_id == null;
                                if (!(isAnyNullPK |= nullPk)) continue;
                                idField.set(entities.get(i - 1), null);
                            }
                            idField.setAccessible(false);
                            Pattern patternValues = Pattern.compile("(?i)\\s*\\([^)]+\\)(?!\\s*VALUES)");
                            Matcher matcherValue = patternValues.matcher(sqlOld);
                            ArrayList<String> values = new ArrayList<String>();
                            while (matcherValue.find()) {
                                values.add(matcherValue.group());
                            }
                            if (isAnyNullPK) {
                                List<ParameterMapping> parameterMappings = oldSqlBound.getParameterMappings();
                                LinkedList parameterMappingsNew = new LinkedList();
                                for (ParameterMapping parameterMapping : parameterMappings) {
                                    String property = parameterMapping.getProperty();
                                    String actProperty = property.substring(property.lastIndexOf(".") + 1);
                                    if (!idResultMapping.getProperty().equalsIgnoreCase(actProperty)) continue;
                                    Object parameterObject = oldSqlBound.getParameterObject();
                                    Map map = (Map)parameterObject;
                                }
                                oldSqlBound.setParameterMappings(parameterMappings);
                            }
                        }
                    }
                }
                oldSqlBound.setSql(sqlOld.endsWith(";") ? sqlOld : sqlOld + ";");
                return oldSqlBound;
            }

            private String delOneColumn(String sqlOld, ResultMapping idResultMap, ArrayList<String> values) {
                sqlOld = sqlOld.replaceFirst("(?i)" + idResultMap.getColumn() + "\\s*,", "");
                String[] split = sqlOld.split("(?i)VALUES");
                String sql1 = split[0];
                StringBuilder builder = new StringBuilder();
                builder.append(sql1);
                builder.append(" VALUES ");
                for (int i = 0; i < values.size(); ++i) {
                    String item = values.get(i).replaceFirst("\\?\\s*,", "");
                    if (i != values.size() - 1) {
                        item = item + ",";
                    }
                    builder.append(item);
                }
                sqlOld = builder.toString();
                return sqlOld;
            }
        }
        ,
        GROUP_CONCAT{

            @Override
            public boolean shouldProcess(KingBaseDynamicBoundSql originSql, Invocation invocation) {
                String lowerSql = originSql.getSql().toUpperCase();
                return lowerSql.contains("GROUP_CONCAT(");
            }

            @Override
            public KingBaseDynamicBoundSql process(KingBaseDynamicBoundSql oldSql, Invocation invocation) {
                String sql = oldSql.getSql();
                String funcOld = "(?i)" + this.name() + "\\(";
                String funcNew = "WM_CONCAT\\(";
                sql = sql.replaceAll(funcOld, funcNew);
                oldSql.setSql(sql);
                return oldSql;
            }
        }
        ,
        RETURNING_ID{

            @Override
            public boolean shouldProcess(KingBaseDynamicBoundSql originSql, Invocation invocation) {
                MappedStatement statement = (MappedStatement)invocation.getArgs()[0];
                String upperCase = originSql.getSql().toUpperCase();
                return statement.getSqlCommandType() == SqlCommandType.INSERT && statement.getKeyGenerator() != null && !(statement.getKeyGenerator() instanceof NoKeyGenerator) && !upperCase.contains(" RETURNING ");
            }

            @Override
            public KingBaseDynamicBoundSql process(KingBaseDynamicBoundSql oldSql, Invocation invocation) {
                ResultMap baseResultMap = ProcessTokenEnum.getBaseResultMap(invocation);
                ResultMapping idResultMapping = baseResultMap == null ? null : (ResultMapping)baseResultMap.getIdResultMappings().get(0);
                String sql = oldSql.getSql().toUpperCase();
                if (idResultMapping != null) {
                    String rgx = "(?i)INSERT\\s+INTO[\\s\\S]+?VALUES([\\s\\S]+?)(?=;|$)";
                    sql = sql.replaceFirst(rgx, "$0 RETURNING " + idResultMapping.getColumn() + " INTO :" + idResultMapping.getColumn());
                    oldSql.setSql(sql);
                }
                return oldSql;
            }
        };

        private static volatile Map<String, ResultMap> resultMaps;

        public boolean shouldProcess(KingBaseDynamicBoundSql originSql, Invocation invocation) {
            return false;
        }

        public KingBaseDynamicBoundSql process(KingBaseDynamicBoundSql oldSql, Invocation invocation) {
            return oldSql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Map<String, ResultMap> getResultMaps(Invocation invocation) {
            if (resultMaps != null) return resultMaps;
            Class<KingbaseKeywordInterceptor> clazz = KingbaseKeywordInterceptor.class;
            synchronized (KingbaseKeywordInterceptor.class) {
                if (resultMaps != null) return resultMaps;
                MappedStatement arg0 = (MappedStatement)invocation.getArgs()[0];
                Configuration configuration = arg0.getConfiguration();
                Field resultMapField = Configuration.class.getDeclaredField("resultMaps");
                resultMapField.setAccessible(true);
                resultMaps = (Map)resultMapField.get(configuration);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return resultMaps;
            }
        }

        private static ResultMap getBaseResultMap(Invocation invocation) {
            Object arg0 = invocation.getArgs()[0];
            if (arg0 instanceof MappedStatement) {
                MappedStatement statement = (MappedStatement)arg0;
                String id = statement.getId();
                String mapperNameSpace = id.substring(0, id.lastIndexOf("."));
                Map<String, ResultMap> resultMaps = ProcessTokenEnum.getResultMaps(invocation);
                ResultMap baseResultMap = null;
                try {
                    baseResultMap = resultMaps.get(mapperNameSpace + "." + "BaseResultMap");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return baseResultMap;
            }
            return null;
        }
    }
}

