/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.dbinterceptors.kingbase;

import com.chinamcloud.spider.system.config.dbinterceptors.KingbaseKeywordInterceptor;
import com.chinamcloud.spider.system.config.dbinterceptors.kingbase.KingBaseDynamicBoundSql;
import java.util.Objects;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;

public class KingBaseDynamicSqlSource
implements SqlSource {
    private SqlSource sqlSourceOriginal;
    private Invocation invocation;

    private KingBaseDynamicSqlSource(SqlSource sqlSourceOriginal, Invocation invocation) {
        this.sqlSourceOriginal = sqlSourceOriginal;
        this.invocation = invocation;
    }

    public BoundSql getBoundSql(Object parameterObject) {
        return KingBaseDynamicSqlSource.processSql(this.sqlSourceOriginal.getBoundSql(parameterObject), this.invocation);
    }

    public static KingBaseDynamicSqlSource getDynamicSqlSource(SqlSource sqlSourceOriginal, Invocation invocation) {
        if (sqlSourceOriginal == null) {
            return null;
        }
        if (sqlSourceOriginal instanceof KingBaseDynamicSqlSource) {
            KingBaseDynamicSqlSource sourceOriginal = (KingBaseDynamicSqlSource)sqlSourceOriginal;
            if (!Objects.equals(invocation, sourceOriginal.getInvocation())) {
                sourceOriginal.setInvocation(invocation);
            }
            return sourceOriginal;
        }
        return new KingBaseDynamicSqlSource(sqlSourceOriginal, invocation);
    }

    private static BoundSql processSql(BoundSql boundSql, Invocation invocation) {
        KingbaseKeywordInterceptor.ProcessTokenEnum[] values = KingbaseKeywordInterceptor.ProcessTokenEnum.values();
        if (boundSql instanceof KingBaseDynamicBoundSql) {
            return boundSql;
        }
        KingBaseDynamicBoundSql dynamicSqlBound = KingBaseDynamicBoundSql.getDynamicSqlBound(boundSql);
        for (KingbaseKeywordInterceptor.ProcessTokenEnum value : values) {
            if (!value.shouldProcess(dynamicSqlBound, invocation)) continue;
            dynamicSqlBound = value.process(dynamicSqlBound, invocation);
        }
        return dynamicSqlBound;
    }

    public SqlSource getSqlSourceOriginal() {
        return this.sqlSourceOriginal;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public void setSqlSourceOriginal(SqlSource sqlSourceOriginal) {
        this.sqlSourceOriginal = sqlSourceOriginal;
    }

    public void setInvocation(Invocation invocation) {
        this.invocation = invocation;
    }
}

