/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.interceptors.postgresql;

import com.alibaba.druid.util.StringUtils;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PostgreSqlPrepareInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        String originalSql;
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        String modifiedSql = originalSql = boundSql.getSql();
        for (TokenProcess value : TokenProcess.values()) {
            modifiedSql = value.process(originalSql);
        }
        if (!StringUtils.equals((String)originalSql, (String)modifiedSql)) {
            metaObject.setValue("delegate.boundSql.sql", (Object)modifiedSql);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static enum TokenProcess {
        QUOTE{
            final String[] QUOTE_TOKEN = new String[]{"LEVEL", "COMMENT", "SYNONYM", "SYSTEM", "STAT", "RULE", "PAGE", "MAP", "JOB", "DAILY", "CATALOG", "ROLE_ID", "VALUE", "TYPE"};

            @Override
            public String process(String sql) {
                for (String s : this.QUOTE_TOKEN) {
                    sql = sql.replaceAll("(?i)(?<=[\\s,.])+" + s + "(?=[\\s,])+", "\"$0\"");
                }
                return sql;
            }
        };


        protected String process(String oldSql) {
            return oldSql;
        }
    }
}

