/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.dbinterceptors;

import com.alibaba.druid.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DMKeywordInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        BoundSql boundSql;
        String sql;
        String processedSql;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameterObject = null;
        if (invocation.getArgs().length > 1) {
            parameterObject = invocation.getArgs()[1];
        }
        if (!StringUtils.equalsIgnoreCase((String)(processedSql = this.processSql(sql = (boundSql = mappedStatement.getBoundSql(parameterObject)).getSql())), (String)sql)) {
            final BoundSql boundSqlUpdate = this.updateBoundSql(boundSql, processedSql);
            final SqlSource sqlSource = mappedStatement.getSqlSource();
            Class<?> mappedStatementClass = mappedStatement.getClass();
            Field sqlSourceField = mappedStatementClass.getDeclaredField("sqlSource");
            sqlSourceField.setAccessible(true);
            final Object finalParameterObject = parameterObject;
            sqlSourceField.set(mappedStatement, new SqlSource(){

                public BoundSql getBoundSql(Object parameterObjectParam) {
                    if (Objects.equals(parameterObjectParam, finalParameterObject)) {
                        return boundSqlUpdate;
                    }
                    return sqlSource.getBoundSql(parameterObjectParam);
                }
            });
        }
        return invocation.proceed();
    }

    private BoundSql updateBoundSql(BoundSql boundSql, String newSql) {
        try {
            Class<?> boundSqlClass = boundSql.getClass();
            Field sqlField = boundSqlClass.getDeclaredField("sql");
            sqlField.setAccessible(true);
            sqlField.set(boundSql, newSql);
            return boundSql;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update BoundSql", e);
        }
    }

    private String processSql(String sql) {
        ProcessTokenEnum[] values;
        for (ProcessTokenEnum value : values = ProcessTokenEnum.values()) {
            if (!value.shouldProcess(sql)) continue;
            sql = value.process(sql);
        }
        return sql;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static enum ProcessTokenEnum {
        KEYWORD{
            final String[] targetToken = new String[]{"comment"};

            @Override
            protected boolean shouldProcess(String originSql) {
                for (String token : this.targetToken) {
                    if (!originSql.contains(token)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String process(String oldSql) {
                String processSql = oldSql;
                for (String s : this.targetToken) {
                    processSql = oldSql.replaceAll("\\b(" + s + "+)\\b", "\"$1\"");
                }
                return processSql;
            }
        }
        ,
        SUBDATE{

            @Override
            protected boolean shouldProcess(String originSql) {
                return super.shouldProcess(originSql);
            }
        };


        protected boolean shouldProcess(String originSql) {
            return false;
        }

        public String process(String oldSql) {
            return oldSql;
        }
    }
}

