package com.chinamcloud.spider.system.config;

import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.util.Iterator;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/8/4
 * Time: 下午1:55
 */
@Slf4j
@Getter
public class NoAuthConfig {


    public List<String> patternPathList;

    private static class NoAuthConfigHolder{
        private static final NoAuthConfig noAuthConfig = new NoAuthConfig();
    }
    public static final NoAuthConfig getInstance() {
        return NoAuthConfigHolder.noAuthConfig;
    }

    private NoAuthConfig() {
        initialization();
    }

    private void initialization() {
        String configPath = "config/noAuth.xml";
        log.info("*** NoAuthConfig init begin ***");
        try {
            patternPathList = Lists.newArrayList();
            SAXReader reader = new SAXReader();
            Document document = reader.read(NoAuthConfig.class.getClassLoader().getResource(configPath).getPath());
            Element rootElement = document.getRootElement();
            Iterator iterator = rootElement.elementIterator();
            for (;iterator.hasNext();){
                Element next = (Element)iterator.next();
                patternPathList.add(next.getText());
            }
            log.info("*** NoAuthConfig init end ***");
        } catch (DocumentException e) {
            log.error("NoAuthConfig init error,{}",configPath,e);
        }
    }
}
