package com.chinamcloud.spider.system.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 接口文档的配置
 * Created by jyy on 17/6/6.
 */
@Configuration
@EnableSwagger2
public class Swagger2Config {

    @Value("${spring.application.name}")
    private String pathMapping;

    @Bean
    public Docket createRestApi() {
        List<Parameter> parameterList = new ArrayList<Parameter>();
        ParameterBuilder tokenParameterBuilder = new ParameterBuilder();
        tokenParameterBuilder.name("token").description("第三方凭证：传递后台第三方token或sessionId，用于换取后台的授权认证access_token,仅初次验证时使用").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        parameterList.add(tokenParameterBuilder.build());
        ParameterBuilder accessTokenParameterBuilder = new ParameterBuilder();
        accessTokenParameterBuilder.name("access_token").description("用户登录凭证：获取后台授权认证后，每次接口请求都要传递").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        parameterList.add(accessTokenParameterBuilder.build());
        ParameterBuilder grantTypeParameterBuilder = new ParameterBuilder();
        grantTypeParameterBuilder.name("grant_type").description("认证类型").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        parameterList.add(grantTypeParameterBuilder.build());
        ParameterBuilder tenantIdParameterBuilder = new ParameterBuilder();
        tenantIdParameterBuilder.name("tenantId").description("租户id").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        parameterList.add(tenantIdParameterBuilder.build());
        HashSet  contentType  = new HashSet<>();
        contentType.add("application/x-www-form-urlencoded;charset=UTF-8");
        return new Docket(DocumentationType.SWAGGER_2).groupName("client")
                .apiInfo(clientInfo())
                .select()
                .paths(PathSelectors.any())
                .build().globalOperationParameters(parameterList).consumes(contentType).apiInfo(clientInfo()).alternateTypeRules();
    }
    private ApiInfo clientInfo() {
        return new ApiInfoBuilder()
                .title("Client  相关的接口")//大标题
                .description("REST API 设计在细节上有很多自己独特的需要注意的技巧，并且对开发人员在构架设计能力上比传统 API 有着更高的要求")//详细描述
                .version("1.0")//版本
                .build();
    }


}
