/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.filter;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.filter.OncePerRequestFilter;

public class ParameterFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if ("POST".equals(request.getMethod()) && (request.getContentType().contains("text/plain") || request.getContentType().contains("application/json"))) {
            LinkedMultiValueMap formParameters = new LinkedMultiValueMap();
            try {
                String str;
                BufferedReader br = request.getReader();
                StringBuilder data = new StringBuilder();
                while ((str = br.readLine()) != null) {
                    data.append(str);
                }
                JSONObject dataObj = JSONObject.parseObject((String)data.toString());
                formParameters.add((Object)"tenantid", (Object)dataObj.getString("tenantid"));
                formParameters.add((Object)"uid", (Object)dataObj.getString("uid"));
                formParameters.add((Object)"username", (Object)dataObj.getString("username"));
                formParameters.add((Object)"token", (Object)dataObj.getString("token"));
            }
            catch (Exception br) {
                // empty catch block
            }
            HttpFormContentRequestWrapper wrapper = new HttpFormContentRequestWrapper(request, (MultiValueMap)formParameters);
            filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static class HttpFormContentRequestWrapper
    extends HttpServletRequestWrapper {
        private MultiValueMap<String, String> formParameters;

        private HttpFormContentRequestWrapper(HttpServletRequest request, MultiValueMap<String, String> parameters) {
            super(request);
            this.formParameters = parameters != null ? parameters : new LinkedMultiValueMap();
        }

        public String getParameter(String name) {
            String queryStringValue = super.getParameter(name);
            String formValue = (String)this.formParameters.getFirst((Object)name);
            return queryStringValue != null ? queryStringValue : formValue;
        }

        public Map<String, String[]> getParameterMap() {
            LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
            Enumeration<String> names = this.getParameterNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                result.put(name, this.getParameterValues(name));
            }
            return result;
        }

        public Enumeration<String> getParameterNames() {
            LinkedHashSet names = new LinkedHashSet();
            names.addAll(Collections.list(super.getParameterNames()));
            names.addAll(this.formParameters.keySet());
            return Collections.enumeration(names);
        }

        public String[] getParameterValues(String name) {
            String[] queryStringValues = super.getParameterValues(name);
            List formValues = (List)this.formParameters.get((Object)name);
            if (formValues == null) {
                return queryStringValues;
            }
            if (queryStringValues == null) {
                return formValues.toArray(new String[formValues.size()]);
            }
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(Arrays.asList(queryStringValues));
            result.addAll(formValues);
            return result.toArray(new String[result.size()]);
        }
    }
}

