/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.network;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.produce.common.api.vo.HttpSendResult;
import com.chinamcloud.produce.common.api.vo.ResultDTO;
import com.chinamcloud.produce.common.network.HttpClientService;
import com.chinamcloud.produce.common.utils.DateUtil;
import com.chinamcloud.produce.common.utils.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkService {
    private static final Logger log = LoggerFactory.getLogger(NetworkService.class);

    public static String generateMD5(String sb) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md = md5.digest(sb.getBytes());
            return new String(new Hex().encode(md));
        }
        catch (NoSuchAlgorithmException var5) {
            var5.printStackTrace();
            return "";
        }
    }

    public static String getUserInfo(String tenantid, String uid, String appkey, String appsecret, String url) {
        log.info("\u8bf7\u6c42\u7f51\u7ba1\u4e2d\u5fc3\u83b7\u53d6\u7528\u6237\u4fe1\u606f...");
        JSONArray uids = new JSONArray();
        uids.add((Object)uid);
        JSONObject params = new JSONObject();
        params.put("userid", (Object)uids);
        String action = "getUserInfo";
        try {
            String resultJson = NetworkService.postNetworkByAction(params, url, action, appkey, appsecret, tenantid);
            if (StringUtil.isNotEmpty(resultJson)) {
                JSONObject resultJO = JSONObject.parseObject((String)resultJson);
                if ("0".equals(resultJO.getString("returnCode"))) {
                    JSONArray returnData = resultJO.getJSONArray("returnData");
                    if (returnData.size() > 0) {
                        return returnData.getString(0);
                    }
                    log.error("\u8bf7\u6c42\u7f51\u7ba1\u4e2d\u5fc3\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
                } else {
                    log.error("\u8bf7\u6c42\u7f51\u7ba1\u4e2d\u5fc3\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25!");
                }
            } else {
                log.error("\u8c03\u7528\u7f51\u7ba1\u4e2d\u5fc3\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getUserInfoByUsername(String tenantid, String username, String appkey, String appsecret, String url) {
        log.info("\u8bf7\u6c42\u7f51\u7ba1\u4e2d\u5fc3\u83b7\u53d6\u7528\u6237\u4fe1\u606f...");
        JSONObject params = new JSONObject();
        params.put("username", (Object)username);
        String action = "getUserInfo";
        try {
            String resultJson = NetworkService.postNetworkByAction(params, url, action, appkey, appsecret, tenantid);
            if (StringUtil.isNotEmpty(resultJson)) {
                JSONObject resultJO = JSONObject.parseObject((String)resultJson);
                if ("0".equals(resultJO.getString("returnCode"))) {
                    JSONArray returnData = resultJO.getJSONArray("returnData");
                    if (returnData.size() > 0) {
                        return returnData.getString(0);
                    }
                    log.error("\u8bf7\u6c42\u7f51\u7ba1\u4e2d\u5fc3\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
                } else {
                    log.error("\u8bf7\u6c42\u7f51\u7ba1\u4e2d\u5fc3\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25!");
                }
            } else {
                log.error("\u8c03\u7528\u7f51\u7ba1\u4e2d\u5fc3\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getTokenFromNetwork(String uid, String appkey, String appsecret, String url, String tenantid) {
        String token = "";
        try {
            log.info("\u8bf7\u6c42\u83b7\u53d6\u7f51\u7ba1\u4e2d\u5fc3TOKEN");
            JSONObject params = new JSONObject();
            params.put("uid", (Object)uid);
            String action = "getAppToken";
            String resultJson = NetworkService.postNetworkByAction(params, url, action, appkey, appsecret, tenantid);
            JSONObject tokenJson = JSONObject.parseObject((String)resultJson);
            if (0 == tokenJson.getInteger("returnCode")) {
                token = tokenJson.getJSONObject("returnData").getString("token");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("getTokenFromNetwork Exception:" + e.getMessage());
        }
        return token;
    }

    public static ResultDTO<JSONObject> getPermission(String uid, String token, String appkey, String appsecret, String url, String tenantid) {
        block8: {
            log.info("\u8bf7\u6c42\u83b7\u53d6\u7f51\u7ba1\u4e2d\u5fc3Permission");
            String type = "1";
            JSONObject params = new JSONObject();
            params.put("token", (Object)token);
            params.put("uid", (Object)uid);
            params.put("type", (Object)type);
            String action = "getPermission";
            try {
                String resultJson = NetworkService.postNetworkByAction(params, url, action, appkey, appsecret, tenantid);
                if (!StringUtil.isNotEmpty(resultJson)) break block8;
                JSONObject item = JSONObject.parseObject((String)resultJson);
                if ("0".equals(item.getString("returnCode"))) {
                    JSONObject resultItem = item.getJSONObject("returnData");
                    try {
                        JSONObject columnPermission = resultItem.getJSONObject("columnPermission");
                        JSONObject newColumnPermission = new JSONObject();
                        for (String key : columnPermission.keySet()) {
                            JSONArray itemJa = columnPermission.getJSONArray(key);
                            JSONArray newItemJa = new JSONArray();
                            for (int i = 0; i < itemJa.size(); ++i) {
                                String jaValue = itemJa.getString(i);
                                if ("del".equals(jaValue)) {
                                    jaValue = "delete";
                                }
                                newItemJa.add((Object)jaValue);
                            }
                            newColumnPermission.put(key, (Object)newItemJa);
                        }
                        resultItem.put("columnPermission", (Object)newColumnPermission);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return ResultDTO.successfy(resultItem, "\u83b7\u53d6\u6210\u529f");
                }
                return ResultDTO.fail(item.getString("returnDesc"));
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u7f51\u7ba1\u8fd4\u56de\u53c2\u6570\u9519\u8bef:" + e.getMessage());
            }
        }
        return ResultDTO.fail("\u8bf7\u6c42\u6743\u9650\u4e2d\u5fc3\u5931\u8d25!");
    }

    public static String postNetworkByAction(JSONObject params, String url, String action, String appKey, String appSecret, String tenantId) {
        List<Object> list = Arrays.asList(params.keySet().toArray());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (Object obj : list) {
            sb.append(obj).append(params.get(obj));
        }
        sb.append(appSecret);
        String sign = NetworkService.generateMD5(sb.toString());
        params.put("action", (Object)action);
        params.put("appKey", (Object)appKey);
        params.put("tenantid", (Object)tenantId);
        params.put("sign", (Object)sign);
        params.put("timestamp", (Object)DateUtil.getCurrentDateTime());
        String result = HttpClientService.sendPostByURLConnection(url, "parameter=" + params.toString());
        return result;
    }

    public static String validateToken(String token, String url) {
        HttpSendResult httpSendResult = HttpClientService.sendMessageByJson_POST_FORM_AUTHORIZATION(null, url, token);
        log.debug("\u9a8c\u8bc1token\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)httpSendResult);
        if (httpSendResult.isSuccess()) {
            return httpSendResult.getResult();
        }
        return "";
    }
}

