/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.system.cache;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCache {
    private static final Logger log = LoggerFactory.getLogger(ConfigCache.class);
    private static ThreadLocal<Map<String, String>> configThreadLocal;
    private static ThreadLocal<Map<String, String>> xtrimmerThreadLocal;

    public static String getValue(String key) {
        if (configThreadLocal == null || configThreadLocal.get() == null || !configThreadLocal.get().containsKey(key)) {
            log.warn("\u914d\u7f6e\u9879[{}]\u672a\u627e\u5230!!!", (Object)key);
        }
        return configThreadLocal.get().get(key);
    }

    private static void setThreadLocal() {
        if (configThreadLocal == null) {
            configThreadLocal = new ThreadLocal();
        }
        if (configThreadLocal.get() == null) {
            configThreadLocal.set(new HashMap());
        }
    }

    public static synchronized void setAll(Map map) {
        if (configThreadLocal == null) {
            configThreadLocal = new ThreadLocal();
        }
        configThreadLocal.set(map);
    }

    public static synchronized void setValue(String key, String value) {
        ConfigCache.setThreadLocal();
        configThreadLocal.get().put(key, value);
    }

    public static synchronized void setXtrimmerValue(String key, String value) {
        ConfigCache.setXtrimmerThreadLocal();
        xtrimmerThreadLocal.get().put(key, value);
    }

    public static String getXtrimmerValue(String key) {
        if (xtrimmerThreadLocal == null || xtrimmerThreadLocal.get() == null || !xtrimmerThreadLocal.get().containsKey(key)) {
            log.warn("\u914d\u7f6e\u9879[{}]\u672a\u627e\u5230!!!", (Object)key);
        }
        return xtrimmerThreadLocal.get().get(key);
    }

    private static void setXtrimmerThreadLocal() {
        if (xtrimmerThreadLocal == null) {
            xtrimmerThreadLocal = new ThreadLocal();
        }
        if (xtrimmerThreadLocal.get() == null) {
            xtrimmerThreadLocal.set(new HashMap());
        }
    }

    public static void removeThreadLocal() {
        log.debug("remove system config ThreadLocal...");
        if (configThreadLocal != null) {
            configThreadLocal.remove();
        }
    }

    public static void removeXtrimmerThreadLocal() {
        log.debug("remove xtrimmer system config ThreadLocal...");
        if (xtrimmerThreadLocal != null) {
            xtrimmerThreadLocal.remove();
        }
    }
}

