/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.utils;

import com.chinamcloud.produce.common.utils.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String Format_Date = "yyyy-MM-dd";
    public static final String Format_Time = "HH:mm:ss";
    public static final String Format_DateTime = "yyyy-MM-dd HH:mm:ss";

    public static String getCurrentDate() {
        return new SimpleDateFormat(Format_Date).format(new Date());
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat t = new SimpleDateFormat(format);
        return t.format(new Date());
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat(Format_Time).format(new Date());
    }

    public static String getCurrentTime(String format) {
        SimpleDateFormat t = new SimpleDateFormat(format);
        return t.format(new Date());
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime(Format_DateTime);
    }

    public static int getDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        return cal.get(7);
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(5);
    }

    public static int getDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getMaxDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static String getFirstDayOfMonth(String date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.parse(date));
        cal.set(5, 1);
        return new SimpleDateFormat(Format_Date).format(cal.getTime());
    }

    public static int getDayOfYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(6);
    }

    public static int getDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int getDayOfWeek(String date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.parse(date));
        return cal.get(7);
    }

    public static int getDayOfMonth(String date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.parse(date));
        return cal.get(5);
    }

    public static int getDayOfYear(String date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.parse(date));
        return cal.get(6);
    }

    public static String getCurrentDateTime(String format) {
        SimpleDateFormat t = new SimpleDateFormat(format);
        return t.format(new Date());
    }

    public static String toString(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(Format_Date).format(date);
    }

    public static String toDateTimeString(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(Format_DateTime).format(date);
    }

    public static String toDateTimeString(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return dateTime.format(DateTimeFormatter.ofPattern(Format_DateTime));
    }

    public static String toString(Date date, String format) {
        SimpleDateFormat t = new SimpleDateFormat(format);
        return t.format(date);
    }

    public static String toTimeString(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(Format_Time).format(date);
    }

    public static int compare(String date1, String date2) {
        return DateUtil.compare(date1, date2, Format_Date);
    }

    public static int compareTime(String time1, String time2) {
        return DateUtil.compareTime(time1, time2, Format_Time);
    }

    public static int compare(String date1, String date2, String format) {
        Date d1 = DateUtil.parse(date1, format);
        Date d2 = DateUtil.parse(date2, format);
        return d1.compareTo(d2);
    }

    public static int compareTime(String time1, String time2, String format) {
        String[] arr1 = time1.split(":");
        String[] arr2 = time2.split(":");
        if (arr1.length < 2) {
            throw new RuntimeException("\u9519\u8bef\u7684\u65f6\u95f4\u503c:" + time1);
        }
        if (arr2.length < 2) {
            throw new RuntimeException("\u9519\u8bef\u7684\u65f6\u95f4\u503c:" + time2);
        }
        int h1 = Integer.parseInt(arr1[0]);
        int m1 = Integer.parseInt(arr1[1]);
        int h2 = Integer.parseInt(arr2[0]);
        int m2 = Integer.parseInt(arr2[1]);
        int s1 = 0;
        int s2 = 0;
        if (arr1.length == 3) {
            s1 = Integer.parseInt(arr1[2]);
        }
        if (arr2.length == 3) {
            s2 = Integer.parseInt(arr2[2]);
        }
        if (h1 < 0 || h1 > 23 || m1 < 0 || m1 > 59 || s1 < 0 || s1 > 59) {
            throw new RuntimeException("\u9519\u8bef\u7684\u65f6\u95f4\u503c:" + time1);
        }
        if (h2 < 0 || h2 > 23 || m2 < 0 || m2 > 59 || s2 < 0 || s2 > 59) {
            throw new RuntimeException("\u9519\u8bef\u7684\u65f6\u95f4\u503c:" + time2);
        }
        if (h1 != h2) {
            return h1 > h2 ? 1 : -1;
        }
        if (m1 == m2) {
            if (s1 == s2) {
                return 0;
            }
            return s1 > s2 ? 1 : -1;
        }
        return m1 > m2 ? 1 : -1;
    }

    public static boolean isTime(String time) {
        String[] arr = time.split(":");
        if (arr.length < 2) {
            return false;
        }
        try {
            int h = Integer.parseInt(arr[0]);
            int m = Integer.parseInt(arr[1]);
            int s = 0;
            if (arr.length == 3) {
                s = Integer.parseInt(arr[2]);
            }
            if (h < 0 || h > 23 || m < 0 || m > 59 || s < 0 || s > 59) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getDuration(String end, String start) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(Format_DateTime);
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long diff = sdf.parse(end).getTime() - sdf.parse(start).getTime();
        long hour = diff / nh;
        long min = diff % nh / nm;
        long ss = diff % nh % nm / ns;
        String hourStr = hour / 10L > 0L ? String.valueOf(hour) : "0" + hour;
        String minStr = min / 10L > 0L ? String.valueOf(min) : "0" + min;
        String ssStr = ss / 10L > 0L ? String.valueOf(ss) : "0" + ss;
        return hourStr + ":" + minStr + ":" + ssStr;
    }

    public static boolean isDate(String date) {
        String[] arr = date.split("-");
        if (arr.length < 3) {
            return false;
        }
        try {
            int y = Integer.parseInt(arr[0]);
            int m = Integer.parseInt(arr[1]);
            int d = Integer.parseInt(arr[2]);
            if (y < 0 || m > 12 || m < 0 || d < 0 || d > 31) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isWeekend(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int t = cal.get(7);
        return t == 7 || t == 1;
    }

    public static boolean isWeekend(String str) {
        return DateUtil.isWeekend(DateUtil.parse(str));
    }

    public static Date getDate(Object obj) {
        Date date;
        block8: {
            date = null;
            try {
                try {
                    date = (Date)obj;
                }
                catch (Exception e) {
                    try {
                        date = DateUtil.parseDateTime(obj.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (date != null) break block8;
                try {
                    LocalDateTime dateTime = (LocalDateTime)obj;
                    date = DateUtil.localDateTime2Date(dateTime);
                }
                catch (Exception e) {
                    throw new RuntimeException(obj + "\u975e\u6807\u51c6\u65f6\u95f4\u683c\u5f0f");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public static LocalDateTime getDateTime(Object obj) {
        LocalDateTime dateTime;
        block10: {
            dateTime = null;
            try {
                try {
                    dateTime = (LocalDateTime)obj;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dateTime != null) break block10;
                try {
                    Date date = null;
                    try {
                        date = (Date)obj;
                    }
                    catch (Exception e) {
                        try {
                            date = DateUtil.parseDateTime(obj.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    dateTime = DateUtil.date2LocalDateTime(date);
                }
                catch (Exception e) {
                    throw new RuntimeException(obj + "\u975e\u6807\u51c6\u65f6\u95f4\u683c\u5f0f");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateTime;
    }

    public static Date parse(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        try {
            return new SimpleDateFormat(Format_Date).parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parse(String str, String format) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        try {
            SimpleDateFormat t = new SimpleDateFormat(format);
            return t.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDateTime(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (str.length() <= 10) {
            return DateUtil.parse(str);
        }
        try {
            return new SimpleDateFormat(Format_DateTime).parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDateTime(String str, String format) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        try {
            SimpleDateFormat t = new SimpleDateFormat(format);
            return t.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date addMinute(Date date, int count) {
        return new Date(date.getTime() + 60000L * (long)count);
    }

    public static Date addHour(Date date, int count) {
        return new Date(date.getTime() + 3600000L * (long)count);
    }

    public static Date addDay(Date date, int count) {
        return new Date(date.getTime() + 86400000L * (long)count);
    }

    public static Date addWeek(Date date, int count) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(3, count);
        return c.getTime();
    }

    public static Date addMonth(Date date, int count) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, count);
        return c.getTime();
    }

    public static Date addYear(Date date, int count) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, count);
        return c.getTime();
    }

    public static String toDisplayDateTime(String date) {
        if (StringUtil.isEmpty(date)) {
            return null;
        }
        try {
            if (DateUtil.isDate(date)) {
                return DateUtil.toDisplayDateTime(DateUtil.parse(date));
            }
            SimpleDateFormat t = new SimpleDateFormat(Format_DateTime);
            Date d = t.parse(date);
            return DateUtil.toDisplayDateTime(d);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "\u4e0d\u662f\u6807\u51c6\u683c\u5f0f\u65f6\u95f4!";
        }
    }

    public static String toDisplayDateTime(Date date) {
        long minite = (System.currentTimeMillis() - date.getTime()) / 60000L;
        if (minite < 60L) {
            return DateUtil.toString(date, Format_Date) + " " + minite + "\u5206\u949f\u524d";
        }
        if (minite < 1440L) {
            return DateUtil.toString(date, Format_Date) + " " + minite / 60L + "\u5c0f\u65f6\u524d";
        }
        return DateUtil.toString(date, Format_Date) + " " + minite / 1440L + "\u5929\u524d";
    }

    public static String convertChineseNumber(String strDate) {
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u4e00", "11");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u4e8c", "12");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u4e09", "13");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u56db", "14");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u4e94", "15");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u516d", "16");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u4e03", "17");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u516b", "18");
        strDate = StringUtil.replaceEx(strDate, "\u4e00\u5341\u4e5d", "19");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u4e00", "21");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u4e8c", "22");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u4e09", "23");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u56db", "24");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u4e94", "25");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u516d", "26");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u4e03", "27");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u516b", "28");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341\u4e5d", "29");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u4e00", "11");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u4e8c", "12");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u4e09", "13");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u56db", "14");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u4e94", "15");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u516d", "16");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u4e03", "17");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u516b", "18");
        strDate = StringUtil.replaceEx(strDate, "\u5341\u4e5d", "19");
        strDate = StringUtil.replaceEx(strDate, "\u5341", "10");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c\u5341", "20");
        strDate = StringUtil.replaceEx(strDate, "\u4e09\u5341", "20");
        strDate = StringUtil.replaceEx(strDate, "\u4e09\u5341\u4e00", "31");
        strDate = StringUtil.replaceEx(strDate, "\u96f6", "0");
        strDate = StringUtil.replaceEx(strDate, "\u25cb", "0");
        strDate = StringUtil.replaceEx(strDate, "\u4e00", "1");
        strDate = StringUtil.replaceEx(strDate, "\u4e8c", "2");
        strDate = StringUtil.replaceEx(strDate, "\u4e09", "3");
        strDate = StringUtil.replaceEx(strDate, "\u56db", "4");
        strDate = StringUtil.replaceEx(strDate, "\u4e94", "5");
        strDate = StringUtil.replaceEx(strDate, "\u516d", "6");
        strDate = StringUtil.replaceEx(strDate, "\u4e03", "7");
        strDate = StringUtil.replaceEx(strDate, "\u516b", "8");
        strDate = StringUtil.replaceEx(strDate, "\u4e5d", "9");
        return strDate;
    }

    public static String getTimeStr(long second) {
        String second2;
        String minite;
        String timsStr = "";
        String hourStr = String.valueOf(second / 3600L);
        long second1 = second % 3600L;
        if (hourStr.length() == 1) {
            hourStr = "0" + hourStr;
        }
        if ((minite = String.valueOf(second1 / 60L)).length() == 1) {
            minite = "0" + minite;
        }
        if ((second2 = String.valueOf(second1 % 60L)).length() == 1) {
            second2 = "0" + second2;
        }
        timsStr = hourStr + ":" + minite + ":" + second2;
        return timsStr;
    }

    public static String getFormatTimeStr(String timeStr) {
        String str = "";
        if (timeStr.length() != 0) {
            str = timeStr.replaceAll(":", "'");
        }
        return str;
    }

    public static String getTotalSecond(String dateStr) {
        String result = "";
        if (StringUtil.isNotEmpty(dateStr) && dateStr.contains(":")) {
            String[] arr = dateStr.split(":");
            Long hour = Long.valueOf(arr[0]) * 60L * 60L;
            Long min = Long.valueOf(arr[1]) * 60L;
            Long second = Long.valueOf(arr[2]);
            result = String.valueOf(hour + min + second);
        } else {
            result = "0";
        }
        return result;
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        try {
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            return instant.atZone(zoneId).toLocalDateTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        try {
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime zdt = localDateTime.atZone(zoneId);
            return Date.from(zdt.toInstant());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

