/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.utils;

import com.chinamcloud.produce.common.utils.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final String GlobalCharset = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(String filePath, String parameterName, String parameterValue) {
        Properties prop = new Properties();
        InputStream in = null;
        FileOutputStream fos = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filePath));
            prop.load(in);
            fos = new FileOutputStream(filePath);
            prop.setProperty(parameterName, parameterValue);
            prop.store(fos, "Update '" + parameterName + "' value");
        }
        catch (IOException e) {
            System.err.println("Visit " + filePath + " for updating " + parameterName + " value error");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String readValue(String filePath, String key) {
        Properties props = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            props.load(in);
            String value = props.getProperty(key);
            System.out.println("set key: " + key + " ,value: " + value);
            ((InputStream)in).close();
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean writeText(String fileName, String content) {
        return FileUtil.writeText(fileName, content, GlobalCharset);
    }

    public static boolean writeText(String fileName, String content, String encoding) {
        return FileUtil.writeText(fileName, content, encoding, false);
    }

    public static boolean writeText(String fileName, String content, String encoding, boolean bomFlag) {
        try {
            byte[] bs = content.getBytes(encoding);
            if (encoding.equalsIgnoreCase(GlobalCharset) && bomFlag) {
                bs = ArrayUtils.addAll((byte[])StringUtil.BOM, (byte[])bs);
            }
            FileUtil.writeByte(fileName, bs);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static byte[] readByte(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            byte[] r = new byte[fis.available()];
            fis.read(r);
            fis.close();
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readByte(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            byte[] r = FileUtil.readByte(fis);
            fis.close();
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readByte(InputStream is) {
        try {
            byte[] r = new byte[is.available()];
            is.read(r);
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean writeByte(String fileName, byte[] b) {
        return FileUtil.writeByte(new File(fileName), b);
    }

    public static boolean writeByte(File f, byte[] b) {
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));
            fos.write(b);
            fos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String readText(File f) {
        return FileUtil.readText(f, GlobalCharset);
    }

    public static String readText(File f, String encoding) {
        try {
            FileInputStream is = new FileInputStream(f);
            String str = FileUtil.readText(is, encoding);
            ((InputStream)is).close();
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readText(InputStream is, String encoding) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readText(String fileName) {
        return FileUtil.readText(fileName, GlobalCharset);
    }

    public static String readText(String fileName, String encoding) {
        try {
            String line;
            FileInputStream is = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, encoding));
            StringBuffer sb = new StringBuffer();
            int c = br.read();
            if (!encoding.equalsIgnoreCase(GlobalCharset) || c != 65279) {
                sb.append((char)c);
            }
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            ((InputStream)is).close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readFile(String path) {
        return FileUtil.readFile(new File(path), GlobalCharset);
    }

    public static String readFile(String path, String encoding) {
        return FileUtil.readFile(new File(path), encoding);
    }

    public static String readFile(File file) {
        return FileUtil.readFile(file, GlobalCharset);
    }

    public static String readFile(File file, String encoding) {
        try {
            Long fileLength = file.length();
            byte[] fileContent = new byte[fileLength.intValue()];
            FileInputStream in = new FileInputStream(file);
            in.read(fileContent);
            in.close();
            return new String(fileContent, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readURLText(String urlPath) {
        return FileUtil.readURLText(urlPath, GlobalCharset);
    }

    public static String readURLText(String urlPath, String encoding) {
        try {
            String line;
            URL url = new URL(urlPath);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), encoding));
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean delete(String path) {
        File file = new File(path);
        return FileUtil.delete(file);
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            log.warn("\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a" + file);
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        return FileUtil.deleteDir(file);
    }

    private static boolean deleteDir(File dir) {
        try {
            return FileUtil.deleteFromDir(dir) && dir.delete();
        }
        catch (Exception e) {
            log.warn("\u5220\u9664\u6587\u4ef6\u5939\u64cd\u4f5c\u51fa\u9519");
            return false;
        }
    }

    public static boolean mkdir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return true;
    }

    public static boolean deleteEx(String fileName) {
        int index2;
        int index1 = fileName.lastIndexOf("\\");
        index1 = index1 > (index2 = fileName.lastIndexOf("/")) ? index1 : index2;
        String path = fileName.substring(0, index1);
        String name = fileName.substring(index1 + 1);
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!Pattern.matches(name, files[i].getName())) continue;
                files[i].delete();
            }
            return true;
        }
        return false;
    }

    public static boolean deleteFromDir(String dirPath) {
        File file = new File(dirPath);
        return FileUtil.deleteFromDir(file);
    }

    public static boolean deleteFromDir(File dir) {
        if (!dir.exists()) {
            log.warn("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a" + dir);
            return false;
        }
        if (!dir.isDirectory()) {
            log.warn(dir + "\u4e0d\u662f\u6587\u4ef6\u5939");
            return false;
        }
        File[] tempList = dir.listFiles();
        for (int i = 0; i < tempList.length; ++i) {
            if (FileUtil.delete(tempList[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean copy(String oldPath, String newPath, FileFilter filter) {
        File oldFile = new File(oldPath);
        File[] oldFiles = oldFile.listFiles(filter);
        boolean flag = true;
        if (oldFiles != null) {
            for (int i = 0; i < oldFiles.length; ++i) {
                if (FileUtil.copy(oldFiles[i], newPath + "/" + oldFiles[i].getName())) continue;
                flag = false;
            }
        }
        return flag;
    }

    public static boolean copy(String oldPath, String newPath) {
        File oldFile = new File(oldPath);
        return FileUtil.copy(oldFile, newPath);
    }

    public static boolean copy(File oldFile, String newPath) {
        if (!oldFile.exists()) {
            log.warn("\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a" + oldFile);
            return false;
        }
        if (oldFile.isFile()) {
            return FileUtil.copyFile(oldFile, newPath);
        }
        return FileUtil.copyDir(oldFile, newPath);
    }

    private static boolean copyFile(File oldFile, String newPath) {
        if (!oldFile.exists()) {
            log.warn("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + oldFile);
            return false;
        }
        if (!oldFile.isFile()) {
            log.warn(oldFile + "\u4e0d\u662f\u6587\u4ef6");
            return false;
        }
        try {
            int byteread = 0;
            FileInputStream inStream = new FileInputStream(oldFile);
            FileOutputStream fs = new FileOutputStream(newPath);
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            fs.close();
            ((InputStream)inStream).close();
        }
        catch (Exception e) {
            log.warn("\u590d\u5236\u5355\u4e2a\u6587\u4ef6" + oldFile.getPath() + "\u64cd\u4f5c\u51fa\u9519\u3002\u9519\u8bef\u539f\u56e0:" + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean copyDir(File oldDir, String newPath) {
        if (!oldDir.exists()) {
            log.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a" + oldDir);
            return false;
        }
        if (!oldDir.isDirectory()) {
            log.info(oldDir + "\u4e0d\u662f\u6587\u4ef6\u5939");
            return false;
        }
        try {
            new File(newPath).mkdirs();
            File[] files = oldDir.listFiles();
            File temp = null;
            for (int i = 0; i < files.length; ++i) {
                temp = files[i];
                if (!(temp.isFile() ? !FileUtil.copyFile(temp, newPath + "/" + temp.getName()) : temp.isDirectory() && !FileUtil.copyDir(temp, newPath + "/" + temp.getName()))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.info("\u590d\u5236\u6574\u4e2a\u6587\u4ef6\u5939\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519\u3002\u9519\u8bef\u539f\u56e0:" + e.getMessage());
            return false;
        }
    }

    public static boolean move(String oldPath, String newPath) {
        return FileUtil.copy(oldPath, newPath) && FileUtil.delete(oldPath);
    }

    public static boolean move(File oldFile, String newPath) {
        return FileUtil.copy(oldFile, newPath) && FileUtil.delete(oldFile);
    }

    public static void serialize(Serializable obj, String fileName) {
        try {
            FileOutputStream f = new FileOutputStream(fileName);
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(obj);
            s.flush();
            s.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serialize(Serializable obj) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            ObjectOutputStream s = new ObjectOutputStream(b);
            s.writeObject(obj);
            s.flush();
            s.close();
            return b.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object unserialize(String fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            ObjectInputStream s = new ObjectInputStream(in);
            Object o = s.readObject();
            s.close();
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object unserialize(byte[] bs) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bs);
            ObjectInputStream s = new ObjectInputStream(in);
            Object o = s.readObject();
            s.close();
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void uploadFile(File sourceFile, File targetFile) {
        try {
            File parentFile = new File(targetFile.getParent());
            parentFile.mkdirs();
            FileInputStream is = new FileInputStream(sourceFile);
            FileOutputStream os = new FileOutputStream(targetFile);
            int len = 0;
            byte[] buffer = new byte[500];
            while (-1 != (len = ((InputStream)is).read(buffer))) {
                ((OutputStream)os).write(buffer, 0, len);
            }
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileDataByBR(String path) {
        String xml = "";
        FileInputStream fs = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        try {
            String str;
            fs = new FileInputStream(path);
            is = new InputStreamReader((InputStream)fs, GlobalCharset);
            br = new BufferedReader(is);
            StringBuilder sb = new StringBuilder();
            while ((str = br.readLine()) != null) {
                sb.append(str).append("\n");
            }
            xml = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
                if (is != null) {
                    is.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return xml;
    }
}

