/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.utils;

import com.chinamcloud.produce.common.utils.StringUtil;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.codec.binary.Base64;

public class ImageHelper {
    public static String base64ToImage(String filePath, String base64) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = StringUtil.getUUID() + ".jpg";
        String fileAllPath = filePath + fileName;
        if (StringUtil.isNotEmpty(base64) && base64.contains("data:image/jpg;base64,")) {
            base64 = base64.substring(base64.indexOf("data:image/jpg;base64,") + "data:image/jpg;base64,".length());
        }
        byte[] bytes = Base64.decodeBase64((String)base64);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] + 256);
        }
        FileOutputStream out = new FileOutputStream(fileAllPath);
        ((OutputStream)out).write(bytes);
        out.flush();
        ((OutputStream)out).close();
        return fileAllPath;
    }

    public static String base64ToImage_PNG(String filePath, String base64) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = StringUtil.getUUID() + ".png";
        String fileAllPath = filePath + fileName;
        if (StringUtil.isNotEmpty(base64) && base64.contains("data:image/png;base64,")) {
            base64 = base64.substring(base64.indexOf("data:image/png;base64,") + "data:image/png;base64,".length());
        }
        byte[] bytes = Base64.decodeBase64((String)base64);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] + 256);
        }
        FileOutputStream out = new FileOutputStream(fileAllPath);
        ((OutputStream)out).write(bytes);
        out.flush();
        ((OutputStream)out).close();
        return fileAllPath;
    }

    public static String base64ToImageForVideoCut(String filePath, String base64, String width, String height) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = width + "_" + height + ".jpg";
        String fileAllPath = filePath + fileName;
        if (StringUtil.isNotEmpty(base64) && base64.contains("data:image/jpg;base64,")) {
            base64 = base64.substring(base64.indexOf("data:image/jpg;base64,") + "data:image/jpg;base64,".length());
        }
        byte[] bytes = Base64.decodeBase64((String)base64);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] + 256);
        }
        FileOutputStream out = new FileOutputStream(fileAllPath);
        ((OutputStream)out).write(bytes);
        out.flush();
        ((OutputStream)out).close();
        return fileAllPath;
    }

    public static String base64ToImageAndCut(String filePath, String base64, int width, int height) throws Exception {
        if (width < 1 || height < 1) {
            throw new Exception("\u5bbd\u9ad8\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = StringUtil.getUUID() + ".jpg";
        String fileAllPath = filePath + fileName;
        if (StringUtil.isNotEmpty(base64) && base64.contains("data:image/jpg;base64,")) {
            base64 = base64.substring(base64.indexOf("data:image/jpg;base64,") + "data:image/jpg;base64,".length());
        }
        byte[] bytes = Base64.decodeBase64((String)base64);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] + 256);
        }
        FileOutputStream out = new FileOutputStream(fileAllPath);
        ((OutputStream)out).write(bytes);
        out.flush();
        ((OutputStream)out).close();
        BufferedImage bimage = ImageIO.read(new File(fileAllPath));
        int widthOld = bimage.getWidth();
        int heightOld = bimage.getHeight();
        bimage.flush();
        if ((double)widthOld * 1.0 / (double)width > (double)heightOld * 1.0 / (double)height) {
            ImageHelper.zoomImage(fileAllPath, fileAllPath, (int)Math.ceil(widthOld * (height / heightOld)), height);
        } else if ((double)widthOld * 1.0 / (double)width < (double)heightOld * 1.0 / (double)height) {
            ImageHelper.zoomImage(fileAllPath, fileAllPath, width, (int)Math.ceil(heightOld * (width / widthOld)));
        } else {
            ImageHelper.zoomImage(fileAllPath, fileAllPath, width, height);
        }
        ImageHelper.cutCenterImage(fileAllPath, fileAllPath, width, height);
        return fileAllPath;
    }

    public static void cutCenterImage(String src, String dest, int w, int h) throws IOException {
        if (StringUtil.isEmpty(src)) {
            return;
        }
        String extName = src.substring(src.lastIndexOf(".") + 1, src.length());
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(extName);
        ImageReader reader = iterator.next();
        FileInputStream in = new FileInputStream(src);
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        reader.setInput(iis, true);
        ImageReadParam param = reader.getDefaultReadParam();
        int imageIndex = 0;
        Rectangle rect = new Rectangle((reader.getWidth(imageIndex) - w) / 2, (reader.getHeight(imageIndex) - h) / 2, w, h);
        param.setSourceRegion(rect);
        BufferedImage bi = reader.read(0, param);
        ImageIO.write((RenderedImage)bi, extName, new File(dest));
    }

    public static void cutHalfImage(String src, String dest) throws IOException {
        if (StringUtil.isEmpty(src)) {
            return;
        }
        String extName = src.substring(src.lastIndexOf(".") + 1, src.length());
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(extName);
        ImageReader reader = iterator.next();
        FileInputStream in = new FileInputStream(src);
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        reader.setInput(iis, true);
        ImageReadParam param = reader.getDefaultReadParam();
        int imageIndex = 0;
        int width = reader.getWidth(imageIndex) / 2;
        int height = reader.getHeight(imageIndex) / 2;
        Rectangle rect = new Rectangle(width / 2, height / 2, width, height);
        param.setSourceRegion(rect);
        BufferedImage bi = reader.read(0, param);
        ImageIO.write((RenderedImage)bi, extName, new File(dest));
    }

    public static void cutImage(String src, String dest, int x, int y, int w, int h) throws IOException {
        if (StringUtil.isEmpty(src)) {
            return;
        }
        String extName = src.substring(src.lastIndexOf(".") + 1, src.length());
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(extName);
        ImageReader reader = iterator.next();
        FileInputStream in = new FileInputStream(src);
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        reader.setInput(iis, true);
        ImageReadParam param = reader.getDefaultReadParam();
        Rectangle rect = new Rectangle(x, y, w, h);
        param.setSourceRegion(rect);
        BufferedImage bi = reader.read(0, param);
        ImageIO.write((RenderedImage)bi, extName, new File(dest));
    }

    public static void zoomImage(String src, String dest, int w, int h) throws Exception {
        double wr = 0.0;
        double hr = 0.0;
        File srcFile = new File(src);
        File destFile = new File(dest);
        BufferedImage bufImg = ImageIO.read(srcFile);
        wr = (double)w * 1.0 / (double)bufImg.getWidth();
        hr = (double)h * 1.0 / (double)bufImg.getHeight();
        AffineTransformOp ato = new AffineTransformOp(AffineTransform.getScaleInstance(wr, hr), null);
        BufferedImage image = ato.filter(bufImg, null);
        try {
            ImageIO.write((RenderedImage)image, dest.substring(dest.lastIndexOf(".") + 1), destFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean imageDelete(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }
}

