/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.ArrayUtils;

public class StringUtil {
    public static final byte[] BOM = new byte[]{-17, -69, -65};
    public static final char[] HexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static URLCodec urlCoder = new URLCodec();
    public static final Pattern PTitle = Pattern.compile("<title>(.+?)</title>", 34);
    public static Pattern patternHtmlTag = Pattern.compile("<[^<>]+>", 32);
    public static final Pattern PLetterOrDigit = Pattern.compile("^\\w*$", 34);
    public static final Pattern PLetter = Pattern.compile("^[A-Za-z]*$", 34);
    public static final Pattern PDigit = Pattern.compile("^\\d*$", 34);
    private static Pattern chinesePattern = Pattern.compile("[^\u4e00-\u9fa5]+", 34);
    private static Pattern idPattern = Pattern.compile("[\\w\\_\\.\\,]*", 34);
    private char[] chartable = new char[]{'\u554a', '\u82ad', '\u64e6', '\u642d', '\u86fe', '\u53d1', '\u5676', '\u54c8', '\u54c8', '\u51fb', '\u5580', '\u5783', '\u5988', '\u62ff', '\u54e6', '\u556a', '\u671f', '\u7136', '\u6492', '\u584c', '\u584c', '\u584c', '\u6316', '\u6614', '\u538b', '\u531d', '\u5ea7'};
    private char[] alphatable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private int[] table = new int[27];

    public StringUtil() {
        for (int i = 0; i < 27; ++i) {
            this.table[i] = this.gbValue(this.chartable[i]);
        }
    }

    public static boolean hasZimu(String str) {
        Boolean flag = false;
        if (StringUtil.isNotEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                if ((str.charAt(i) > 'Z' || str.charAt(i) < 'A') && (str.charAt(i) > 'z' || str.charAt(i) < 'a')) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean hasAllZimu(String str) {
        Boolean flag = true;
        if (StringUtil.isNotEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) <= 'Z' && str.charAt(i) >= 'A' || str.charAt(i) <= 'z' && str.charAt(i) >= 'a') continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    public static String parseNumberToEn(String str) {
        String newStr = "";
        try {
            if (StringUtil.isNotEmpty(str)) {
                String chars = "abcdefghijklmnopqrstuvwxyz";
                for (int i = 0; i < str.length(); ++i) {
                    newStr = str.charAt(i) <= 'Z' && str.charAt(i) >= 'A' || str.charAt(i) <= 'z' && str.charAt(i) >= 'a' ? newStr + str.charAt(i) : newStr + chars.charAt((int)(Math.random() * 26.0));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newStr;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!StringUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static byte[] md5(String src) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return md5.digest(src.getBytes());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] md5(byte[] src) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return md5.digest(src);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String md5Hex(String src) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md = md5.digest(src.getBytes());
            return StringUtil.hexEncode(md);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String hexEncode(byte[] bs) {
        return new String(new Hex().encode(bs));
    }

    public static byte[] hexDecode(String str) {
        try {
            if (str.endsWith("\n")) {
                str = str.substring(0, str.length() - 1);
            }
            char[] cs = str.toCharArray();
            return Hex.decodeHex((char[])cs);
        }
        catch (DecoderException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String byteToBin(byte[] bs) {
        char[] cs = new char[bs.length * 9];
        for (int i = 0; i < bs.length; ++i) {
            byte b = bs[i];
            int j = i * 9;
            cs[j] = (b >>> 7 & 1) == 1 ? 49 : 48;
            cs[j + 1] = (b >>> 6 & 1) == 1 ? 49 : 48;
            cs[j + 2] = (b >>> 5 & 1) == 1 ? 49 : 48;
            cs[j + 3] = (b >>> 4 & 1) == 1 ? 49 : 48;
            cs[j + 4] = (b >>> 3 & 1) == 1 ? 49 : 48;
            cs[j + 5] = (b >>> 2 & 1) == 1 ? 49 : 48;
            cs[j + 6] = (b >>> 1 & 1) == 1 ? 49 : 48;
            cs[j + 7] = (b & 1) == 1 ? 49 : 48;
            cs[j + 8] = 44;
        }
        return new String(cs);
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(StringUtil.byteToHexString(b[i]));
            resultSb.append(" ");
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return HexDigits[d1] + "" + HexDigits[d2];
    }

    public static boolean isUTF8(byte[] bs) {
        if (StringUtil.hexEncode(ArrayUtils.subarray((byte[])bs, (int)0, (int)3)).equals("efbbbf")) {
            return true;
        }
        int lLen = bs.length;
        int i = 0;
        while (i < lLen) {
            int c;
            byte b;
            if ((b = bs[i++]) >= 0) continue;
            if (b < -64 || b > -3) {
                return false;
            }
            int n = b > -4 ? 5 : (b > -8 ? 4 : (b > -16 ? 3 : (c = b > -32 ? 2 : 1)));
            if (i + c > lLen) {
                return false;
            }
            int j = 0;
            while (j < c) {
                if (bs[i] >= -64) {
                    return false;
                }
                ++j;
                ++i;
            }
        }
        return true;
    }

    public static String javaEncode(String txt) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        txt = StringUtil.replaceEx(txt, "\\", "\\\\");
        txt = StringUtil.replaceEx(txt, "\r\n", "\n");
        txt = StringUtil.replaceEx(txt, "\n", "\\n");
        txt = StringUtil.replaceEx(txt, "\"", "\\\"");
        txt = StringUtil.replaceEx(txt, "'", "\\'");
        return txt;
    }

    public static String javaDecode(String txt) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        txt = StringUtil.replaceEx(txt, "\\\\", "\\");
        txt = StringUtil.replaceEx(txt, "\\n", "\n");
        txt = StringUtil.replaceEx(txt, "\\r", "\r");
        txt = StringUtil.replaceEx(txt, "\\\"", "\"");
        txt = StringUtil.replaceEx(txt, "\\'", "'");
        return txt;
    }

    public static String[] splitEx(String str, String spilter) {
        if (str == null) {
            return null;
        }
        if (spilter == null || spilter.equals("") || str.length() < spilter.length()) {
            String[] t = new String[]{str};
            return t;
        }
        ArrayList<String> al = new ArrayList<String>();
        char[] cs = str.toCharArray();
        char[] ss = spilter.toCharArray();
        int length = spilter.length();
        int lastIndex = 0;
        int i = 0;
        while (i <= str.length() - length) {
            boolean notSuit = false;
            for (int j = 0; j < length; ++j) {
                if (cs[i + j] == ss[j]) continue;
                notSuit = true;
                break;
            }
            if (!notSuit) {
                al.add(str.substring(lastIndex, i));
                lastIndex = i += length;
                continue;
            }
            ++i;
        }
        if (lastIndex <= str.length()) {
            al.add(str.substring(lastIndex, str.length()));
        }
        String[] t = new String[al.size()];
        for (int i2 = 0; i2 < al.size(); ++i2) {
            t[i2] = (String)al.get(i2);
        }
        return t;
    }

    public static String replaceEx(String str, String subStr, String reStr) {
        if (str == null) {
            return null;
        }
        if (subStr == null || subStr.equals("") || subStr.length() > str.length() || reStr == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        String tmp = str;
        int index = -1;
        while ((index = tmp.indexOf(subStr)) >= 0) {
            sb.append(tmp);
            sb.append(reStr);
            tmp = tmp.substring(index + subStr.length());
        }
        sb.append(tmp);
        return sb.toString();
    }

    public static String replaceAllIgnoreCase(String source, String oldstring, String newstring) {
        Pattern p = Pattern.compile(oldstring, 34);
        Matcher m = p.matcher(source);
        return m.replaceAll(newstring);
    }

    public static String urlEncode(String str) {
        return StringUtil.urlEncode(str, "UTF-8");
    }

    public static String urlDecode(String str) {
        return StringUtil.urlDecode(str, "UTF-8");
    }

    public static String urlEncode(String str, String charset) {
        try {
            return urlCoder.encode(str, charset);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String urlDecode(String str, String charset) {
        try {
            return urlCoder.decode(str, charset);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String quotEncode(String txt) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        txt = StringUtil.replaceEx(txt, "&", "&amp;");
        txt = StringUtil.replaceEx(txt, "\"", "&quot;");
        return txt;
    }

    public static String quotDecode(String txt) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        txt = StringUtil.replaceEx(txt, "&quot;", "\"");
        txt = StringUtil.replaceEx(txt, "&amp;", "&");
        return txt;
    }

    public static String escape(String src) {
        StringBuffer sb = new StringBuffer();
        sb.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                sb.append(j);
                continue;
            }
            if (j < '\u0100') {
                sb.append("%");
                if (j < '\u0010') {
                    sb.append("0");
                }
                sb.append(Integer.toString(j, 16));
                continue;
            }
            sb.append("%u");
            sb.append(Integer.toString(j, 16));
        }
        return sb.toString();
    }

    public static String unescape(String src) {
        StringBuffer sb = new StringBuffer();
        sb.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    sb.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                sb.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                sb.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            sb.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return sb.toString();
    }

    public static String leftPad(String srcString, char c, int length) {
        int tLen;
        if (srcString == null) {
            srcString = "";
        }
        if ((tLen = srcString.length()) >= length) {
            return srcString;
        }
        int iMax = length - tLen;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < iMax; ++i) {
            sb.append(c);
        }
        sb.append(srcString);
        return sb.toString();
    }

    public static String subString(String src, int length) {
        if (src == null) {
            return null;
        }
        int i = src.length();
        if (i > length) {
            return src.substring(0, length);
        }
        return src;
    }

    public static String subStringEx(String src, int length) {
        length *= 2;
        if (src == null) {
            return null;
        }
        int k = StringUtil.lengthEx(src);
        if (k > length) {
            int m = 0;
            boolean unixFlag = false;
            String osname = System.getProperty("os.name").toLowerCase();
            if (osname.indexOf("sunos") > 0 || osname.indexOf("solaris") > 0 || osname.indexOf("aix") > 0) {
                unixFlag = true;
            }
            try {
                byte[] b = src.getBytes("Unicode");
                for (int i = 2; i < b.length; i += 2) {
                    byte flag = b[i + 1];
                    if (unixFlag) {
                        flag = b[i];
                    }
                    m = flag == 0 ? ++m : (m += 2);
                    if (m <= length) continue;
                    return src.substring(0, (i - 2) / 2);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new RuntimeException("\u6267\u884c\u65b9\u6cd5getBytes(\"Unicode\")\u65f6\u51fa\u9519\uff01");
            }
        }
        return src;
    }

    public static int lengthEx(String src) {
        int length = 0;
        boolean unixFlag = false;
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("sunos") > 0 || osname.indexOf("solaris") > 0 || osname.indexOf("aix") > 0) {
            unixFlag = true;
        }
        try {
            byte[] b = src.getBytes("Unicode");
            for (int i = 2; i < b.length; i += 2) {
                byte flag = b[i + 1];
                if (unixFlag) {
                    flag = b[i];
                }
                if (flag == 0) {
                    ++length;
                    continue;
                }
                length += 2;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6267\u884c\u65b9\u6cd5getBytes(\"Unicode\")\u65f6\u51fa\u9519\uff01");
        }
        return length;
    }

    public static String rightPad(String srcString, char c, int length) {
        int tLen;
        if (srcString == null) {
            srcString = "";
        }
        if ((tLen = srcString.length()) >= length) {
            return srcString;
        }
        int iMax = length - tLen;
        StringBuffer sb = new StringBuffer();
        sb.append(srcString);
        for (int i = 0; i < iMax; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String rightTrim(String src) {
        if (src != null) {
            char[] chars = src.toCharArray();
            for (int i = chars.length - 1; i > 0; --i) {
                if (chars[i] == ' ' || chars[i] == '\t') continue;
                return new String(ArrayUtils.subarray((char[])chars, (int)0, (int)(i + 1)));
            }
        }
        return src;
    }

    public static void printStringWithAnyCharset(String str) {
        SortedMap<String, Charset> map = Charset.availableCharsets();
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            for (int j = 0; j < keys.length; ++j) {
                System.out.print("\t");
                try {
                    System.out.println("From " + keys[i] + " To " + keys[j] + ":" + new String(str.getBytes(keys[i].toString()), keys[j].toString()));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String toSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] > '@' && c[i] < '[' || c[i] > '`' && c[i] < '{' || c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toNSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String getHtmlTitle(String html) {
        Matcher m = PTitle.matcher(html);
        if (m.find()) {
            return m.group(1).trim();
        }
        return null;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isEmptyOrNullStr(String s) {
        return StringUtil.isEmpty(s) || "null".equalsIgnoreCase(s);
    }

    public static final String noNull(String string, String defaultString) {
        return StringUtil.isEmpty(string) ? defaultString : string;
    }

    public static final String noNull(String string) {
        return StringUtil.noNull(string, "");
    }

    public static String join(Object[] arr) {
        return StringUtil.join(arr, ",");
    }

    public static String join(Object[][] arr) {
        return StringUtil.join(arr, "\n", ",");
    }

    public static String join(Object[] arr, String spliter) {
        if (arr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(spliter);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String join(Object[][] arr, String spliter1, String spliter2) {
        if (arr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(spliter2);
            }
            sb.append(StringUtil.join(arr[i], spliter2));
        }
        return sb.toString();
    }

    public static String join(List list) {
        return StringUtil.join(list, ",");
    }

    public static String join(List list, String spliter) {
        if (list == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(spliter);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public static int count(String str, String findStr) {
        int lastIndex = 0;
        int length = findStr.length();
        int count = 0;
        int start = 0;
        while ((start = str.indexOf(findStr, lastIndex)) >= 0) {
            lastIndex = start + length;
            ++count;
        }
        return count;
    }

    public static boolean isLetterOrDigit(String str) {
        return PLetterOrDigit.matcher(str).find();
    }

    public static boolean isLetter(String str) {
        return PLetter.matcher(str).find();
    }

    public static boolean isDigit(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return PDigit.matcher(str).find();
    }

    public static boolean containsChinese(String str) {
        return !chinesePattern.matcher(str).matches();
    }

    public static boolean checkID(String str) {
        if (StringUtil.isEmpty(str)) {
            return true;
        }
        return idPattern.matcher(str).matches();
    }

    public static String getURLExtName(String url) {
        int index2;
        if (StringUtil.isEmpty(url)) {
            return null;
        }
        int index1 = url.indexOf(63);
        if (index1 == -1) {
            index1 = url.length();
        }
        if ((index2 = url.lastIndexOf(46, index1)) == -1) {
            return null;
        }
        int index3 = url.indexOf(47, 8);
        if (index3 == -1) {
            return null;
        }
        String ext = url.substring(index2 + 1, index1);
        if (ext.matches("[^\\/\\\\]*")) {
            return ext;
        }
        return null;
    }

    public static String getURLFileName(String url) {
        int index2;
        if (StringUtil.isEmpty(url)) {
            return null;
        }
        int index1 = url.indexOf(63);
        if (index1 == -1) {
            index1 = url.length();
        }
        if ((index2 = url.lastIndexOf(47, index1)) == -1 || index2 < 8) {
            return null;
        }
        String ext = url.substring(index2 + 1, index1);
        return ext;
    }

    public static String clearForXML(String str) {
        char[] cs = str.toCharArray();
        char[] ncs = new char[cs.length];
        int j = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] > '\ufffd' || cs[i] < ' ' && cs[i] != '\t' & cs[i] != '\n' & cs[i] != '\r') continue;
            ncs[j++] = cs[i];
        }
        ncs = ArrayUtils.subarray((char[])ncs, (int)0, (int)j);
        return new String(ncs);
    }

    public static String getTextFromHtml(String html) {
        String text = patternHtmlTag.matcher(html).replaceAll("");
        if (StringUtil.isEmpty(text)) {
            return "";
        }
        return text.replaceAll("[\\s\u3000]{2,}", " ");
    }

    public static String subContentStringOrialBytes(String str, int targetCount) throws Exception {
        return StringUtil.subContentStringOrialBytes(str, targetCount *= 2, "...");
    }

    public static String subContentStringOrialBytes(String str, int targetCount, String more) throws Exception {
        byte[] b;
        if (str == null) {
            return "";
        }
        int initVariable = 0;
        StringBuffer restr = new StringBuffer();
        if (StringUtil.getStringByteLength(str, targetCount) <= (long)targetCount) {
            return str;
        }
        String s1 = null;
        char[] tempchar = str.toCharArray();
        for (int i = 0; i < tempchar.length && targetCount > initVariable; initVariable += b.length, ++i) {
            s1 = String.valueOf(tempchar[i]);
            b = s1.getBytes("gb18030");
            restr.append(tempchar[i]);
        }
        if (targetCount == initVariable || targetCount == initVariable - 1) {
            restr.append(more);
        }
        return restr.toString();
    }

    private static long getStringByteLength(String str, int maxlength) throws Exception {
        if (str == null) {
            return 0L;
        }
        int tmp_len = maxlength;
        if (str.length() < maxlength) {
            tmp_len = str.length();
        } else if (str.length() > maxlength * 2) {
            tmp_len = maxlength * 2;
        }
        char[] tempchar = str.substring(0, tmp_len).toCharArray();
        int intVariable = 0;
        String s1 = null;
        for (int i = 0; i < tempchar.length && intVariable <= maxlength; intVariable += s1.getBytes("gb18030").length, ++i) {
            s1 = String.valueOf(tempchar[i]);
        }
        s1 = null;
        tempchar = null;
        return intVariable;
    }

    public char Char2Alpha(char ch) {
        int i;
        if (ch >= 'a' && ch <= 'z') {
            return (char)(ch - 97 + 65);
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch;
        }
        int gb = this.gbValue(ch);
        if (gb < this.table[0]) {
            return '0';
        }
        for (i = 0; i < 26 && !this.match(i, gb); ++i) {
        }
        if (i >= 26) {
            return '0';
        }
        return this.alphatable[i];
    }

    public String String2Alpha(String SourceStr) {
        String Result = "";
        int StrLength = SourceStr.length();
        try {
            for (int i = 0; i < StrLength; ++i) {
                Result = Result + this.Char2Alpha(SourceStr.charAt(i));
            }
        }
        catch (Exception e) {
            Result = "";
        }
        return Result;
    }

    private boolean match(int i, int gb) {
        int j;
        if (gb < this.table[i]) {
            return false;
        }
        for (j = i + 1; j < 26 && this.table[j] == this.table[i]; ++j) {
        }
        if (j == 26) {
            return gb <= this.table[j];
        }
        return gb < this.table[j];
    }

    private int gbValue(char ch) {
        String str = new String();
        str = str + ch;
        try {
            byte[] bytes = str.getBytes("GB2312");
            if (bytes.length < 2) {
                return 0;
            }
            return (bytes[0] << 8 & 0xFF00) + (bytes[1] & 0xFF);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String replaceAllToSlant(String str) {
        if (StringUtil.isNotEmpty(str)) {
            str = str.replaceAll("\\\\", "/");
            str = str.replaceAll("/+", "/");
        }
        return str;
    }

    public static String replaceAllToBack_Slant(String str) {
        if (StringUtil.isNotEmpty(str)) {
            str = str.replaceAll("/", "\\\\");
            str = str.replaceAll("\\\\+", "\\\\");
        }
        return str;
    }

    public static boolean isJSONObject(String str) {
        try {
            JSONObject.parseObject((String)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJSONArray(String str) {
        try {
            JSONArray.parseObject((String)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

