/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.utils;

import com.chinamcloud.produce.common.utils.StringUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class UploadUtil {
    private static final Logger log = LoggerFactory.getLogger(UploadUtil.class);

    public static String imageUpload(MultipartFile file, String path) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Date date = new Date();
        String filePath = path + "/" + format.format(date) + "/" + UUID.randomUUID().toString().toUpperCase() + "/";
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if (file != null && file.getSize() > 0L) {
            String file_last;
            MultipartFile tempFile = file;
            if (tempFile.isEmpty()) {
                String message = "\u6587\u4ef6\u4e3a\u7a7a";
                return message;
            }
            String fileName = tempFile.getOriginalFilename();
            String ext = fileName.substring(fileName.lastIndexOf("."));
            if (!(".jpg".equalsIgnoreCase(ext) || ".png".equalsIgnoreCase(ext) || ".gif".equalsIgnoreCase(ext) || ".jpeg".equalsIgnoreCase(ext) || ".bmp".equalsIgnoreCase(ext))) {
                String message = "\u56fe\u7247\u683c\u5f0f\u4e0d\u5bf9";
                return message;
            }
            try {
                BufferedImage bi = ImageIO.read(file.getInputStream());
                file_last = bi.getWidth() + "_" + bi.getHeight() + ext;
                tempFile.transferTo(new File(filePath, file_last));
            }
            catch (IOException | IllegalStateException e) {
                log.info("\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25");
                e.printStackTrace();
                String message = "\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25";
                return message;
            }
            String url = filePath + file_last;
            return url;
        }
        String message = "\u6587\u4ef6\u4e3a\u7a7a";
        return message;
    }

    public static String uploadExcel(MultipartFile file, String path) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Date date = new Date();
        String filePath = path + "/" + format.format(date) + "/" + UUID.randomUUID().toString().toUpperCase() + "/";
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if (file != null && !file.isEmpty()) {
            String fileName = file.getOriginalFilename();
            String ext = fileName.substring(fileName.lastIndexOf("."));
            if (!".xls".equalsIgnoreCase(ext) && !".xlsx".equalsIgnoreCase(ext)) {
                String message = "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9,\u4ec5\u652f\u6301.xls\u3001.xlsx";
                return message;
            }
            try {
                file.transferTo(new File(filePath, fileName));
            }
            catch (IOException | IllegalStateException var13) {
                log.info("\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25");
                var13.printStackTrace();
                String message = "\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25";
                return message;
            }
            String url = filePath + fileName;
            return url;
        }
        String message = "\u6587\u4ef6\u4e3a\u7a7a";
        return message;
    }

    public static String imageUpload_NoDateUUIDDir(MultipartFile file, String filePath) {
        File fileDir;
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(fileDir = new File(filePath)).exists()) {
            fileDir.mkdirs();
        }
        if (file.isEmpty()) {
            String message = "\u6587\u4ef6\u4e3a\u7a7a";
            return message;
        }
        String fileName = file.getOriginalFilename();
        String ext = fileName.substring(fileName.lastIndexOf("."));
        if (!(".jpg".equalsIgnoreCase(ext) || ".png".equalsIgnoreCase(ext) || ".gif".equalsIgnoreCase(ext) || ".jpeg".equalsIgnoreCase(ext) || ".bmp".equalsIgnoreCase(ext))) {
            String message = "\u56fe\u7247\u683c\u5f0f\u4e0d\u652f\u6301";
            return message;
        }
        try {
            String file_last = StringUtil.getUUID() + ext;
            file.transferTo(new File(filePath, file_last));
            return filePath + file_last;
        }
        catch (IOException | IllegalStateException var10) {
            log.info("\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25");
            var10.printStackTrace();
            String message = "\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25";
            return message;
        }
    }
}

