/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpServletRequestReplacedFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if ("POST".equals(request.getMethod()) && (request.getContentType().contains("text/plain") || request.getContentType().contains("application/json"))) {
            BodyReaderHttpServletRequestWrapper requestWrapper = new BodyReaderHttpServletRequestWrapper(request);
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    private static class BodyReaderHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final byte[] body;

        private BodyReaderHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            int len;
            BufferedReader br = request.getReader();
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1024];
            while ((len = br.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
            this.body = sb.toString().getBytes();
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
            return new ServletInputStream(){

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() throws IOException {
                    return bais.read();
                }
            };
        }
    }
}

