/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.network;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.produce.common.api.vo.HttpSendResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClientService {
    private static final Logger log = LoggerFactory.getLogger(HttpClientService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendMessageUrl_GET(String url) {
        log.info("Get\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c:{}", (Object)statusCode);
            if (200 == statusCode) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001GET\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendMessageByJson_GET(JSONObject paramsJson, String url) {
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (paramsJson != null && !paramsJson.isEmpty()) {
                Set keySet = paramsJson.keySet();
                for (String key : keySet) {
                    String value = paramsJson.getString(key);
                    uriBuilder.setParameter(key, URLEncoder.encode(value, "UTF-8"));
                }
            }
            URI uri = uriBuilder.build();
            log.info("GET\u6700\u7ec8\u8bf7\u6c42uri:{}", (Object)uri);
            HttpGet httpGet = new HttpGet(uri);
            response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c:{}", (Object)statusCode);
            if (200 == statusCode) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001GET\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendMessageByJson_POST_FORM(JSONObject paramsJson, String url) {
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            if (paramsJson != null && !paramsJson.isEmpty()) {
                Set keySet = paramsJson.keySet();
                for (String key : keySet) {
                    formParams.add(new BasicNameValuePair(key, paramsJson.getString(key)));
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c\uff1a{}", (Object)statusCode);
            if (200 == statusCode) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001POST\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendMessageByJson_POST_BODY(JSONObject paramsJson, String url) {
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json;charset=utf8");
            StringEntity stringEntity = new StringEntity(paramsJson.toString(), "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c\uff1a{}", (Object)statusCode);
            if (200 == statusCode) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001POST\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostByURLConnection(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            log.info("\u62a5\u6587\u53d1\u9001\u72b6\u6001\u503c\uff1a" + conn.getResponseCode());
            if (200 == conn.getResponseCode()) {
                String line;
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
                result = sb.toString();
            }
            log.info("\u8fd4\u56de\u7ed3\u679c:" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpSendResult sendMessageByJson_GET_P1(JSONObject paramsJson, String url) {
        String result;
        int statusCode;
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (paramsJson != null && !paramsJson.isEmpty()) {
                Set keySet = paramsJson.keySet();
                for (String key : keySet) {
                    String value = paramsJson.getString(key);
                    uriBuilder.setParameter(key, URLEncoder.encode(value, "UTF-8"));
                }
            }
            URI uri = uriBuilder.build();
            log.info("GET\u6700\u7ec8\u8bf7\u6c42uri:{}", (Object)uri);
            HttpGet httpGet = new HttpGet(uri);
            response = httpClient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c:{}", (Object)statusCode);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001GET\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
            statusCode = 500;
            result = "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38!";
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return new HttpSendResult(statusCode, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpSendResult sendMessageByJson_POST_FORM_P1(JSONObject paramsJson, String url) {
        String result;
        int statusCode;
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            if (paramsJson != null && !paramsJson.isEmpty()) {
                Set keySet = paramsJson.keySet();
                for (String key : keySet) {
                    formParams.add(new BasicNameValuePair(key, paramsJson.getString(key)));
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c\uff1a{}", (Object)statusCode);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001POST\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
            statusCode = 500;
            result = "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38!";
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return new HttpSendResult(statusCode, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpSendResult sendMessageByJson_POST_BODY_P1(JSONObject paramsJson, String url) {
        String result;
        int statusCode;
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json;charset=utf8");
            StringEntity stringEntity = new StringEntity(paramsJson.toString(), "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c\uff1a{}", (Object)statusCode);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001POST\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
            statusCode = 500;
            result = "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38!";
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return new HttpSendResult(statusCode, result);
    }

    public static String post(String url, MultiValueMap<String, String> params) {
        log.info("post url:{},params:{}", (Object)url, (Object)params.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "*/*");
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = new RestTemplate().exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            String result = (String)response.getBody();
            log.info("post result:{}", (Object)result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("post exception:{}", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpSendResult sendMessageByJson_POST_BODY_AUTHORIZATION(JSONObject paramsJson, String url, String token) {
        String result;
        int statusCode;
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        log.info("\u8bf7\u6c42token:{}", (Object)token);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json;charset=utf8");
            httpPost.setHeader("Authorization", "Bearer " + token);
            StringEntity stringEntity = new StringEntity(paramsJson.toString(), "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c\uff1a{}", (Object)statusCode);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001POST\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
            statusCode = 500;
            result = "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38!";
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return new HttpSendResult(statusCode, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpSendResult sendMessageByJson_POST_FORM_AUTHORIZATION(JSONObject paramsJson, String url, String token) {
        String result;
        int statusCode;
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramsJson);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
        log.info("\u8bf7\u6c42token:{}", (Object)token);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("Authorization", "Bearer " + token);
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            if (paramsJson != null && !paramsJson.isEmpty()) {
                Set keySet = paramsJson.keySet();
                for (String key : keySet) {
                    formParams.add(new BasicNameValuePair(key, paramsJson.getString(key)));
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            log.info("\u54cd\u5e94\u72b6\u6001\u503c\uff1a{}", (Object)statusCode);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001POST\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
            statusCode = 500;
            result = "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38!";
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
        return new HttpSendResult(statusCode, result);
    }
}

