/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class CustomProgramLengthSerializer
extends JsonSerializer<Long> {
    public void serialize(Long length, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        long f = length % 1000L;
        long s = length - f;
        String format = sdf.format(s);
        long frame = f / 40L;
        String result = frame / 10L > 0L ? format + ":" + frame : format + ":0" + frame;
        jsonGenerator.writeString(result);
    }
}

