/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.utils;

import com.chinamcloud.produce.common.network.HttpClientService;
import com.chinamcloud.produce.common.system.cache.ConfigCache;
import com.chinamcloud.produce.common.system.cache.PropertiesCache;
import com.chinamcloud.produce.common.utils.StringUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);

    private static boolean isWindows() {
        return System.getProperties().getProperty("os.name").toLowerCase().contains("windows");
    }

    public static String getFileAbsolutePath() {
        String rootPath = CommonUtil.isWindows() ? ConfigCache.getValue("FILE_WIN_DIR") : ConfigCache.getValue("FILE_LINUX_DIR");
        return rootPath;
    }

    public static String getXtrimmerFileAbsolutePath() {
        String rootPath = CommonUtil.isWindows() ? ConfigCache.getXtrimmerValue("FILE_WIN_DIR") : ConfigCache.getXtrimmerValue("FILE_LINUX_DIR");
        return rootPath;
    }

    public static String getManagerUrl() {
        String ms3MANAGER_url = PropertiesCache.getProperties("MS3MANAGER_URL");
        if (StringUtil.isEmpty(ms3MANAGER_url)) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230MS3MANAGER_URL\u914d\u7f6e\u9879,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6!");
        }
        return ms3MANAGER_url;
    }

    public static String programLengthFormat(long programLength) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        long f = programLength % 1000L;
        long s = programLength - f;
        String format = sdf.format(s);
        long frame = f / 40L;
        String result = frame / 10L > 0L ? format + ":" + frame : format + ":0" + frame;
        return result;
    }

    public static String getLocalHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getLocalIP() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                if (!"eth0".equals(ni.getName()) && !"bond0".equals(ni.getName())) continue;
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address) continue;
                    ip = ia.getHostAddress();
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String transformCharacter(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String postToWorkflow(String code, String data, String workflowUrl) {
        LinkedMultiValueMap p = new LinkedMultiValueMap();
        p.add((Object)"code", (Object)code);
        p.add((Object)"data", (Object)data);
        return HttpClientService.post(workflowUrl, (MultiValueMap<String, String>)p);
    }
}

