/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.produce.common.velocity.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private static final String DEFAULT_PAGE_DIR = "mpcTemplate/";
    private static VelocityUtil util = null;
    private VelocityEngine engine = null;
    private static Map cache = new HashMap(0);
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static synchronized VelocityUtil getInstance() {
        if (util == null) {
            util = new VelocityUtil();
        }
        return util;
    }

    public String renderTemplate(String template, Context context) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bytes);
        this.engine.mergeTemplate(DEFAULT_PAGE_DIR + template, DEFAULT_ENCODING, context, (Writer)writer);
        writer.flush();
        String outputTemplate = new String(bytes.toByteArray());
        writer.close();
        return outputTemplate;
    }

    private VelocityUtil() {
        try {
            this.engine = new VelocityEngine();
            this.engine.init(this.loadVelocityProps());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Properties loadVelocityProps() {
        Properties props = new Properties();
        props.setProperty("input.encoding", DEFAULT_ENCODING);
        props.setProperty("output.encoding", DEFAULT_ENCODING);
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.description", "Classpath Template Loader");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("class.resource.loader.cache", "true");
        props.setProperty("class.resource.loader.modificationCheckInterval", "10");
        props.setProperty("directive.foreach.counter.initial.value", "1");
        return props;
    }

    public String render(String template, String para, Object value) {
        Context context;
        Object obj = cache.get(template);
        if (obj == null) {
            context = new VelocityContext();
            cache.put(template, context);
        } else {
            context = (Context)obj;
        }
        context.put(para, value);
        String txt = null;
        try {
            txt = this.renderTemplate(template, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return txt;
    }

    public String getRequestXml(String template, String content, Object object) {
        return this.render(template, content, object);
    }
}

