package com.chinamcloud.plugin.code;

import com.chinamcloud.plugin.container.PluginManager;
import com.chinamcloud.plugin.container.SpiderServer;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by jyy on 2018/1/11.
 */
@Slf4j
public class DefaultDependencyManager implements DependencyManager {


    @Override
    public boolean satisfies(Plugin plugin, PluginManager pluginManager) {

        VersionManager versionManager = pluginManager.getVersionManager();
        log.info("开始插件检查 ID: { } ,Name : {} ",plugin.getPluginDescriptor().getPluginId(),plugin.getPluginDescriptor().getPluginName());
        String version = SpiderServer.getInstance().getVersion();
        boolean satisfies = versionManager.satisfies(plugin.getPluginDescriptor().getVersion(), version);
        //插件的版本小于当前服务器的版本
        if (!satisfies){
            if (pluginManager.getPlugins().containsKey(plugin.getPluginId())){
                return compare(plugin,pluginManager.getPlugins().get(plugin.getPluginId()),versionManager);
            }
            return true;
        }
        return false;
    }

    private boolean compare(Plugin org,Plugin desc,VersionManager versionManager){

        log.debug("当前的插件的版本是 : {} , 已存在的插件的版本是 {} ",org.getPluginDescriptor().getVersion(),
                desc.getPluginDescriptor().getVersion());
        boolean _satisfies = versionManager.satisfies(org.getPluginDescriptor().getVersion(),
                desc.getPluginDescriptor().getVersion());
        return _satisfies;

    }

}
