package com.chinamcloud.plugin.code;

import com.chinamcloud.plugin.container.SpiderServer;

import java.nio.file.Path;
import java.util.Date;

/**
 *
 * 插件是放在  pluginDirectory目录(
 * @see SpiderServer 的 homePath) 的 plugins 目录的所有的jar包
 * <pre>[插件目录]
 *    |-- plugin.xml
 *    |-- classes/
 *    |-- lib/
 *    |-- db/
 *  </pre>
 *  <tt>classes</tt> 可选,将会被加载到classpath
 *  <tt>lib</tt>  可选 , 将会被加载到classpath
 *  <tt>plugin.xml</tt> 必须的,插件描述信息
 *  <tt>db</tt> 可选,插件的需要执行的数据库
 *
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;
 * &lt;plugin&gt;
 *     &lt;name&gt;Example Plugin&lt;/name&gt;
 *     &lt;description&gt;This is an example plugin.&lt;/description&gt;
 *     &lt;author&gt;Foo Inc.&lt;/author&gt;
 *     &lt;version&gt;1.0&lt;/version&gt;
 *     &lt;licenseType&gt;gpl&lt;/licenseType&gt;
 * &lt;/plugin&gt;</pre>
 * <p>
 *  具体信息
 *  @see PluginDescriptor
 *
 */
public class Plugin {

	/**
	 * 返回插件的唯一主键
	 */
	private String pluginId;
	/**
	 * 插件是否被加载
     */
	private boolean isLoad;

	/**
	 * 插件被加载的时间
     */
	private Date loadTime;

	/**
	 * jar 对应的URL
     */

	private Path path;

	/**
	 * 插件的描述信息
     */
	PluginDescriptor pluginDescriptor;

	public boolean isLoad() {
		return isLoad;
	}

	public void setLoad(boolean load) {
		isLoad = load;
	}

	public Date getLoadTime() {
		return loadTime;
	}

	public void setLoadTime(Date loadTime) {
		this.loadTime = loadTime;
	}

	public PluginDescriptor getPluginDescriptor() {
		return pluginDescriptor;
	}

	public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
		this.pluginDescriptor = pluginDescriptor;
	}

	public String getPluginId() {
		return pluginId;
	}

	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}


	public Path getPath() {
		return path;
	}

	public void setPath(Path path) {
		this.path = path;
	}
}
