/*
 * Copyright 2012 Decebal Suiu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.chinamcloud.plugin.code;

import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 插件的描述信息
 * @author jyy
 */
public class PluginDescriptor {

    /**
     * 返回插件的唯一主键
     */
    private String pluginId;
    /**
     * 插件的名称
     */
    private String pluginName;

    /**
     * 插件的描述信息
     */
    private String pluginDescription;
    /**
     * 插件的使用手册
     */
    private String  readMe;

    /**
     * 插件的版本
     */
    private String version;
    /**
     * 插件的依赖版本
     */
    private String requires = "*";

    /**
     * 插件的作者
     */
    private String provider;

    /**
     * 插件的依赖
     */
    private List<PluginDependency> dependencies;

    /**
     *   "Apache-2.0", "MIT","Spider" etc
     */
    private String license;


    public String getPluginId() {
        return pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginName() {
        return pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginDescription() {
        return pluginDescription;
    }

    public void setPluginDescription(String pluginDescription) {
        this.pluginDescription = pluginDescription;
    }

    public String getReadMe() {
        return readMe;
    }

    public void setReadMe(String readMe) {
        this.readMe = readMe;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRequires() {
        return requires;
    }

    public void setRequires(String requires) {
        this.requires = requires;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public List<PluginDependency> getDependencies() {
        return dependencies;
    }

    public String getLicense() {
        return license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public  void setDependencies(String dependencies) {
        if (!StringUtils.isEmpty(dependencies)) {
            dependencies = dependencies.trim();
            this.dependencies = new ArrayList();
            String[] tokens = dependencies.split(",");
            for (String dependency : tokens) {
                dependency = dependency.trim();
                if (!dependency.isEmpty()) {
                    this.dependencies.add(new PluginDependency(dependency));
                }
            }
            if (this.dependencies.isEmpty()) {
                this.dependencies = Collections.emptyList();
            }

        } else {
            this.dependencies = Collections.emptyList();
        }
    }

    @Override
    public String toString() {
        return "PluginDescriptor{" +
                "pluginId='" + pluginId + '\'' +
                ", pluginName='" + pluginName + '\'' +
                ", pluginDescription='" + pluginDescription + '\'' +
                ", readMe=" + readMe +
                ", version='" + version + '\'' +
                ", requires='" + requires + '\'' +
                ", provider='" + provider + '\'' +
                ", dependencies=" + dependencies +
                ", license='" + license + '\'' +
                '}';
    }
}
