package com.chinamcloud.plugin.configuration;

import com.chinamcloud.plugin.container.SpiderServer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ApplicationStartedEventListener implements ApplicationListener<ApplicationStartingEvent> {

    @Override
    public void onApplicationEvent(ApplicationStartingEvent applicationStartedEvent) {
        log.info("----------------------------");
        log.debug("开始启动spiderServer,并且加载相关的信息");
        SpiderServer instance = SpiderServer.getInstance();
        instance.init();
    }
}