package com.chinamcloud.plugin.container;

import com.chinamcloud.plugin.code.Plugin;
import com.chinamcloud.plugin.code.PluginDependency;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

/**
 * Created by jyy on 2018/1/16.
 */
public class JarPluginLoader  implements  PluginLoader{

    protected PluginManager pluginManager;

    private  final  static  String  JAR_PROTOCOL = "jar:";

    private  final  static  String  JAR_SEPARATOR = "!/";

    private  final  static  String  JAR_CLASS = "classes/";

    public JarPluginLoader(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }
    @Override
    public void loadPlugin(Plugin plugin) {
        if (null == plugin){
            return ;
        }
        if ( !pluginManager.getPluginsLoaded().containsKey(plugin.getPluginId())) {
            try {
                List<PluginDependency> dependencies = plugin.getPluginDescriptor().getDependencies();
                if (CollectionUtils.isEmpty(dependencies)) {
                    URL fileURL = plugin.getPath().toUri().toURL();
                    String jarURL = new String(JAR_PROTOCOL + fileURL + JAR_SEPARATOR+ JAR_CLASS);
                    Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    boolean accessible = method.isAccessible();
                    try {
                        if (accessible == false) {
                            method.setAccessible(true);
                        }
                        // 设置类加载器
                        URLClassLoader classLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
                        // 将当前类路径加入到类加载器中
                        method.invoke(classLoader, new URL(jarURL));
                    } finally {
                        method.setAccessible(accessible);
                    }

                    pluginManager.getPluginsLoaded().put(plugin.getPluginId(), plugin);
                } else {
                    dependencies.forEach( pluginDependency -> {
                        this.loadPlugin(pluginManager.getPlugins().get(pluginDependency.getPluginId()));
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
