package com.chinamcloud.plugin.container;

import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

import java.io.File;
import java.io.InputStream;
import java.util.*;

/**
 * 服务器信息,标志这个服务的基本信息
 * Created by jyy on 2018/1/10.
 */
@Slf4j
public class SpiderServer {
    /**
     * 文件更目录
     */
    private File spdierHome;


    /**
     * 插件管理器
     */
    private PluginManager pluginManager;

    /**
     * 服务器当前版本,参照配置 serverinfo.properties 中的 配置 version
     */
    private String version ;

    /**
     * 启动时间
     */
    private Date date;
    /**
     *  返回server 单利模式
     */
    private  volatile static SpiderServer instance ;


    String homePath = "";

    String tmpdir = System.getProperty("java.io.tmpdir");


    /**
     * 单例模式
     * @return
     */
    public static SpiderServer getInstance() {
        if (instance == null) {
            synchronized (SpiderServer.class) {
                if (instance == null) {
                    instance = new SpiderServer();
                }
            }
        }
        return instance;
    }

    /**
     * 单例构造
     */
    private SpiderServer() {
        date = new Date();
    }

    /**
     * 启动server基础配置
     */
    public void init() {
        try {

            InputStream inputStream =  new ClassPathResource("server.properties").getInputStream();
            Properties prop = new Properties();
            prop.load(inputStream);
            inputStream.close();
            version =   prop.getProperty("version");
            if (StringUtils.isEmpty(version)){
                version = "1.0.0";
            }
            String pluginHome =   prop.getProperty("pluginHome");
            if (StringUtils.isEmpty(pluginHome)){
            }
            log.info("当前服务器的的版本是: {}",version);
            spdierHome = new File(pluginHome);
            String  _tmpdir = prop.getProperty("tmpdir");
            if (!StringUtils.isEmpty(_tmpdir)){
                this.tmpdir = _tmpdir;
            }
            String stops = prop.getProperty("plugin.stop");
            if (StringUtils.isEmpty(stops)){
                pluginManager = new PluginManager(spdierHome, Collections.EMPTY_LIST);
            }else {
                pluginManager = new PluginManager(spdierHome, Arrays.asList(stops.split(",")));
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public File getSpdierHome() {
        return spdierHome;
    }

    public void setSpdierHome(File spdierHome) {
        this.spdierHome = spdierHome;
    }



    public PluginManager getPluginManager() {
        return pluginManager;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public static void setInstance(SpiderServer instance) {
        SpiderServer.instance = instance;
    }

    public String getHomePath() {
        return homePath;
    }

    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    public String getTmpdir() {
        return tmpdir;
    }

    public void setTmpdir(String tmpdir) {
        this.tmpdir = tmpdir;
    }
}
