package com.chinamcloud.plugin.interceptor;

import org.springframework.util.ObjectUtils;

import java.util.Arrays;

public class MethodNameClassKey implements Comparable<MethodNameClassKey> {

    private final String methodName;

    private final Class<?> targetClass;

    private final Class[] parameters;

    private final Class returnType;

    public MethodNameClassKey(String methodName, Class<?> targetClass,Class returnType,Class[] parameters) {
        this.methodName = methodName;
        this.targetClass = targetClass;
        this.parameters = parameters;
        this.returnType = returnType;
    }


    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodNameClassKey)) {
            return false;
        }
        MethodNameClassKey otherKey = (MethodNameClassKey) other;
        return (this.methodName.equals(otherKey.methodName) &&
                ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass)
                && this.returnType.equals(otherKey.returnType)
                && Arrays.equals(this.parameters,otherKey.parameters));
    }


    @Override
    public int hashCode() {
        return this.methodName.hashCode() + (this.targetClass != null ? this.targetClass.hashCode() * 29 : 0);
    }

    @Override
    public String toString() {
        return this.methodName + (this.targetClass != null ? " on " + this.targetClass : "");
    }



    @Override
    public int compareTo(MethodNameClassKey other) {
        if (this.equals(other)){
            return 0;
        }else {
            return  -1;
        }
    }
}
