package com.chinamcloud.plugin.interceptor;

import lombok.extern.slf4j.Slf4j;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;

import java.io.Serializable;

/**
 * Created by jyy on 17/12/15.
 */
@Slf4j
public class PluginInterceptor extends PluginsAspectSupport implements MethodInterceptor, Serializable {


    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        /**
         * 包装了invocation
         */

        PluginOperationInvoker pluginOperationInvoker = (target, method, args) -> ReflectionUtils.invokeMethod(method,target,args);
        try {
            return execute(pluginOperationInvoker, invocation.getThis(), invocation.getMethod(), invocation.getArguments()); } catch (PluginOperationInvoker.ThrowableWrapper th) {
            throw th.getOriginal();
        }
    }
}
