package com.chinamcloud.plugin.interceptor;

import java.lang.reflect.Method;

/**
 * Created by jyy on 17/12/15.
 */
public interface PluginOperationInvoker {






    /**
     *  执行方法
     * @return
     * @throws ThrowableWrapper 包装异常
     */
    Object invoke(Object target, Method method, Object [] args) throws ThrowableWrapper;


    /**
     *  包装异常
     */
    @SuppressWarnings("serial")
    class ThrowableWrapper extends RuntimeException {

        private final Throwable original;

        public ThrowableWrapper(Throwable original) {
            super(original.getMessage(), original);
            this.original = original;
        }

        public Throwable getOriginal() {
            return this.original;
        }
    }
}
