package com.chinamcloud.plugin.interceptor;

import org.springframework.core.Ordered;

import java.lang.reflect.Method;

/**
 * Created by jyy on 17/12/14.
 * 插件描述信息数据源
 */
public abstract class PluginsOperation {

    /**
     * 执行顺序
     */
    private  Integer order = Ordered.LOWEST_PRECEDENCE;

    private Class targetClass;

    private String express;

    private Object object;

    private Method method;



    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Class gettargetClass() {
        return targetClass;
    }

    public void settargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Object getObject() {
        return object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Method getMethod() {
        return method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getExpress() {
        return express;
    }

    public void setExpress(String express) {
        this.express = express;
    }

    protected PluginsOperation(Builder b) {
        this.targetClass =b.targetClass;
        this.object =b.object;
        this.method = b.method;
        this.order = b.order;
        this.express = b.express;
    }


    public abstract static class Builder {



        private Integer order  = Ordered.LOWEST_PRECEDENCE;

        private Class targetClass;

        private Object object;

        private Method method;

        private String express;


        public String getExpress() {
            return express;
        }

        public void setExpress(String express) {
            this.express = express;
        }


        public Integer getOrder() {
            return order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public Class gettargetClass() {
            return targetClass;
        }

        public void settargetClass(Class targetClass) {
            this.targetClass = targetClass;
        }

        public Object getObject() {
            return object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public Method getMethod() {
            return method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        @Override
        public String toString() {
            return "Builder{" +
                    ", order=" + order +
                    ", targetClass=" + targetClass +
                    ", object=" + object +
                    ", method=" + method +
                    '}';
        }

        public abstract PluginsOperation build();
    }

}
