/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.convert.DB2J;
import dm.jdbc.desc.AbstractRowSet;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DBParameter;
import dm.jdbc.driver.DBWarning;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDataSource;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbRowSetMetaData;
import dm.jdbc.driver.DmdbRowSetReader;
import dm.jdbc.driver.DmdbRowSetWriter;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.Row;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.ReaderToInputStream;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;

public class DmdbRowSet
extends AbstractRowSet
implements RowSetInternal,
CachedRowSet {
    private transient DmdbConnection m_conn_bs = null;
    protected DmdbResultSet m_resultSet_bs = null;
    protected int m_currentRow = 0;
    protected boolean m_previousColNull;
    private int m_pageSize = 0;
    private boolean m_populatedDone = false;
    protected int m_columnCount = 0;
    protected int m_rowCount = 0;
    protected Vector m_rows = null;
    private Row m_insertRow = null;
    private int m_insertRowPos = 0;
    private int m_updateRowPos = 0;
    private boolean m_insertFlag = false;
    private boolean m_updateFlag = false;
    public Vector m_params = null;
    private SQLWarning m_sqlWarning = null;
    private RowSetWarning m_rowsetWarning;
    protected DmdbRowSetMetaData m_rsmd = null;
    private String[] m_columnNames = null;
    private String m_tableName = null;
    private int[] m_keyColumns;
    private DmdbRowSetReader m_reader;
    private DmdbRowSetWriter m_writer;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private SyncProvider m_syncProvider = null;
    protected boolean m_closed = false;
    private boolean m_KeepConnecting = false;

    public DmdbRowSet() {
        this.initialize();
    }

    private void initialize() {
        this.m_currentRow = 0;
        this.m_columnCount = 0;
        this.m_previousColNull = false;
        this.m_pageSize = 0;
        this.m_resultSet_bs = null;
        this.m_populatedDone = false;
        this.m_rowCount = 0;
        if (this.m_rows == null) {
            this.m_rows = new Vector(50);
        } else {
            this.m_rows.clear();
        }
        this.m_showDeleted = false;
        this.m_insertRow = null;
        this.m_insertRowPos = 0;
        this.m_insertFlag = false;
        this.m_updateFlag = false;
        this.m_params = new Vector(10);
        this.m_sqlWarning = new SQLWarning();
        this.m_rowsetWarning = new RowSetWarning();
        this.m_rsmd = null;
        this.m_columnNames = null;
        this.m_tableName = null;
        this.m_keyColumns = new int[0];
        this.m_reader = new DmdbRowSetReader();
        this.m_writer = new DmdbRowSetWriter();
        this.m_closed = false;
        this.m_KeepConnecting = false;
        try {
            this.m_syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
        }
        catch (SyncFactoryException syncFactoryException) {
            DBError.throwException("SyncProvider instance not constructed.", syncFactoryException);
        }
    }

    private void uninitialize() {
        this.m_currentRow = 0;
        this.m_columnCount = 0;
        this.m_resultSet_bs = null;
        this.m_populatedDone = false;
        this.m_rowCount = 0;
        this.m_rows = null;
        this.m_showDeleted = false;
        this.m_insertRow = null;
        this.m_insertRowPos = 0;
        this.m_insertFlag = false;
        this.m_updateFlag = false;
    }

    protected Row getCurrentRow() {
        if (this.m_currentRow < 1 || this.m_currentRow > this.m_rowCount) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        }
        return (Row)this.m_rows.elementAt(this.m_currentRow - 1);
    }

    protected synchronized Object getObjectInner(int n2) {
        this.checkColumn(n2);
        Row row = this.getCurrentRow();
        Object object = null;
        object = row.isColumnChanged(n2 - 1) ? row.getChangedColumn(n2 - 1) : row.getColumn(n2 - 1);
        boolean bl = this.m_previousColNull = object == null;
        if (!this.m_previousColNull && object instanceof Struct) {
            Struct struct = (Struct)object;
            object = DB2J.toSQLData(struct, this.getTypeMap());
        }
        return object;
    }

    protected synchronized Object getObjectInner(int n2, Map map) {
        this.checkColumn(n2);
        Row row = this.getCurrentRow();
        Object object = null;
        object = row.isColumnChanged(n2 - 1) ? row.getChangedColumn(n2 - 1) : row.getColumn(n2 - 1);
        boolean bl = this.m_previousColNull = object == null;
        if (!this.m_previousColNull && object instanceof Struct) {
            Struct struct = (Struct)object;
            object = DB2J.toSQLData(struct, this.getTypeMap());
        }
        return object;
    }

    protected synchronized InputStream getStreamInner(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof Byte) {
            byte[] byArray = new byte[]{};
            byArray[0] = (Byte)object;
            return new ByteArrayInputStream(byArray);
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(ByteUtil.fromString((String)object, this.m_conn_bs.getServerEncoding()));
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        if (object instanceof Clob) {
            return ((Clob)object).getAsciiStream();
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            ReaderToInputStream readerToInputStream = new ReaderToInputStream();
            InputStream inputStream = readerToInputStream.ReaderTo(bufferedReader, this.m_conn_bs.getServerEncoding());
            return inputStream;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    protected synchronized void updateObjectInner(int n2, Object object) {
        this.checkColumn(n2);
        if (this.m_insertFlag) {
            this.m_insertRow.updateColumnValue(n2 - 1, object);
            return;
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        } else {
            this.m_updateFlag = true;
            this.m_updateRowPos = this.m_currentRow;
            this.getCurrentRow().updateColumnValue(n2 - 1, object);
        }
    }

    protected synchronized Number getNumber(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            return new BigDecimal((String)object);
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return n2;
    }

    private boolean setOriginalRowInner(int n2) {
        Row row = (Row)this.m_rows.get(n2);
        if (row.isRowDeleted()) {
            this.m_rows.removeElementAt(n2);
            --this.m_rowCount;
            return true;
        }
        if (row.isRowInserted()) {
            row.setRowInserted(false);
        } else if (row.isRowUpdated()) {
            row.setUpdatesOriginal();
        }
        return false;
    }

    protected void setOriginal() {
        int n2 = 0;
        while (n2 < this.m_rowCount) {
            if (this.setOriginalRowInner(n2)) {
                --n2;
            }
            ++n2;
        }
    }

    protected synchronized void notifyCursorMoved() {
        if (this.m_insertFlag) {
            this.m_insertFlag = false;
            this.m_insertRow.setRowUpdated(false);
            this.m_sqlWarning.setNextWarning(DBWarning.getSQLWarning(DBError.ECJDBC_CRS_CURSOR_MOVED));
        } else if (this.m_updateFlag) {
            this.m_updateFlag = false;
            int n2 = this.m_currentRow;
            this.m_currentRow = this.m_updateRowPos;
            this.getCurrentRow().setRowUpdated(false);
            this.m_currentRow = n2;
            this.m_sqlWarning.setNextWarning(DBWarning.getSQLWarning(DBError.ECJDBC_CRS_CURSOR_MOVED));
        }
    }

    protected void checkCurrentRow() {
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        }
    }

    protected void checkColumn(int n2) {
        if (n2 < 1 || n2 > this.m_columnCount) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwException(new String[0]);
        }
    }

    private void checkRowSet() {
        if (this.m_rows == null || this.m_rows.size() == 0) {
            DBError.ECJDBC_ROW_SET_NULL.throwException(new String[0]);
        }
    }

    private void putParamToVector(Object object, DBParameter dBParameter) {
        boolean bl = false;
        int n2 = this.m_params.size();
        String string = null;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            DBParameter dBParameter2 = (DBParameter)this.m_params.elementAt(n4);
            string = dBParameter2.getParamName();
            n3 = dBParameter2.getParamIndex();
            if (string != null && string.equalsIgnoreCase((String)object) || string == null && n3 == (Integer)object) {
                this.m_params.set(n4, dBParameter);
                bl = true;
                break;
            }
            ++n4;
        }
        if (!bl) {
            this.m_params.add(dBParameter);
        }
    }

    protected void setObjectInner(Object object, Object object2) {
        Object[] objectArray = new Object[]{object2};
        this.putParamToVector(object, new DBParameter(object, objectArray));
    }

    protected void setObjectInner(Object object, Object object2, int n2, boolean bl) {
        Object[] objectArray = new Object[]{object2, n2};
        DBParameter dBParameter = new DBParameter(object, objectArray);
        dBParameter.setBySetObject(bl);
        this.putParamToVector(object, dBParameter);
    }

    protected void setObjectInner(Object object, Object object2, long l2) {
        Object[] objectArray = new Object[]{object2, l2};
        DBParameter dBParameter = new DBParameter(object, objectArray);
        this.putParamToVector(object, dBParameter);
    }

    protected void setObjectInner(Object object, Object object2, Calendar calendar) {
        Object[] objectArray = new Object[]{object2, calendar};
        this.putParamToVector(object, new DBParameter(object, objectArray));
    }

    protected void setObjectInner(Object object, Object object2, int n2, String string) {
        Object[] objectArray = new Object[]{object2, n2, string};
        DBParameter dBParameter = new DBParameter(object, objectArray);
        dBParameter.setBySetObject(true);
        this.putParamToVector(object, dBParameter);
    }

    protected void setObjectInner(Object object, Object object2, int n2, int n3) {
        Object[] objectArray = new Object[]{object2, n2, n3};
        DBParameter dBParameter = new DBParameter(object, objectArray);
        dBParameter.setBySetObject(true);
        this.putParamToVector(object, dBParameter);
    }

    boolean keepConnecting() {
        return this.m_KeepConnecting;
    }

    @Override
    public boolean next() {
        if (this.m_rowCount <= 0) {
            return false;
        }
        int n2 = this.getFetchDirection();
        if (n2 == 1000 || n2 == 1002) {
            if (this.m_currentRow < this.m_rowCount) {
                ++this.m_currentRow;
                Row row = this.getCurrentRow();
                if (!this.m_showDeleted && row.isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = this.m_rowCount + 1;
            return false;
        }
        if (n2 == 1001) {
            if (this.m_currentRow > 1) {
                --this.m_currentRow;
                Row row = this.getCurrentRow();
                if (!this.m_showDeleted && row.isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = 0;
            return false;
        }
        return false;
    }

    @Override
    public void beforeFirst() {
        this.m_currentRow = 0;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.m_rowCount > 0 && this.m_currentRow == 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.m_rowCount > 0 && this.m_currentRow == this.m_rowCount + 1;
    }

    @Override
    public boolean isFirst() {
        return this.m_rowCount > 0 && this.m_currentRow == 1;
    }

    @Override
    public boolean isLast() {
        return this.m_rowCount > 0 && this.m_currentRow == this.m_rowCount;
    }

    @Override
    public void afterLast() {
        this.m_currentRow = this.m_rowCount + 1;
    }

    @Override
    public boolean first() {
        return this.absolute(1);
    }

    @Override
    public boolean last() {
        return this.absolute(-1);
    }

    @Override
    public boolean absolute(int n2) {
        if (this.getType() == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if (n2 == 0 || this.m_rowCount == 0) {
            return false;
        }
        if (this.m_currentRow == n2) {
            return true;
        }
        if (n2 > 0 && Math.abs(n2) > this.m_rowCount) {
            this.m_currentRow = this.m_rowCount + 1;
            this.notifyCursorMoved();
            return false;
        }
        if (n2 < 0 && Math.abs(n2) > this.m_rowCount) {
            this.m_currentRow = 0;
            this.notifyCursorMoved();
            return false;
        }
        this.m_currentRow = n2 > 0 ? n2 : this.m_rowCount + n2 + 1;
        this.notifyCursorMoved();
        return true;
    }

    @Override
    public boolean relative(int n2) {
        return this.absolute(this.m_currentRow + n2);
    }

    @Override
    public boolean previous() {
        int n2;
        if (this.getType() == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwException(new String[0]);
        }
        if ((n2 = this.getFetchDirection()) == 1001) {
            if (this.m_currentRow < this.m_columnCount) {
                ++this.m_currentRow;
                if (!this.m_showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = this.m_columnCount + 1;
            this.notifyCursorMoved();
            return false;
        }
        if (n2 == 1000 || n2 == 1002) {
            if (this.m_currentRow > 1) {
                --this.m_currentRow;
                if (!this.m_showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = 0;
            this.notifyCursorMoved();
            return false;
        }
        return false;
    }

    @Override
    public boolean nextPage() {
        if (this.getFetchDirection() == 1001 && this.m_resultSet_bs != null && this.m_resultSet_bs.do_getType() == 1003) {
            DBError.ECJDBC_CRS_RESULTSET_NOTSUPT.throwException(new String[0]);
        }
        if (this.m_rows == null || this.m_rows.size() == 0 && !this.m_populatedDone) {
            DBError.ECJDBC_CRS_NPREP_PAGING.throwException(new String[0]);
        }
        if (this.m_resultSet_bs.do_isAfterLast()) {
            return false;
        }
        this.populate(this.m_resultSet_bs);
        return true;
    }

    @Override
    public boolean previousPage() {
        if (this.m_resultSet_bs != null && this.m_resultSet_bs.do_getType() == 1003) {
            DBError.ECJDBC_CRS_RESULTSET_NOTSUPT.throwException(new String[0]);
        }
        if (this.m_rows == null || this.m_rows.size() == 0 && !this.m_populatedDone) {
            DBError.ECJDBC_CRS_NPREP_PAGING.throwException(new String[0]);
        }
        if (this.m_resultSet_bs.do_isBeforeFirst() || this.m_resultSet_bs.currentPos < (long)this.m_pageSize) {
            return false;
        }
        this.m_resultSet_bs.do_relative(-(this.m_pageSize + this.m_rowCount + 1));
        this.populate(this.m_resultSet_bs);
        return true;
    }

    @Override
    public boolean rowUpdated() {
        return this.getCurrentRow().isRowUpdated();
    }

    @Override
    public boolean rowInserted() {
        return this.getCurrentRow().isRowInserted();
    }

    @Override
    public boolean rowDeleted() {
        return this.getCurrentRow().isRowDeleted();
    }

    @Override
    public void insertRow() {
        if (!this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_NOT_IN_INSERT_STATUS.throwException(new String[0]);
        }
        if (!this.m_insertRow.isRowFullyPopulated()) {
            DBError.ECJDBC_CRS_NPOPU_FULLY.throwException(new String[0]);
        }
        this.m_insertRow.insertRow();
        this.m_rows.insertElementAt(this.m_insertRow, this.m_insertRowPos - 1);
        ++this.m_rowCount;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() {
        if (!this.m_updateFlag) {
            DBError.ECJDBC_RESULTSET_NOT_IN_INSERT_STATUS.throwException(new String[0]);
        }
        this.getCurrentRow().setRowUpdated(true);
        this.m_updateFlag = false;
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() {
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() {
        this.cancelRowUpdates();
    }

    @Override
    public void cancelRowUpdates() {
        Row row = this.getCurrentRow();
        if (row.isRowUpdated()) {
            this.m_updateFlag = false;
            row.setRowUpdated(false);
            this.notifyRowChanged();
        }
    }

    public void cancelRowInsert() {
        if (this.m_insertRow != null) {
            this.m_rows.remove(this.m_insertRowPos - 1);
            --this.m_rowCount;
            this.m_insertRow = null;
            this.notifyRowChanged();
        }
    }

    public void cancelRowDelete() {
        Row row = this.getCurrentRow();
        if (row.isRowDeleted()) {
            row.setRowDeleted(false);
            this.notifyRowChanged();
        }
    }

    @Override
    public void moveToInsertRow() {
        this.m_insertRow = new Row(this.m_columnCount, true);
        this.m_insertFlag = true;
        this.m_insertRowPos = this.isAfterLast() ? this.m_currentRow : this.m_currentRow + 1;
    }

    @Override
    public void moveToCurrentRow() {
        if (this.m_insertFlag) {
            this.m_insertFlag = false;
            this.m_updateFlag = false;
            this.absolute(this.m_currentRow);
        }
    }

    @Override
    public void populate(ResultSet resultSet) {
        boolean bl;
        if (resultSet == null) {
            DBError.ECJDBC_CRS_RS_NULL.throwException(new String[0]);
        }
        this.m_resultSet_bs = (DmdbResultSet)resultSet;
        this.m_resultSet_bs.checkClosed();
        this.m_rsmd = new DmdbRowSetMetaData(this.m_resultSet_bs.connection, this.m_resultSet_bs.columns);
        this.m_columnCount = this.m_rsmd.getColumnCount();
        this.m_columnNames = new String[this.m_columnCount];
        int n2 = 0;
        while (n2 < this.m_columnCount) {
            this.m_columnNames[n2] = this.m_rsmd.getColumnName(n2 + 1);
            ++n2;
        }
        if (this.m_columnCount < 1) {
            return;
        }
        this.m_tableName = this.m_rsmd.getTableName(1);
        long l2 = 0L;
        long l3 = this.getMaxRows();
        l2 = l3 == 0L && this.m_pageSize == 0 ? Long.MAX_VALUE : (l3 == 0L || this.m_pageSize == 0 ? Math.max(l3, (long)this.m_pageSize) : Math.min(l3, (long)this.m_pageSize));
        int n3 = this.getFetchDirection();
        boolean bl2 = bl = n3 == 1000 || n3 == 1002;
        if (this.m_resultSet_bs.do_isBeforeFirst() && !bl && this.m_resultSet_bs.do_getType() != 1003) {
            this.m_resultSet_bs.do_afterLast();
        }
        if (this.m_rows == null) {
            this.m_rows = new Vector(50);
        } else {
            this.m_rows.clear();
        }
        this.m_currentRow = 0;
        this.m_rowCount = 0;
        while ((long)this.m_rowCount < l2 && !(bl ? !this.m_resultSet_bs.do_next() : !this.m_resultSet_bs.do_previous())) {
            Row row = new Row(this.m_columnCount);
            int n4 = 0;
            while (n4 < this.m_columnCount) {
                Cloneable cloneable;
                Object object = this.m_resultSet_bs.do_getObject(n4 + 1, this.getTypeMap());
                if (object instanceof Clob) {
                    cloneable = new SerialClob((Clob)object);
                    row.setColumnValue(n4, cloneable);
                } else if (object instanceof Blob) {
                    cloneable = new SerialBlob((Blob)object);
                    row.setColumnValue(n4, cloneable);
                } else {
                    row.setColumnValue(n4, object);
                    row.setOriginalNull(n4, this.m_resultSet_bs.do_wasNull());
                }
                ++n4;
            }
            if (bl) {
                this.m_rows.add(row);
            } else {
                this.m_rows.add(0, row);
            }
            ++this.m_rowCount;
        }
        if (bl && this.m_resultSet_bs.do_isAfterLast() || !bl && this.m_resultSet_bs.do_isBeforeFirst()) {
            this.m_populatedDone = true;
        }
        this.notifyRowSetChanged();
    }

    @Override
    public void populate(ResultSet resultSet, int n2) {
        boolean bl;
        if (n2 < 0) {
            DBError.ECJDBC_CRS_STARTROW_NNEG.throwException(new String[0]);
        }
        if (resultSet == null) {
            DBError.ECJDBC_CRS_RS_NULL.throwException(new String[0]);
        }
        DmdbResultSet dmdbResultSet = (DmdbResultSet)resultSet;
        if (dmdbResultSet.totalRowCount < (long)n2) {
            DBError.ECJDBC_CRS_RS_TFEW_TOSTARTP.throwException(new String[0]);
        }
        dmdbResultSet.do_absolute(n2);
        int n3 = dmdbResultSet.do_getFetchDirection();
        boolean bl2 = bl = n3 == 1000 || n3 == 1002;
        if (bl) {
            dmdbResultSet.do_previous();
        } else {
            dmdbResultSet.do_next();
        }
        this.populate(resultSet);
    }

    @Override
    public void execute() {
        this.m_reader.readData(this);
    }

    @Override
    public void execute(Connection connection) {
        this.m_KeepConnecting = true;
        this.m_conn_bs = (DmdbConnection)connection;
        this.m_reader.readData(this);
    }

    @Override
    public void acceptChanges() {
        try {
            this.m_writer.writeData(this);
        }
        catch (SQLException sQLException) {
            DBError.throwSyncProviderException(sQLException);
        }
    }

    @Override
    public void acceptChanges(Connection connection) {
        this.m_KeepConnecting = true;
        this.m_conn_bs = (DmdbConnection)connection;
        this.acceptChanges();
    }

    @Override
    public void restoreOriginal() {
        int n2 = 0;
        while (n2 < this.m_rowCount) {
            Row row = (Row)this.m_rows.elementAt(n2);
            if (row.isRowInserted()) {
                this.m_rows.remove(n2);
                --this.m_rowCount;
                --n2;
            } else if (row.isRowUpdated()) {
                row.setRowUpdated(false);
            } else if (row.isRowDeleted()) {
                row.setRowDeleted(false);
            }
            ++n2;
        }
        this.notifyRowSetChanged();
    }

    @Override
    public void release() {
        this.uninitialize();
        this.notifyRowSetChanged();
    }

    @Override
    public void close() {
        if (this.m_closed) {
            return;
        }
        if (this.m_conn_bs != null && !this.m_conn_bs.do_isClosed()) {
            this.m_conn_bs.do_close();
            this.m_conn_bs = null;
        }
        this.release();
        this.m_closed = true;
    }

    @Override
    public void undoDelete() {
        Row row;
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        }
        if (!(row = this.getCurrentRow()).isRowDeleted()) {
            DBError.ECJDBC_ROW_SET_NOT_DEL.throwException(new String[0]);
        }
        row.setRowDeleted(false);
        this.notifyRowChanged();
    }

    @Override
    public void undoInsert() {
        Row row;
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        }
        if (!(row = this.getCurrentRow()).isRowInserted()) {
            DBError.ECJDBC_ROW_SET_NOT_INSERT.throwException(new String[0]);
        }
        this.m_rows.remove(--this.m_currentRow);
        --this.m_rowCount;
        this.notifyRowChanged();
    }

    @Override
    public void undoUpdate() {
        Row row;
        if (this.m_insertFlag) {
            DBError.ECJDBC_RESULTSET_IN_INSERT_STATUS.throwException(new String[0]);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        }
        if (!(row = this.getCurrentRow()).isRowUpdated()) {
            DBError.ECJDBC_ROW_SET_NOT_UPDATE.throwException(new String[0]);
        }
        row.setRowUpdated(false);
        this.notifyRowChanged();
    }

    @Override
    public boolean columnUpdated(int n2) {
        this.checkColumn(n2);
        this.checkCurrentRow();
        return this.getCurrentRow().isColumnChanged(n2 - 1);
    }

    @Override
    public boolean columnUpdated(String string) {
        int n2 = this.findColumn(string);
        return this.columnUpdated(n2);
    }

    public Collection toCollection() {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            int n2 = 0;
            while (n2 < this.m_rowCount) {
                map.put(n2, ((Row)this.m_rows.elementAt(n2)).toCollection());
                ++n2;
            }
        }
        catch (Exception exception) {
            map = null;
            DBError.ECJDBC_ROW_SET_TO_CLC_FAILED.throwException(new String[0]);
        }
        return map.values();
    }

    public Collection toCollection(int n2) {
        this.checkColumn(n2);
        Vector<Object> vector = new Vector<Object>(this.m_rowCount);
        int n3 = 0;
        while (n3 < this.m_rowCount) {
            Row row = (Row)this.m_rows.elementAt(n3);
            Object object = row.isColumnChanged(n2 - 1) ? row.getChangedColumn(n2 - 1) : row.getColumn(n2 - 1);
            vector.add(object);
            ++n3;
        }
        return vector;
    }

    public Collection toCollection(String string) {
        int n2 = this.findColumn(string);
        return this.toCollection(n2);
    }

    @Override
    public SyncProvider getSyncProvider() {
        return this.m_syncProvider;
    }

    @Override
    public void setSyncProvider(String string) {
        try {
            this.m_syncProvider = SyncFactory.getInstance(string);
        }
        catch (SyncFactoryException syncFactoryException) {
            DBError.throwException("SyncProvider instance not constructed.", syncFactoryException);
        }
    }

    @Override
    public int size() {
        return this.m_rowCount;
    }

    protected Row getOriginalRowData() {
        return new Row(this.m_columnCount, this.getCurrentRow().getOriginalRow());
    }

    @Override
    public void setOriginalRow() {
        this.checkCurrentRow();
        this.setOriginalRowInner(this.m_currentRow);
    }

    @Override
    public String getTableName() {
        return this.m_tableName;
    }

    @Override
    public void setTableName(String string) {
        if (string == null) {
            DBError.ECJDBC_ROW_SET_TAB_NAME_NULL.throwException(new String[0]);
        }
        this.m_tableName = string;
    }

    @Override
    public int[] getKeyColumns() {
        this.checkRowSet();
        return this.m_keyColumns;
    }

    @Override
    public void setKeyColumns(int[] nArray) {
        boolean bl = true;
        if (nArray == null) {
            bl = false;
        } else {
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                if (n4 < 1 || n4 > this.m_columnCount) {
                    bl = false;
                    break;
                }
                ++n3;
            }
        }
        if (!bl) {
            DBError.ECJDBC_ROW_SET_COL_KEY_INVALID.throwException(new String[0]);
        }
        this.m_keyColumns = nArray;
    }

    @Override
    public RowSetWarning getRowSetWarnings() {
        return this.m_rowsetWarning;
    }

    @Override
    public void setPageSize(int n2) {
        if (n2 < 1 || this.getMaxRows() > 0 && n2 > this.getMaxRows()) {
            DBError.ECJDBC_ROW_SET_PAGE_SIZE_INVALID.throwException(new String[0]);
        }
        this.m_pageSize = n2;
    }

    @Override
    public int getPageSize() {
        return this.m_pageSize;
    }

    @Override
    public int findColumn(String string) {
        if (this.m_columnNames == null) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwException(new String[0]);
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.m_columnNames.length) {
            if (this.m_columnNames[n3].equalsIgnoreCase(string)) {
                n2 = n3 + 1;
                break;
            }
            ++n3;
        }
        if (n2 < 1) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwException(new String[0]);
        }
        return n2;
    }

    @Override
    public Object[] getParams() {
        int n2 = this.m_params.size();
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            objectArray[n3] = ((DBParameter)this.m_params.elementAt(n3)).getParams()[0];
            ++n3;
        }
        return objectArray;
    }

    public void setReader(RowSetReader rowSetReader) {
        this.m_reader = (DmdbRowSetReader)rowSetReader;
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.m_writer = (DmdbRowSetWriter)rowSetWriter;
    }

    protected void rowsetShared(DmdbRowSet dmdbRowSet) {
        dmdbRowSet.m_rows = this.m_rows;
        dmdbRowSet.setDataSourceName(this.getDataSourceName());
        dmdbRowSet.setUsername(this.getUsername());
        dmdbRowSet.setPassword(this.getPassword());
        dmdbRowSet.setUrl(this.getUrl());
        dmdbRowSet.setTypeMap(this.getTypeMap());
        dmdbRowSet.setMaxFieldSize(this.getMaxFieldSize());
        dmdbRowSet.setMaxRows(this.getMaxRows());
        dmdbRowSet.setQueryTimeout(this.getQueryTimeout());
        dmdbRowSet.setFetchSize(this.getFetchSize());
        dmdbRowSet.setEscapeProcessing(this.getEscapeProcessing());
        dmdbRowSet.setConcurrency(this.getConcurrency());
        dmdbRowSet.setReadOnly(this.isReadOnly());
        dmdbRowSet.setType(this.getType());
        dmdbRowSet.setFetchDirection(this.getFetchDirection());
        dmdbRowSet.setCommand(this.getCommand());
        dmdbRowSet.setTransactionIsolation(this.getTransactionIsolation());
        dmdbRowSet.m_currentRow = this.m_currentRow;
        dmdbRowSet.m_columnCount = this.m_columnCount;
        dmdbRowSet.m_rowCount = this.m_rowCount;
        dmdbRowSet.m_showDeleted = this.m_showDeleted;
        dmdbRowSet.m_syncProvider = this.m_syncProvider;
        dmdbRowSet.m_pageSize = this.m_pageSize;
        dmdbRowSet.m_tableName = this.m_tableName;
        dmdbRowSet.m_keyColumns = this.m_keyColumns != null ? (int[])this.m_keyColumns.clone() : null;
        int n2 = this.m_listeners.size();
        int n3 = 0;
        while (n3 < n2) {
            dmdbRowSet.m_listeners.add((RowSetListener)this.m_listeners.elementAt(n3));
            ++n3;
        }
        dmdbRowSet.m_rsmd = this.m_rsmd;
        n2 = this.m_params.size();
        n3 = 0;
        while (n3 < n2) {
            dmdbRowSet.m_params.add((DBParameter)this.m_params.elementAt(n3));
            ++n3;
        }
        if (this.m_columnNames != null) {
            dmdbRowSet.m_columnNames = new String[this.m_columnNames.length];
            System.arraycopy(this.m_columnNames, 0, dmdbRowSet.m_columnNames, 0, this.m_columnNames.length);
        }
    }

    protected void rowsetCopy(DmdbRowSet dmdbRowSet) {
        this.rowsetShared(dmdbRowSet);
        dmdbRowSet.m_rows = new Vector(dmdbRowSet.m_rowCount);
        int n2 = 0;
        while (n2 < this.m_rowCount) {
            dmdbRowSet.m_rows.add(((Row)this.m_rows.elementAt(n2)).createCopy());
            ++n2;
        }
    }

    public void setTIMESTAMP(int n2, DmdbTimestamp dmdbTimestamp) {
        this.setObjectInner(n2, dmdbTimestamp);
    }

    public void setTIMESTAMP(String string, DmdbTimestamp dmdbTimestamp) {
        this.setObjectInner(string, dmdbTimestamp);
    }

    public void setINTERVALDT(int n2, DmdbIntervalDT dmdbIntervalDT) {
        this.setObjectInner(n2, dmdbIntervalDT);
    }

    public void setINTERVALDT(String string, DmdbIntervalDT dmdbIntervalDT) {
        this.setObjectInner(string, dmdbIntervalDT);
    }

    public void setINTERVALYM(int n2, DmdbIntervalYM dmdbIntervalYM) {
        this.setObjectInner(n2, dmdbIntervalYM);
    }

    public void setINTERVALYM(String string, DmdbIntervalYM dmdbIntervalYM) {
        this.setObjectInner(string, dmdbIntervalYM);
    }

    public void updateINTERVALYM(int n2, DmdbIntervalYM dmdbIntervalYM) {
        this.updateObjectInner(n2, dmdbIntervalYM);
    }

    public void updateINTERVALYM(String string, DmdbIntervalYM dmdbIntervalYM) {
        this.updateINTERVALYM(this.findColumn(string), dmdbIntervalYM);
    }

    public void updateINTERVALDT(int n2, DmdbIntervalDT dmdbIntervalDT) {
        this.updateObjectInner(n2, dmdbIntervalDT);
    }

    public void updateINTERVALDT(String string, DmdbIntervalDT dmdbIntervalDT) {
        this.updateINTERVALDT(this.findColumn(string), dmdbIntervalDT);
    }

    @Override
    public void setNull(int n2, int n3) {
        this.setObjectInner((Object)n2, null, n3, false);
    }

    @Override
    public void setNull(int n2, int n3, String string) {
        this.setObjectInner((Object)n2, null, n3, string);
    }

    @Override
    public void setBoolean(int n2, boolean bl) {
        this.setObjectInner(n2, bl);
    }

    @Override
    public void setByte(int n2, byte by) {
        this.setObjectInner(n2, by);
    }

    @Override
    public void setShort(int n2, short s2) {
        this.setObjectInner(n2, s2);
    }

    @Override
    public void setInt(int n2, int n3) {
        this.setObjectInner(n2, n3);
    }

    @Override
    public void setLong(int n2, long l2) {
        this.setObjectInner(n2, l2);
    }

    @Override
    public void setFloat(int n2, float f2) {
        this.setObjectInner(n2, Float.valueOf(f2));
    }

    @Override
    public void setDouble(int n2, double d2) {
        this.setObjectInner(n2, d2);
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) {
        this.setObjectInner(n2, bigDecimal);
    }

    @Override
    public void setString(int n2, String string) {
        this.setObjectInner(n2, string);
    }

    @Override
    public void setBytes(int n2, byte[] byArray) {
        this.setObjectInner(n2, byArray);
    }

    @Override
    public void setDate(int n2, Date date) {
        this.setObjectInner(n2, date);
    }

    @Override
    public void setTime(int n2, Time time) {
        this.setObjectInner(n2, time);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) {
        this.setObjectInner(n2, timestamp);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) {
        this.setObjectInner((Object)n2, (Object)inputStream, n3, false);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) {
        this.setObjectInner((Object)n2, (Object)inputStream, n3, false);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) {
        this.setObjectInner((Object)n2, (Object)reader, n3, false);
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) {
        this.setObjectInner((Object)n2, object, n3, n4);
    }

    @Override
    public void setObject(int n2, Object object, int n3) {
        this.setObjectInner((Object)n2, object, n3, true);
    }

    @Override
    public void setObject(int n2, Object object) {
        this.setObjectInner(n2, object);
    }

    @Override
    public void setRef(int n2, Ref ref) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void setBlob(int n2, Blob blob) {
        this.setObjectInner(n2, blob);
    }

    @Override
    public void setClob(int n2, Clob clob) {
        this.setObjectInner(n2, clob);
    }

    @Override
    public void setArray(int n2, Array array) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) {
        this.setObjectInner((Object)n2, (Object)date, calendar);
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) {
        this.setObjectInner((Object)n2, (Object)time, calendar);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) {
        this.setObjectInner((Object)n2, (Object)timestamp, calendar);
    }

    @Override
    public void clearParameters() {
        this.m_params.clear();
    }

    @Override
    public boolean wasNull() {
        return this.m_previousColNull;
    }

    @Override
    public boolean getBoolean(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return false;
    }

    @Override
    public short getShort(int n2) {
        Number number = this.getNumber(n2);
        return number == null ? (short)0 : number.shortValue();
    }

    @Override
    public int getInt(int n2) {
        Number number = this.getNumber(n2);
        return number == null ? 0 : number.intValue();
    }

    @Override
    public long getLong(int n2) {
        Number number = this.getNumber(n2);
        return number == null ? 0L : number.longValue();
    }

    @Override
    public float getFloat(int n2) {
        Number number = this.getNumber(n2);
        return number == null ? 0.0f : number.floatValue();
    }

    @Override
    public double getDouble(int n2) {
        Number number = this.getNumber(n2);
        return number == null ? 0.0 : number.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) {
        Number number = this.getNumber(n2);
        if (number == null) {
            return null;
        }
        BigDecimal bigDecimal = null;
        bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.doubleValue());
        bigDecimal.setScale(n3);
        return bigDecimal;
    }

    @Override
    public Date getDate(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            return new Date(time.getTime());
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new Date(timestamp.getTime());
        }
        if (object instanceof String) {
            return DateUtil.toDate((String)object, null);
        }
        if (object instanceof DmdbTimestamp) {
            return ((DmdbTimestamp)object).toDate();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public Time getTime(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new Time(date.getTime());
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new Time(timestamp.getTime());
        }
        if (object instanceof String) {
            return DateUtil.toTime((String)object, null);
        }
        if (object instanceof DmdbTimestamp) {
            return ((DmdbTimestamp)object).toTime();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public Timestamp getTimestamp(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Time) {
            return new Timestamp(((Time)object).getTime());
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof String) {
            return DateUtil.toTimestamp((String)object, null);
        }
        if (object instanceof DmdbTimestamp) {
            return ((DmdbTimestamp)object).toTimestamp();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public InputStream getAsciiStream(int n2) {
        return this.getStreamInner(n2);
    }

    @Override
    public InputStream getUnicodeStream(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public InputStream getBinaryStream(int n2) {
        return this.getStreamInner(n2);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public short getShort(String string) {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    @Override
    public Date getDate(String string) {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() {
        return this.m_sqlWarning;
    }

    @Override
    public void clearWarnings() {
        this.m_sqlWarning = null;
    }

    @Override
    public String getCursorName() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Object getObject(int n2) {
        return this.getObjectInner(n2, this.getTypeMap());
    }

    @Override
    public Object getObject(String string) {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])object));
        }
        if (object instanceof Byte) {
            byte[] byArray = new byte[]{(Byte)object};
            return new InputStreamReader(new ByteArrayInputStream(byArray));
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        if (object instanceof Blob) {
            return new InputStreamReader(((Blob)object).getBinaryStream());
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2) {
        Number number = this.getNumber(n2);
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.doubleValue());
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public int getRow() {
        return this.m_currentRow;
    }

    @Override
    public void updateNull(int n2) {
        this.updateObjectInner(n2, null);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) {
        this.updateObjectInner(n2, bl);
    }

    @Override
    public void updateByte(int n2, byte by) {
        this.updateObjectInner(n2, by);
    }

    @Override
    public void updateShort(int n2, short s2) {
        this.updateObjectInner(n2, s2);
    }

    @Override
    public void updateInt(int n2, int n3) {
        this.updateObjectInner(n2, n3);
    }

    @Override
    public void updateLong(int n2, long l2) {
        this.updateObjectInner(n2, l2);
    }

    @Override
    public void updateFloat(int n2, float f2) {
        this.updateObjectInner(n2, Float.valueOf(f2));
    }

    @Override
    public void updateDouble(int n2, double d2) {
        this.updateObjectInner(n2, d2);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) {
        this.updateObjectInner(n2, bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) {
        this.updateObjectInner(n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) {
        this.updateObjectInner(n2, byArray);
    }

    @Override
    public void updateDate(int n2, Date date) {
        this.updateObjectInner(n2, date);
    }

    @Override
    public void updateTime(int n2, Time time) {
        this.updateObjectInner(n2, time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) {
        this.updateObjectInner(n2, timestamp);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) {
        this.updateObjectInner(n2, inputStream);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) {
        this.updateObjectInner(n2, inputStream);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) {
        this.updateObjectInner(n2, reader);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) {
        this.updateObjectInner(n2, object);
    }

    @Override
    public void updateObject(int n2, Object object) {
        this.updateObjectInner(n2, object);
    }

    @Override
    public void updateNull(String string) {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s2) {
        this.updateShort(this.findColumn(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) {
        this.updateInt(this.findColumn(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) {
        this.updateLong(this.findColumn(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) {
        this.updateFloat(this.findColumn(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) {
        this.updateDouble(this.findColumn(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) {
        this.updateObject(string, object);
    }

    @Override
    public void updateObject(String string, Object object) {
        this.updateObjectInner(this.findColumn(string), object);
    }

    public Object getObject(int n2, Map map) {
        return this.getObjectInner(n2, map);
    }

    @Override
    public Ref getRef(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Blob getBlob(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof SerialBlob) {
            return (Blob)object;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public Clob getClob(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof SerialClob) {
            return (Clob)object;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public Array getArray(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Array) {
            return (Array)object;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    public Object getObject(String string, Map map) {
        return this.getObjectInner(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Blob getBlob(String string) {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) {
        return this.getDate(n2);
    }

    @Override
    public Date getDate(String string, Calendar calendar) {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) {
        return this.getTime(n2);
    }

    @Override
    public Time getTime(String string, Calendar calendar) {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) {
        return this.getTimestamp(n2);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public URL getURL(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public void updateRef(int n2, Ref ref) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateRef(String string, Ref ref) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBlob(int n2, Blob blob) {
        this.updateObjectInner(n2, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) {
        this.updateObjectInner(n2, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateArray(int n2, Array array) {
        this.updateObjectInner(n2, array);
    }

    @Override
    public void updateArray(String string, Array array) {
        this.updateObjectInner(this.findColumn(string), array);
    }

    @Override
    public void commit() {
        this.getConnection().commit();
    }

    @Override
    public void rollback() {
        this.getConnection().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) {
        this.getConnection().rollback(savepoint);
    }

    @Override
    public DmdbConnection getConnection() {
        if (!this.m_closed && this.m_conn_bs != null && !this.m_conn_bs.do_isClosed()) {
            return this.m_conn_bs;
        }
        String string = this.getDataSourceName();
        if (string != null) {
            try {
                Properties properties = System.getProperties();
                InitialContext initialContext = new InitialContext(properties);
                DmdbDataSource dmdbDataSource = (DmdbDataSource)initialContext.lookup(string);
                this.m_conn_bs = (DmdbConnection)dmdbDataSource.getConnection();
            }
            catch (NamingException namingException) {
                DBError.throwException("Unable to connect through the DataSource", namingException);
            }
        } else {
            Properties properties = new Properties();
            if (StringUtil.isNotEmpty(this.m_userName)) {
                properties.setProperty("user", this.m_userName);
            }
            if (StringUtil.isNotEmpty(this.m_password)) {
                properties.setProperty("password", this.m_password);
            }
            this.m_conn_bs = (DmdbConnection)DmDriver.driver.connect(this.getUrl(), properties);
        }
        this.m_conn_bs.do_setTransactionIsolation(this.getTransactionIsolation());
        this.m_conn_bs.do_setTypeMap(this.getTypeMap());
        this.m_closed = false;
        return this.m_conn_bs;
    }

    @Override
    public String getString(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof SerialBlob) {
            SerialBlob serialBlob = (SerialBlob)object;
            byte[] byArray = serialBlob.getBytes(1L, (int)serialBlob.length());
            return new String(byArray);
        }
        if (object instanceof SerialClob) {
            SerialClob serialClob = (SerialClob)object;
            return serialClob.getSubString(1L, (int)serialClob.length());
        }
        return object.toString();
    }

    @Override
    public byte getByte(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof SerialBlob) {
            SerialBlob serialBlob = (SerialBlob)object;
            byte[] byArray = serialBlob.getBytes(1L, (int)serialBlob.length());
            return byArray[0];
        }
        if (object instanceof SerialClob) {
            SerialClob serialClob = (SerialClob)object;
            return serialClob.getSubString(1L, (int)serialClob.length()).getBytes()[0];
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return 0;
    }

    @Override
    public byte[] getBytes(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return object.toString().getBytes();
        }
        if (object instanceof SerialBlob) {
            SerialBlob serialBlob = (SerialBlob)object;
            byte[] byArray = serialBlob.getBytes(1L, (int)serialBlob.length());
            return byArray;
        }
        if (object instanceof SerialClob) {
            SerialClob serialClob = (SerialClob)object;
            return serialClob.getSubString(1L, (int)serialClob.length()).getBytes();
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public String getString(String string) {
        return this.getString(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.m_rsmd;
    }

    @Override
    public Statement getStatement() {
        if (this.m_resultSet_bs != null) {
            return this.m_resultSet_bs.do_getStatement();
        }
        DBError.ECJDBC_ROW_SET_RS_NOT_OPEN.throwException(new String[0]);
        return null;
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) {
        this.m_rsmd = (DmdbRowSetMetaData)rowSetMetaData;
        if (this.m_rsmd != null) {
            this.m_columnCount = this.m_rsmd.getColumnCount();
            this.m_columnNames = new String[this.m_columnCount];
            int n2 = 0;
            while (n2 < this.m_columnCount) {
                this.m_columnNames[n2] = this.m_rsmd.getColumnName(n2 + 1);
                ++n2;
            }
        }
    }

    @Override
    public ResultSet getOriginal() {
        DmdbRowSet dmdbRowSet = new DmdbRowSet();
        dmdbRowSet.m_rsmd = this.m_rsmd;
        dmdbRowSet.m_rowCount = this.m_rowCount;
        dmdbRowSet.m_columnCount = this.m_columnCount;
        dmdbRowSet.m_currentRow = 0;
        dmdbRowSet.setType(1004);
        dmdbRowSet.setConcurrency(1008);
        dmdbRowSet.setReader(null);
        dmdbRowSet.setWriter(null);
        Row row = null;
        int n2 = 0;
        while (n2 < this.m_rows.size()) {
            row = new Row(this.m_columnCount, ((Row)this.m_rows.elementAt(n2)).getOriginalRow());
            dmdbRowSet.m_rows.add(row);
            ++n2;
        }
        return dmdbRowSet;
    }

    @Override
    public ResultSet getOriginalRow() {
        DmdbRowSet dmdbRowSet = new DmdbRowSet();
        dmdbRowSet.m_rsmd = this.m_rsmd;
        dmdbRowSet.m_rowCount = 1;
        dmdbRowSet.m_columnCount = this.m_columnCount;
        dmdbRowSet.m_currentRow = 0;
        dmdbRowSet.setReader(null);
        dmdbRowSet.setWriter(null);
        Row row = new Row(this.m_rsmd.getColumnCount(), this.getCurrentRow().getOriginalRow());
        dmdbRowSet.m_rows.add(row);
        return dmdbRowSet;
    }

    @Override
    public RowId getRowId(int n2) {
        Object object = this.getObjectInner(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return new DmdbRowId((Long)object, this.m_rsmd.getSchemaName(n2), this.m_tableName);
        }
        if (object instanceof RowId) {
            return (RowId)object;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    @Override
    public RowId getRowId(String string) {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public void updateRowId(int n2, RowId rowId) {
        this.updateObjectInner(n2, rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) {
        this.updateObjectInner(this.findColumn(string), rowId);
    }

    @Override
    public int getHoldability() {
        return this.m_resultSet_bs.holdability;
    }

    @Override
    public boolean isClosed() {
        return this.m_closed;
    }

    @Override
    public void updateNString(int n2, String string) {
        this.updateString(n2, string);
    }

    @Override
    public void updateNString(String string, String string2) {
        this.updateString(string, string2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) {
        this.updateClob(n2, (Clob)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) {
        this.updateClob(string, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int n2) {
        return (NClob)this.getClob(n2);
    }

    @Override
    public NClob getNClob(String string) {
        return (NClob)this.getClob(string);
    }

    @Override
    public SQLXML getSQLXML(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public String getNString(int n2) {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) {
        return this.getString(string);
    }

    @Override
    public Reader getNCharacterStream(int n2) {
        return this.getCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) {
        return this.getCharacterStream(string);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) {
        this.updateCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) {
        this.updateCharacterStream(string, reader, l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) {
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) {
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) {
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) {
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) {
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) {
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) {
        this.updateClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) {
        this.updateClob(string, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) {
        this.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) {
        this.updateCharacterStream(string, reader);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) {
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) {
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) {
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) {
    }

    @Override
    public void updateClob(int n2, Reader reader) {
    }

    @Override
    public void updateClob(String string, Reader reader) {
    }

    @Override
    public void updateNClob(int n2, Reader reader) {
        this.updateClob(n2, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) {
        this.updateClob(string, reader);
    }

    public Object getObject(int n2, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public Object getObject(String string, Class clazz) {
        return this.getObject(this.findColumn(string), clazz);
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public void setNull(String string, int n2) {
        this.setObjectInner((Object)string, null, n2, false);
    }

    @Override
    public void setNull(String string, int n2, String string2) {
        this.setObjectInner((Object)string, null, n2, string2);
    }

    @Override
    public void setBoolean(String string, boolean bl) {
        this.setObjectInner(string, bl);
    }

    @Override
    public void setByte(String string, byte by) {
        this.setObjectInner(string, by);
    }

    @Override
    public void setShort(String string, short s2) {
        this.setObjectInner(string, s2);
    }

    @Override
    public void setInt(String string, int n2) {
        this.setObjectInner(string, n2);
    }

    @Override
    public void setLong(String string, long l2) {
        this.setObjectInner(string, l2);
    }

    @Override
    public void setFloat(String string, float f2) {
        this.setObjectInner(string, Float.valueOf(f2));
    }

    @Override
    public void setDouble(String string, double d2) {
        this.setObjectInner(string, d2);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) {
        this.setObjectInner(string, bigDecimal);
    }

    @Override
    public void setString(String string, String string2) {
        this.setObjectInner(string, string2);
    }

    @Override
    public void setBytes(String string, byte[] byArray) {
        this.setObjectInner(string, byArray);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) {
        this.setObjectInner(string, timestamp);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) {
        this.setObjectInner((Object)string, (Object)inputStream, n2);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) {
        this.setObjectInner((Object)string, (Object)inputStream, n2);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) {
        this.setObjectInner((Object)string, (Object)reader, n2);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) {
        this.setObjectInner(n2, inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) {
        this.setObjectInner(string, inputStream);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) {
        this.setObjectInner(n2, inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) {
        this.setObjectInner(string, inputStream);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) {
        this.setObjectInner(n2, reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) {
        this.setObjectInner(string, reader);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) {
        this.setCharacterStream(n2, reader);
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) {
        this.setObjectInner((Object)string, object, n2, n3);
    }

    @Override
    public void setObject(String string, Object object, int n2) {
        this.setObjectInner((Object)string, object, n2);
    }

    @Override
    public void setObject(String string, Object object) {
        this.setObjectInner(string, object);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) {
        this.setObjectInner((Object)n2, (Object)inputStream, l2);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) {
        this.setObjectInner(n2, inputStream);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) {
        this.setObjectInner((Object)string, (Object)inputStream, l2);
    }

    @Override
    public void setBlob(String string, Blob blob) {
        this.setObjectInner(string, blob);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) {
        this.setObjectInner(string, inputStream);
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) {
        this.setObjectInner((Object)n2, (Object)reader, l2);
    }

    @Override
    public void setClob(int n2, Reader reader) {
        this.setObjectInner(n2, reader);
    }

    @Override
    public void setClob(String string, Reader reader, long l2) {
        this.setObjectInner((Object)string, (Object)reader, l2);
    }

    @Override
    public void setClob(String string, Clob clob) {
        this.setObjectInner(string, clob);
    }

    @Override
    public void setClob(String string, Reader reader) {
        this.setObjectInner(string, reader);
    }

    @Override
    public void setDate(String string, Date date) {
        this.setObjectInner(string, date);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) {
        this.setObjectInner((Object)string, (Object)date, calendar);
    }

    @Override
    public void setTime(String string, Time time) {
        this.setObjectInner(string, time);
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) {
        this.setObjectInner((Object)string, (Object)time, calendar);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) {
        this.setObjectInner((Object)string, (Object)timestamp, calendar);
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) {
        this.setObjectInner(n2, sQLXML);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) {
        this.setObjectInner(string, sQLXML);
    }

    @Override
    public void setRowId(int n2, RowId rowId) {
        this.setObjectInner(n2, rowId);
    }

    @Override
    public void setRowId(String string, RowId rowId) {
        this.setObjectInner(string, rowId);
    }

    @Override
    public void setNString(int n2, String string) {
        this.setString(n2, string);
    }

    @Override
    public void setNString(String string, String string2) {
        this.setString(string, string2);
    }

    public void setCharacterStream(int n2, Reader reader, long l2) {
        this.setObjectInner((Object)n2, (Object)reader, l2);
    }

    public void setCharacterStream(String string, Reader reader, long l2) {
        this.setObjectInner((Object)string, (Object)reader, l2);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) {
        this.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) {
        this.setCharacterStream(string, reader, l2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) {
        this.setCharacterStream(string, reader);
    }

    @Override
    public void setNClob(String string, NClob nClob) {
        this.setClob(string, (Clob)nClob);
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) {
        this.setClob(string, reader, l2);
    }

    @Override
    public void setNClob(String string, Reader reader) {
        this.setClob(string, reader);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) {
        this.setClob(n2, reader, l2);
    }

    @Override
    public void setNClob(int n2, NClob nClob) {
        this.setClob(n2, (Clob)nClob);
    }

    @Override
    public void setNClob(int n2, Reader reader) {
        this.setClob(n2, reader);
    }

    @Override
    public void setURL(int n2, URL uRL) {
        this.setObjectInner(n2, uRL);
    }

    @Override
    public RowSet createShared() {
        DmdbRowSet dmdbRowSet = new DmdbRowSet();
        this.rowsetShared(dmdbRowSet);
        return dmdbRowSet;
    }

    @Override
    public CachedRowSet createCopy() {
        DmdbRowSet dmdbRowSet = new DmdbRowSet();
        this.rowsetCopy(dmdbRowSet);
        return dmdbRowSet;
    }

    @Override
    public CachedRowSet createCopySchema() {
        DmdbRowSet dmdbRowSet = (DmdbRowSet)this.createCopy();
        dmdbRowSet.m_rows = null;
        dmdbRowSet.m_currentRow = 0;
        dmdbRowSet.m_rowCount = 0;
        return dmdbRowSet;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() {
        DmdbRowSet dmdbRowSet = (DmdbRowSet)this.createCopy();
        dmdbRowSet.m_listeners = new Vector();
        dmdbRowSet.unsetMatchColumn(dmdbRowSet.getMatchColumnIndexes());
        dmdbRowSet.unsetMatchColumn(dmdbRowSet.getMatchColumnNames());
        return dmdbRowSet;
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) {
        if (n2 < 0 || n2 > this.m_rowCount) {
            DBError.ECJDBC_CRS_INVALID_ROW_PARAM.throwException(new String[0]);
        }
        if (this.m_rowCount % n2 == 0) {
            rowSetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }
}

