/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.lifecycle.internal.statistics;

import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.lite.lifecycle.api.JobStatisticsAPI;
import com.dangdang.ddframe.job.lite.lifecycle.domain.JobBriefInfo;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class JobStatisticsAPIImpl
implements JobStatisticsAPI {
    private final CoordinatorRegistryCenter regCenter;

    @Override
    public int getJobsTotalCount() {
        return this.regCenter.getChildrenKeys("/").size();
    }

    @Override
    public Collection<JobBriefInfo> getAllJobsBriefInfo() {
        List jobNames = this.regCenter.getChildrenKeys("/");
        ArrayList<JobBriefInfo> result = new ArrayList<JobBriefInfo>(jobNames.size());
        for (String each : jobNames) {
            JobBriefInfo jobBriefInfo = this.getJobBriefInfo(each);
            if (null == jobBriefInfo) continue;
            result.add(jobBriefInfo);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public JobBriefInfo getJobBriefInfo(String jobName) {
        JobNodePath jobNodePath = new JobNodePath(jobName);
        JobBriefInfo result = new JobBriefInfo();
        result.setJobName(jobName);
        String liteJobConfigJson = this.regCenter.get(jobNodePath.getConfigNodePath());
        if (null == liteJobConfigJson) {
            return null;
        }
        LiteJobConfiguration liteJobConfig = LiteJobConfigurationGsonFactory.fromJson((String)liteJobConfigJson);
        result.setDescription(liteJobConfig.getTypeConfig().getCoreConfig().getDescription());
        result.setCron(liteJobConfig.getTypeConfig().getCoreConfig().getCron());
        result.setInstanceCount(this.getJobInstanceCount(jobName));
        result.setShardingTotalCount(liteJobConfig.getTypeConfig().getCoreConfig().getShardingTotalCount());
        result.setStatus(this.getJobStatus(jobName));
        return result;
    }

    private JobBriefInfo.JobStatus getJobStatus(String jobName) {
        JobNodePath jobNodePath = new JobNodePath(jobName);
        List instances = this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath());
        if (instances.isEmpty()) {
            return JobBriefInfo.JobStatus.CRASHED;
        }
        if (this.isAllDisabled(jobNodePath)) {
            return JobBriefInfo.JobStatus.DISABLED;
        }
        if (this.isHasShardingFlag(jobNodePath, instances)) {
            return JobBriefInfo.JobStatus.SHARDING_FLAG;
        }
        return JobBriefInfo.JobStatus.OK;
    }

    private boolean isAllDisabled(JobNodePath jobNodePath) {
        List serversPath = this.regCenter.getChildrenKeys(jobNodePath.getServerNodePath());
        int disabledServerCount = 0;
        for (String each : serversPath) {
            if (!JobBriefInfo.JobStatus.DISABLED.name().equals(this.regCenter.get(jobNodePath.getServerNodePath(each)))) continue;
            ++disabledServerCount;
        }
        return disabledServerCount == serversPath.size();
    }

    private boolean isHasShardingFlag(JobNodePath jobNodePath, List<String> instances) {
        HashSet<String> shardingInstances = new HashSet<String>();
        for (String each : this.regCenter.getChildrenKeys(jobNodePath.getShardingNodePath())) {
            String instanceId = this.regCenter.get(jobNodePath.getShardingNodePath(each, "instance"));
            if (null == instanceId || instanceId.isEmpty()) continue;
            shardingInstances.add(instanceId);
        }
        return !instances.containsAll(shardingInstances) || shardingInstances.isEmpty();
    }

    private int getJobInstanceCount(String jobName) {
        return this.regCenter.getChildrenKeys(new JobNodePath(jobName).getInstancesNodePath()).size();
    }

    @Override
    public Collection<JobBriefInfo> getJobsBriefInfo(String ip) {
        List jobNames = this.regCenter.getChildrenKeys("/");
        ArrayList<JobBriefInfo> result = new ArrayList<JobBriefInfo>(jobNames.size());
        for (String each : jobNames) {
            JobBriefInfo jobBriefInfo = this.getJobBriefInfoByJobNameAndIp(each, ip);
            if (null == jobBriefInfo) continue;
            result.add(jobBriefInfo);
        }
        Collections.sort(result);
        return result;
    }

    private JobBriefInfo getJobBriefInfoByJobNameAndIp(String jobName, String ip) {
        if (!this.regCenter.isExisted(new JobNodePath(jobName).getServerNodePath(ip))) {
            return null;
        }
        JobBriefInfo result = new JobBriefInfo();
        result.setJobName(jobName);
        result.setStatus(this.getJobStatusByJobNameAndIp(jobName, ip));
        result.setInstanceCount(this.getJobInstanceCountByJobNameAndIp(jobName, ip));
        return result;
    }

    private JobBriefInfo.JobStatus getJobStatusByJobNameAndIp(String jobName, String ip) {
        JobNodePath jobNodePath = new JobNodePath(jobName);
        String status = this.regCenter.get(jobNodePath.getServerNodePath(ip));
        if ("DISABLED".equalsIgnoreCase(status)) {
            return JobBriefInfo.JobStatus.DISABLED;
        }
        return JobBriefInfo.JobStatus.OK;
    }

    private int getJobInstanceCountByJobNameAndIp(String jobName, String ip) {
        int instanceCount = 0;
        JobNodePath jobNodePath = new JobNodePath(jobName);
        List instances = this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath());
        for (String each : instances) {
            if (!ip.equals(each.split("@-@")[0])) continue;
            ++instanceCount;
        }
        return instanceCount;
    }

    @ConstructorProperties(value={"regCenter"})
    public JobStatisticsAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }
}

