/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.ws;

import com.dingtalk.open.app.stream.network.api.Context;
import com.dingtalk.open.app.stream.network.api.ServiceException;
import com.dingtalk.open.app.stream.network.api.logger.InternalLogger;
import com.dingtalk.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.dingtalk.open.app.stream.protocol.ProtocolRequestFacade;
import com.dingtalk.open.app.stream.protocol.ProtocolResponse;
import shade.com.alibaba.fastjson2.JSON;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.util.concurrent.Future;
import shade.io.netty.util.concurrent.GenericFutureListener;

public class WebSocketContext
implements Context {
    private static InternalLogger LOGGER = InternalLoggerFactory.getLogger(WebSocketContext.class);
    private final ChannelHandlerContext context;
    private final ProtocolRequestFacade request;
    private final String connectionId;

    public WebSocketContext(String connectionId, ProtocolRequestFacade request, ChannelHandlerContext context) {
        this.context = context;
        this.connectionId = connectionId;
        this.request = request;
    }

    @Override
    public void replay(Object payload) {
        ProtocolResponse response = ProtocolResponse.new200Response(this.request);
        response.setData(JSON.toJSONString(payload, JSONWriter.Feature.WriteMapNullValue));
        this.context.writeAndFlush(response).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                LOGGER.error("[DingTalk] websocket connection reply response failed, connectionId={}, messageId={}", this.connectionId, this.request.getMessageId(), future.cause());
                this.context.close();
            }
        }));
    }

    @Override
    public void exception(Throwable t) {
        ProtocolResponse response = t instanceof ServiceException ? ProtocolResponse.newErrorResponse(this.request, ((ServiceException)t).getCode(), t.getMessage()) : ProtocolResponse.new500Response(this.request);
        this.context.writeAndFlush(response).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                LOGGER.error("[DingTalk] websocket connection reply response failed, connectionId={}, messageId={}", this.connectionId, this.request.getMessageId(), future.cause());
                this.context.close();
            }
        }));
    }

    @Override
    public String connectionId() {
        return this.connectionId;
    }

    @Override
    public ProtocolRequestFacade getRequest() {
        return this.request;
    }
}

