/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.Cancelable;
import com.ejlchina.okhttps.FilePara;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.OkHttpsException;
import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.Process;
import com.ejlchina.okhttps.TaskExecutor;
import com.ejlchina.okhttps.internal.AbstractHttpClient;
import com.ejlchina.okhttps.internal.FixedRequestBody;
import com.ejlchina.okhttps.internal.ProcessRequestBody;
import com.ejlchina.okhttps.internal.RealHttpResult;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;

public abstract class HttpTask<C extends HttpTask<?>>
implements Cancelable {
    private static final String PATH_PARAM_REGEX = "[A-Za-z0-9_\\-/]*\\{[A-Za-z0-9_\\-]+\\}[A-Za-z0-9_\\-/]*";
    private static final String DOT = ".";
    protected AbstractHttpClient httpClient;
    protected boolean nothrow;
    protected boolean nextOnIO = false;
    private final String urlPath;
    private String tag;
    private Map<String, String> headers;
    private Map<String, Object> pathParams;
    private Map<String, Object> urlParams;
    private Map<String, Object> bodyParams;
    private Map<String, FilePara> files;
    private Object requestBody;
    private String bodyType;
    private OnCallback<Process> onProcess;
    private boolean processOnIO;
    private long stepBytes = 0L;
    private double stepRate = -1.0;
    private Object object;
    private AbstractHttpClient.TagTask tagTask;
    private Cancelable canceler;
    private Charset charset;
    protected boolean skipPreproc = false;
    protected boolean skipSerialPreproc = false;

    public HttpTask(AbstractHttpClient httpClient, String urlPath) {
        this.httpClient = httpClient;
        this.charset = httpClient.charset();
        this.bodyType = httpClient.bodyType();
        this.urlPath = urlPath;
    }

    public String getUrl() {
        return this.urlPath;
    }

    public boolean isWebsocket() {
        return false;
    }

    public boolean isSyncHttp() {
        return false;
    }

    public boolean isAsyncHttp() {
        return false;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public boolean isTagged(String tag) {
        String theTag = this.tag;
        if (theTag != null && tag != null) {
            return theTag.equals(tag) || theTag.startsWith(tag + DOT) || theTag.endsWith(DOT + tag) || theTag.contains(DOT + tag + DOT);
        }
        return false;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getPathParas() {
        return this.pathParams;
    }

    public Map<String, Object> getUrlParas() {
        return this.urlParams;
    }

    public Map<String, Object> getBodyParas() {
        return this.bodyParams;
    }

    public Map<String, FilePara> getFileParas() {
        return this.files;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Object getBound() {
        return this.object;
    }

    public C nothrow() {
        this.nothrow = true;
        return (C)this;
    }

    public C skipPreproc() {
        this.skipPreproc = true;
        return (C)this;
    }

    public C skipSerialPreproc() {
        this.skipSerialPreproc = true;
        return (C)this;
    }

    public C tag(String tag) {
        if (tag != null) {
            this.tag = this.tag != null ? this.tag + DOT + tag : tag;
            this.updateTagTask();
        }
        return (C)this;
    }

    public C charset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
        return (C)this;
    }

    public C bodyType(String type) {
        if (type != null) {
            this.bodyType = type.toLowerCase();
        }
        return (C)this;
    }

    public C nextOnIO() {
        this.nextOnIO = true;
        return (C)this;
    }

    public C bind(Object object) {
        this.object = object;
        return (C)this;
    }

    public C addHeader(String name, String value) {
        if (name != null && value != null) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value);
        }
        return (C)this;
    }

    public C addHeader(Map<String, String> headers) {
        if (headers != null) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.putAll(headers);
        }
        return (C)this;
    }

    public C setRange(long rangeStart) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-");
    }

    public C setRange(long rangeStart, long rangeEnd) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-" + rangeEnd);
    }

    public C setOnProcess(OnCallback<Process> onProcess) {
        this.onProcess = onProcess;
        this.processOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return (C)this;
    }

    public C stepBytes(long stepBytes) {
        this.stepBytes = stepBytes;
        return (C)this;
    }

    public C stepRate(double stepRate) {
        this.stepRate = stepRate;
        return (C)this;
    }

    public C addPathPara(String name, Object value) {
        if (name != null && value != null) {
            if (this.pathParams == null) {
                this.pathParams = new HashMap<String, Object>();
            }
            this.pathParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addPathPara(Map<String, ?> params) {
        if (this.pathParams == null) {
            this.pathParams = new HashMap<String, Object>();
        }
        if (params != null) {
            this.pathParams.putAll(params);
        }
        return (C)this;
    }

    public C addUrlPara(String name, Object value) {
        if (name != null && value != null) {
            if (this.urlParams == null) {
                this.urlParams = new HashMap<String, Object>();
            }
            this.urlParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addUrlPara(Map<String, ?> params) {
        if (this.urlParams == null) {
            this.urlParams = new HashMap<String, Object>();
        }
        if (params != null) {
            this.urlParams.putAll(params);
        }
        return (C)this;
    }

    public C addBodyPara(String name, Object value) {
        if (name != null && value != null) {
            if (this.bodyParams == null) {
                this.bodyParams = new HashMap<String, Object>();
            }
            this.bodyParams.put(name, value);
        }
        return (C)this;
    }

    public C addBodyPara(Map<String, ?> params) {
        if (this.bodyParams == null) {
            this.bodyParams = new HashMap<String, Object>();
        }
        if (params != null) {
            this.bodyParams.putAll(params);
        }
        return (C)this;
    }

    public C setBodyPara(Object body) {
        this.requestBody = body;
        return (C)this;
    }

    public C addFilePara(String name, String filePath) {
        return this.addFilePara(name, new File(filePath));
    }

    public C addFilePara(String name, String type, String filePath) {
        return this.addFilePara(name, type, new File(filePath));
    }

    public C addFilePara(String name, File file) {
        if (file != null && file.exists()) {
            String fileName = file.getName();
            String type = fileName.substring(fileName.lastIndexOf(DOT) + 1);
            return this.addFilePara(name, type, file);
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, File file) {
        if (name != null && file != null && file.exists()) {
            if (this.files == null) {
                this.files = new HashMap<String, FilePara>();
            }
            this.files.put(name, new FilePara(type, file.getName(), file));
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, byte[] content) {
        return this.addFilePara(name, type, name + DOT + type, content);
    }

    public C addFilePara(String name, String type, String fileName, byte[] content) {
        if (name != null && content != null) {
            if (this.files == null) {
                this.files = new HashMap<String, FilePara>();
            }
            this.files.put(name, new FilePara(type, fileName, content));
        }
        return (C)this;
    }

    @Override
    public boolean cancel() {
        if (this.canceler != null) {
            return this.canceler.cancel();
        }
        return false;
    }

    protected void registeTagTask(Cancelable canceler) {
        if (this.tag != null && this.tagTask == null) {
            this.tagTask = this.httpClient.addTagTask(this.tag, canceler, this);
        }
        this.canceler = canceler;
    }

    private void updateTagTask() {
        if (this.tagTask != null) {
            this.tagTask.setTag(this.tag);
        } else if (this.canceler != null) {
            this.registeTagTask(this.canceler);
        }
    }

    protected void removeTagTask() {
        if (this.tag != null) {
            this.httpClient.removeTagTask(this);
        }
    }

    protected Call prepareCall(String method) {
        Request request = this.prepareRequest(method.toUpperCase());
        return this.httpClient.request(request);
    }

    protected Request prepareRequest(String method) {
        boolean bodyCanUsed = HttpMethod.permitsRequestBody((String)method);
        this.assertNotConflict(!bodyCanUsed);
        Request.Builder builder = new Request.Builder().url(this.buildUrlPath());
        this.buildHeaders(builder);
        if (bodyCanUsed) {
            RequestBody reqBody = this.buildRequestBody();
            if (this.onProcess != null) {
                long contentLength = this.contentLength(reqBody);
                if (this.stepRate > 0.0 && this.stepRate <= 1.0) {
                    this.stepBytes = (long)((double)contentLength * this.stepRate);
                }
                if (this.stepBytes <= 0L) {
                    this.stepBytes = 8192L;
                }
                reqBody = new ProcessRequestBody(reqBody, this.onProcess, this.httpClient.executor().getExecutor(this.processOnIO), contentLength, this.stepBytes);
            } else {
                reqBody = new FixedRequestBody(reqBody);
            }
            builder.method(method, reqBody);
        } else {
            builder.method(method, null);
        }
        if (this.tag != null) {
            builder.tag(String.class, (Object)this.tag);
        }
        return builder.build();
    }

    private long contentLength(RequestBody reqBody) {
        try {
            return reqBody.contentLength();
        }
        catch (IOException e) {
            throw new OkHttpsException("\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u4f53\u957f\u5ea6", e);
        }
    }

    private void buildHeaders(Request.Builder builder) {
        if (this.headers != null) {
            for (String name : this.headers.keySet()) {
                String value = this.headers.get(name);
                if (value == null) continue;
                builder.addHeader(name, value);
            }
        }
    }

    protected HttpResult.State toState(IOException e) {
        if (e instanceof SocketTimeoutException) {
            return HttpResult.State.TIMEOUT;
        }
        if (e instanceof UnknownHostException || e instanceof ConnectException) {
            return HttpResult.State.NETWORK_ERROR;
        }
        String msg = e.getMessage();
        if (msg != null && ("Canceled".equals(msg) || e instanceof SocketException && (msg.startsWith("Socket operation on nonsocket") || "Socket closed".equals(msg)))) {
            return HttpResult.State.CANCELED;
        }
        return HttpResult.State.EXCEPTION;
    }

    private RequestBody buildRequestBody() {
        if (this.bodyParams != null && "form-data".equalsIgnoreCase(this.bodyType) || this.files != null) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (this.bodyParams != null) {
                this.bodyParams.forEach((key, value) -> {
                    if (value == null) {
                        return;
                    }
                    byte[] content = value.toString().getBytes(this.charset);
                    RequestBody body = RequestBody.create(null, (byte[])content);
                    builder.addPart(MultipartBody.Part.createFormData((String)key, null, (RequestBody)body));
                });
            }
            if (this.files != null) {
                for (String name : this.files.keySet()) {
                    FilePara file = this.files.get(name);
                    MediaType type = this.httpClient.mediaType(file.type);
                    RequestBody bodyPart = file.file != null ? RequestBody.create((MediaType)type, (File)file.file) : RequestBody.create((MediaType)type, (byte[])file.content);
                    builder.addFormDataPart(name, file.fileName, bodyPart);
                }
            }
            return builder.build();
        }
        if (this.requestBody != null) {
            return this.toRequestBody(this.requestBody);
        }
        if (this.bodyParams == null) {
            return this.emptyRequestBody();
        }
        if ("form".equalsIgnoreCase(this.bodyType)) {
            FormBody.Builder builder = new FormBody.Builder(this.charset);
            this.bodyParams.forEach((key, value) -> {
                if (value == null) {
                    return;
                }
                builder.add(key, value.toString());
            });
            return builder.build();
        }
        return this.toRequestBody(this.bodyParams);
    }

    private RequestBody emptyRequestBody() {
        if ("form-data".equalsIgnoreCase(this.bodyType)) {
            return new MultipartBody.Builder().setType(MultipartBody.FORM).build();
        }
        return RequestBody.create((MediaType)this.mediaType(), (byte[])new byte[0]);
    }

    private MediaType mediaType() {
        return this.httpClient.executor().doMsgConvert(this.bodyType, null).mediaType(this.charset);
    }

    private RequestBody toRequestBody(Object object) {
        if (object instanceof byte[] || object instanceof String) {
            byte[] body = object instanceof byte[] ? (byte[])object : ((String)object).getBytes(this.charset);
            return RequestBody.create((MediaType)this.mediaType(), (byte[])body);
        }
        TaskExecutor.Data<byte[]> data = this.httpClient.executor().doMsgConvert(this.bodyType, c -> c.serialize(object, this.charset));
        return RequestBody.create((MediaType)data.mediaType(this.charset), (byte[])((byte[])data.data));
    }

    private String buildUrlPath() {
        String url = this.urlPath;
        if (url == null || url.trim().isEmpty()) {
            throw new OkHttpsException("url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.pathParams != null) {
            for (String name : this.pathParams.keySet()) {
                String target = "{" + name + "}";
                if (url.contains(target)) {
                    Object value = this.pathParams.get(name);
                    url = url.replace(target, value != null ? value.toString() : "");
                    continue;
                }
                throw new OkHttpsException("pathPara [ " + name + " ] \u4e0d\u5b58\u5728\u4e8e url [ " + this.urlPath + " ]");
            }
        }
        if (url.matches(PATH_PARAM_REGEX)) {
            throw new OkHttpsException("url \u91cc\u6709 pathPara \u6ca1\u6709\u8bbe\u7f6e\uff0c\u4f60\u5fc5\u987b\u5148\u8c03\u7528 addPathPara \u4e3a\u5176\u8bbe\u7f6e\uff01");
        }
        if (this.urlParams != null) {
            url = this.buildUrl(url.trim());
        }
        return url;
    }

    private String buildUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        if (url.contains("?")) {
            if (!url.endsWith("?")) {
                if (url.lastIndexOf("=") < url.lastIndexOf("?") + 2) {
                    throw new OkHttpsException("url \u683c\u5f0f\u9519\u8bef\uff0c'?' \u540e\u6ca1\u6709\u53d1\u73b0 '='");
                }
                if (!url.endsWith("&")) {
                    sb.append('&');
                }
            }
        } else {
            sb.append('?');
        }
        for (String name : this.urlParams.keySet()) {
            sb.append(name).append('=').append(this.urlParams.get(name)).append('&');
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    protected void assertNotConflict(boolean bodyCantUsed) {
        if (bodyCantUsed) {
            if (this.requestBody != null) {
                throw new OkHttpsException("GET | HEAD \u8bf7\u6c42 \u4e0d\u80fd\u8c03\u7528 setBodyPara \u65b9\u6cd5\uff01");
            }
            if (HttpTask.isNotEmpty(this.bodyParams)) {
                throw new OkHttpsException("GET | HEAD \u8bf7\u6c42 \u4e0d\u80fd\u8c03\u7528 addBodyPara \u65b9\u6cd5\uff01");
            }
            if (HttpTask.isNotEmpty(this.files)) {
                throw new OkHttpsException("GET | HEAD \u8bf7\u6c42 \u4e0d\u80fd\u8c03\u7528 addFilePara \u65b9\u6cd5\uff01");
            }
        }
        if (this.requestBody != null) {
            if (HttpTask.isNotEmpty(this.bodyParams)) {
                throw new OkHttpsException("\u65b9\u6cd5 addBodyPara \u4e0e setBodyPara \u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\uff01");
            }
            if (HttpTask.isNotEmpty(this.files)) {
                throw new OkHttpsException("\u65b9\u6cd5 addFilePara \u4e0e setBodyPara \u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\uff01");
            }
        }
    }

    private static boolean isNotEmpty(Map<String, ?> map) {
        return map != null && !map.isEmpty();
    }

    protected boolean timeoutAwait(CountDownLatch latch) {
        try {
            return latch.await(this.httpClient.preprocTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new OkHttpsException("\u6267\u884c\u8d85\u65f6: " + this.urlPath, e);
        }
    }

    protected HttpResult timeoutResult() {
        if (this.nothrow) {
            return new RealHttpResult(this, HttpResult.State.TIMEOUT);
        }
        throw new OkHttpsException(HttpResult.State.TIMEOUT, "\u6267\u884c\u8d85\u65f6: " + this.urlPath);
    }

    public Charset charset(Response response) {
        ResponseBody b = response.body();
        MediaType type = b != null ? b.contentType() : null;
        return type != null ? type.charset(this.charset) : this.charset;
    }

    protected void execute(Runnable command, boolean onIo) {
        this.httpClient.executor().execute(command, onIo);
    }
}

