/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyCoupon;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.converter.WxPayOrderNotifyResultConverter;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.w3c.dom.Document;

@XStreamAlias(value="xml")
public class WxWithholdNotifyResult
extends BaseWxPayResult {
    private static final long serialVersionUID = 1L;
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="openid")
    private String openId;
    @XStreamAlias(value="sub_openid")
    private String subOpenId;
    @XStreamAlias(value="is_subscribe")
    private String isSubscribe;
    @XStreamAlias(value="sub_is_subscribe")
    private String subIsSubscribe;
    @XStreamAlias(value="bank_type")
    private String bankType;
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @XStreamAlias(value="cash_fee")
    private Integer cashFee;
    @XStreamAlias(value="cash_fee_type")
    private String cashFeeType;
    @XStreamAlias(value="trade_state")
    private String tradeState;
    @XStreamAlias(value="coupon_fee")
    private Integer couponFee;
    @XStreamAlias(value="coupon_count")
    private Integer couponCount;
    private List<WxPayOrderNotifyCoupon> couponList;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="attach")
    private String attach;
    @XStreamAlias(value="time_end")
    private String timeEnd;
    @XStreamAlias(value="contract_id")
    private String contractId;

    @Override
    public void checkResult(WxPayService wxPayService, String signType, boolean checkSuccess) throws WxPayException {
        if ("SUCCESS".equals(this.getReturnCode()) && this.getSign() == null) {
            throw new WxPayException("\u4f2a\u9020\u7684\u901a\u77e5\uff01");
        }
        super.checkResult(wxPayService, signType, checkSuccess);
    }

    public static WxWithholdNotifyResult fromXML(String xmlString) {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxWithholdNotifyResult.class);
        xstream.registerConverter((Converter)new WxPayOrderNotifyResultConverter(xstream.getMapper(), xstream.getReflectionProvider()));
        WxWithholdNotifyResult result = (WxWithholdNotifyResult)xstream.fromXML(xmlString);
        result.setXmlString(xmlString);
        return result;
    }

    @Override
    public Map<String, String> toMap() {
        Map<String, String> resultMap = SignUtils.xmlBean2Map(this);
        if (this.getCouponCount() != null && this.getCouponCount() > 0) {
            for (int i = 0; i < this.getCouponCount(); ++i) {
                WxPayOrderNotifyCoupon coupon = this.couponList.get(i);
                resultMap.putAll(coupon.toMap(i));
            }
        }
        return resultMap;
    }

    @Override
    protected void loadXml(Document d) {
        this.deviceInfo = WxWithholdNotifyResult.readXmlString(d, "device_info");
        this.openId = WxWithholdNotifyResult.readXmlString(d, "openid");
        this.isSubscribe = WxWithholdNotifyResult.readXmlString(d, "is_subscribe");
        this.subIsSubscribe = WxWithholdNotifyResult.readXmlString(d, "sub_is_subscribe");
        this.subOpenId = WxWithholdNotifyResult.readXmlString(d, "sub_openid");
        this.bankType = WxWithholdNotifyResult.readXmlString(d, "bank_type");
        this.totalFee = WxWithholdNotifyResult.readXmlInteger(d, "total_fee");
        this.feeType = WxWithholdNotifyResult.readXmlString(d, "fee_type");
        this.cashFee = WxWithholdNotifyResult.readXmlInteger(d, "cash_fee");
        this.cashFeeType = WxWithholdNotifyResult.readXmlString(d, "cash_fee_type");
        this.couponFee = WxWithholdNotifyResult.readXmlInteger(d, "coupon_fee");
        this.couponCount = WxWithholdNotifyResult.readXmlInteger(d, "coupon_count");
        this.transactionId = WxWithholdNotifyResult.readXmlString(d, "transaction_id");
        this.outTradeNo = WxWithholdNotifyResult.readXmlString(d, "out_trade_no");
        this.attach = WxWithholdNotifyResult.readXmlString(d, "attach");
        this.timeEnd = WxWithholdNotifyResult.readXmlString(d, "time_end");
        this.tradeState = WxWithholdNotifyResult.readXmlString(d, "trade_state");
        this.contractId = WxWithholdNotifyResult.readXmlString(d, "contract_id");
        this.composeCoupons();
    }

    protected void composeCoupons() {
        if (this.couponCount == null || this.couponCount == 0) {
            return;
        }
        this.couponList = new ArrayList<WxPayOrderNotifyCoupon>(this.couponCount);
        for (int i = 0; i < this.couponCount; ++i) {
            WxPayOrderNotifyCoupon coupon = new WxPayOrderNotifyCoupon();
            coupon.setCouponId(this.getXmlValue("xml/coupon_id_" + i));
            coupon.setCouponType(this.getXmlValue("xml/coupon_type_" + i));
            coupon.setCouponFee(this.getXmlValueAsInt("xml/coupon_fee_" + i));
            this.couponList.add(coupon);
        }
    }

    @Override
    public String toString() {
        return WxGsonBuilder.create().toJson((Object)this);
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getSubOpenId() {
        return this.subOpenId;
    }

    public String getIsSubscribe() {
        return this.isSubscribe;
    }

    public String getSubIsSubscribe() {
        return this.subIsSubscribe;
    }

    public String getBankType() {
        return this.bankType;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public Integer getCashFee() {
        return this.cashFee;
    }

    public String getCashFeeType() {
        return this.cashFeeType;
    }

    public String getTradeState() {
        return this.tradeState;
    }

    public Integer getCouponFee() {
        return this.couponFee;
    }

    public Integer getCouponCount() {
        return this.couponCount;
    }

    public List<WxPayOrderNotifyCoupon> getCouponList() {
        return this.couponList;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getAttach() {
        return this.attach;
    }

    public String getTimeEnd() {
        return this.timeEnd;
    }

    public String getContractId() {
        return this.contractId;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setSubOpenId(String subOpenId) {
        this.subOpenId = subOpenId;
    }

    public void setIsSubscribe(String isSubscribe) {
        this.isSubscribe = isSubscribe;
    }

    public void setSubIsSubscribe(String subIsSubscribe) {
        this.subIsSubscribe = subIsSubscribe;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public void setCashFee(Integer cashFee) {
        this.cashFee = cashFee;
    }

    public void setCashFeeType(String cashFeeType) {
        this.cashFeeType = cashFeeType;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public void setCouponFee(Integer couponFee) {
        this.couponFee = couponFee;
    }

    public void setCouponCount(Integer couponCount) {
        this.couponCount = couponCount;
    }

    public void setCouponList(List<WxPayOrderNotifyCoupon> couponList) {
        this.couponList = couponList;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setTimeEnd(String timeEnd) {
        this.timeEnd = timeEnd;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxWithholdNotifyResult)) {
            return false;
        }
        WxWithholdNotifyResult other = (WxWithholdNotifyResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        Integer this$cashFee = this.getCashFee();
        Integer other$cashFee = other.getCashFee();
        if (this$cashFee == null ? other$cashFee != null : !((Object)this$cashFee).equals(other$cashFee)) {
            return false;
        }
        Integer this$couponFee = this.getCouponFee();
        Integer other$couponFee = other.getCouponFee();
        if (this$couponFee == null ? other$couponFee != null : !((Object)this$couponFee).equals(other$couponFee)) {
            return false;
        }
        Integer this$couponCount = this.getCouponCount();
        Integer other$couponCount = other.getCouponCount();
        if (this$couponCount == null ? other$couponCount != null : !((Object)this$couponCount).equals(other$couponCount)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$openId = this.getOpenId();
        String other$openId = other.getOpenId();
        if (this$openId == null ? other$openId != null : !this$openId.equals(other$openId)) {
            return false;
        }
        String this$subOpenId = this.getSubOpenId();
        String other$subOpenId = other.getSubOpenId();
        if (this$subOpenId == null ? other$subOpenId != null : !this$subOpenId.equals(other$subOpenId)) {
            return false;
        }
        String this$isSubscribe = this.getIsSubscribe();
        String other$isSubscribe = other.getIsSubscribe();
        if (this$isSubscribe == null ? other$isSubscribe != null : !this$isSubscribe.equals(other$isSubscribe)) {
            return false;
        }
        String this$subIsSubscribe = this.getSubIsSubscribe();
        String other$subIsSubscribe = other.getSubIsSubscribe();
        if (this$subIsSubscribe == null ? other$subIsSubscribe != null : !this$subIsSubscribe.equals(other$subIsSubscribe)) {
            return false;
        }
        String this$bankType = this.getBankType();
        String other$bankType = other.getBankType();
        if (this$bankType == null ? other$bankType != null : !this$bankType.equals(other$bankType)) {
            return false;
        }
        String this$feeType = this.getFeeType();
        String other$feeType = other.getFeeType();
        if (this$feeType == null ? other$feeType != null : !this$feeType.equals(other$feeType)) {
            return false;
        }
        String this$cashFeeType = this.getCashFeeType();
        String other$cashFeeType = other.getCashFeeType();
        if (this$cashFeeType == null ? other$cashFeeType != null : !this$cashFeeType.equals(other$cashFeeType)) {
            return false;
        }
        String this$tradeState = this.getTradeState();
        String other$tradeState = other.getTradeState();
        if (this$tradeState == null ? other$tradeState != null : !this$tradeState.equals(other$tradeState)) {
            return false;
        }
        List<WxPayOrderNotifyCoupon> this$couponList = this.getCouponList();
        List<WxPayOrderNotifyCoupon> other$couponList = other.getCouponList();
        if (this$couponList == null ? other$couponList != null : !((Object)this$couponList).equals(other$couponList)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$attach = this.getAttach();
        String other$attach = other.getAttach();
        if (this$attach == null ? other$attach != null : !this$attach.equals(other$attach)) {
            return false;
        }
        String this$timeEnd = this.getTimeEnd();
        String other$timeEnd = other.getTimeEnd();
        if (this$timeEnd == null ? other$timeEnd != null : !this$timeEnd.equals(other$timeEnd)) {
            return false;
        }
        String this$contractId = this.getContractId();
        String other$contractId = other.getContractId();
        return !(this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxWithholdNotifyResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        Integer $cashFee = this.getCashFee();
        result = result * 59 + ($cashFee == null ? 43 : ((Object)$cashFee).hashCode());
        Integer $couponFee = this.getCouponFee();
        result = result * 59 + ($couponFee == null ? 43 : ((Object)$couponFee).hashCode());
        Integer $couponCount = this.getCouponCount();
        result = result * 59 + ($couponCount == null ? 43 : ((Object)$couponCount).hashCode());
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $openId = this.getOpenId();
        result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
        String $subOpenId = this.getSubOpenId();
        result = result * 59 + ($subOpenId == null ? 43 : $subOpenId.hashCode());
        String $isSubscribe = this.getIsSubscribe();
        result = result * 59 + ($isSubscribe == null ? 43 : $isSubscribe.hashCode());
        String $subIsSubscribe = this.getSubIsSubscribe();
        result = result * 59 + ($subIsSubscribe == null ? 43 : $subIsSubscribe.hashCode());
        String $bankType = this.getBankType();
        result = result * 59 + ($bankType == null ? 43 : $bankType.hashCode());
        String $feeType = this.getFeeType();
        result = result * 59 + ($feeType == null ? 43 : $feeType.hashCode());
        String $cashFeeType = this.getCashFeeType();
        result = result * 59 + ($cashFeeType == null ? 43 : $cashFeeType.hashCode());
        String $tradeState = this.getTradeState();
        result = result * 59 + ($tradeState == null ? 43 : $tradeState.hashCode());
        List<WxPayOrderNotifyCoupon> $couponList = this.getCouponList();
        result = result * 59 + ($couponList == null ? 43 : ((Object)$couponList).hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $attach = this.getAttach();
        result = result * 59 + ($attach == null ? 43 : $attach.hashCode());
        String $timeEnd = this.getTimeEnd();
        result = result * 59 + ($timeEnd == null ? 43 : $timeEnd.hashCode());
        String $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
        return result;
    }
}

