/*
 * Decompiled with CFR 0.152.
 */
package com.dengxq.lnglat2Geo;

import com.dengxq.lnglat2Geo.build.AdminDataProvider$AdminLoader$;
import com.dengxq.lnglat2Geo.build.CityAreaDataProvider$;
import com.dengxq.lnglat2Geo.build.CityLevelDataProvider$;
import com.dengxq.lnglat2Geo.entity.Admin;
import com.dengxq.lnglat2Geo.entity.Admin$;
import com.dengxq.lnglat2Geo.entity.AdminNode;
import com.dengxq.lnglat2Geo.entity.BusinessArea;
import com.dengxq.lnglat2Geo.entity.BusinessAreaData;
import com.dengxq.lnglat2Geo.entity.BusinessAreaInfo;
import com.dengxq.lnglat2Geo.entity.CoordinateSystem$;
import com.dengxq.lnglat2Geo.entity.DistrictLevel$;
import com.dengxq.lnglat2Geo.entity.Location;
import com.dengxq.lnglat2Geo.utils.GeoUtils$;
import com.dengxq.lnglat2Geo.utils.LineUtils$;
import com.dengxq.lnglat2Geo.utils.S2Utils$;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import org.apache.commons.lang3.StringUtils;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

public final class GeoTransImpl$ {
    public static final GeoTransImpl$ MODULE$;
    private final int min_level;
    private Map<String, String> cityLevelData;
    private Map<Object, BusinessAreaData[]> cityBusinessArea;
    private Map<Object, AdminNode> adminData;
    private Map<Object, AdminNode> streetData;
    private Map<String, String> countryCode;
    private Map<Object, List<Tuple3<Object, Object, Object>>> boundaryData;
    private Map<Object, List<Object>> boundaryIndex;
    private Map<Object, Object> boundaryAdminCell;
    private final Map<String, String> cityNameMap;
    private final Map<String, String> districtNameMap;
    private volatile byte bitmap$0;

    static {
        new GeoTransImpl$();
    }

    private Map cityLevelData$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.cityLevelData = CityLevelDataProvider$.MODULE$.csv2Map();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.cityLevelData;
        }
    }

    private Map cityBusinessArea$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cityBusinessArea = CityAreaDataProvider$.MODULE$.loadBusinessAreaData();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.cityBusinessArea;
        }
    }

    private Map adminData$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.adminData = AdminDataProvider$AdminLoader$.MODULE$.loadAdminData();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.adminData;
        }
    }

    private Map streetData$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.streetData = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])AdminDataProvider$AdminLoader$.MODULE$.loadStreetData()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, AdminNode> apply(AdminNode s) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)s.id()), (Object)s);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.streetData;
        }
    }

    private Map countryCode$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.countryCode = AdminDataProvider$AdminLoader$.MODULE$.loadCountryCode();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.countryCode;
        }
    }

    private Map boundaryData$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.boundaryData = AdminDataProvider$AdminLoader$.MODULE$.loadBoundaryData();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.boundaryData;
        }
    }

    private Map boundaryIndex$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.boundaryIndex = (Map)((TraversableLike)this.boundaryData().keySet().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(long s) {
                        return new Tuple2.mcJJ.sp(new S2CellId(s).parent(12).id(), s);
                    }
                }, Set$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, Object> x$1) {
                        return x$1._1$mcJ$sp();
                    }
                }).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, List<Object>> apply(Tuple2<Object, Set<Tuple2<Object, Object>>> s) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)s._1$mcJ$sp()), (Object)((TraversableOnce)((SetLike)s._2()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Tuple2<Object, Object> x$2) {
                                return x$2._2$mcJ$sp();
                            }
                        }, Set$.MODULE$.canBuildFrom())).toList());
                    }
                }, Map$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            return this.boundaryIndex;
        }
    }

    private Map boundaryAdminCell$lzycompute() {
        GeoTransImpl$ geoTransImpl$ = this;
        synchronized (geoTransImpl$) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.boundaryAdminCell = AdminDataProvider$AdminLoader$.MODULE$.loadBoundaryCellData();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
            return this.boundaryAdminCell;
        }
    }

    public final int min_level() {
        return 12;
    }

    public Map<String, String> cityLevelData() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.cityLevelData$lzycompute() : this.cityLevelData;
    }

    public Map<Object, BusinessAreaData[]> cityBusinessArea() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cityBusinessArea$lzycompute() : this.cityBusinessArea;
    }

    public Map<Object, AdminNode> adminData() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.adminData$lzycompute() : this.adminData;
    }

    public Map<Object, AdminNode> streetData() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.streetData$lzycompute() : this.streetData;
    }

    public Map<String, String> countryCode() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.countryCode$lzycompute() : this.countryCode;
    }

    public Map<Object, List<Tuple3<Object, Object, Object>>> boundaryData() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.boundaryData$lzycompute() : this.boundaryData;
    }

    public Map<Object, List<Object>> boundaryIndex() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.boundaryIndex$lzycompute() : this.boundaryIndex;
    }

    public Map<Object, Object> boundaryAdminCell() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.boundaryAdminCell$lzycompute() : this.boundaryAdminCell;
    }

    public void init(boolean needBoundary, boolean needArea, boolean needStreet, boolean needCityLevel) {
        Map<Object, Object> map;
        this.adminData();
        if (needBoundary) {
            this.boundaryData();
            this.boundaryIndex();
            map = this.boundaryAdminCell();
        } else {
            map = BoxedUnit.UNIT;
        }
        Map<Object, AdminNode> map2 = needStreet ? this.streetData() : BoxedUnit.UNIT;
        Map<Object, BusinessAreaData[]> map3 = needArea ? this.cityBusinessArea() : BoxedUnit.UNIT;
        if (needCityLevel) {
            this.cityLevelData();
        }
    }

    public boolean init$default$1() {
        return true;
    }

    public boolean init$default$2() {
        return false;
    }

    public boolean init$default$3() {
        return true;
    }

    public boolean init$default$4() {
        return false;
    }

    public Admin determineAdmin(double lon, double lat, boolean needStreet, Enumeration.Value coordSys) {
        Admin admin;
        Tuple2<Object, Object> wgs84LonLat = GeoUtils$.MODULE$.toWGS84(lon, lat, coordSys);
        int code = this.determineAdminCode(wgs84LonLat._1$mcD$sp(), wgs84LonLat._2$mcD$sp(), this.determineAdminCode$default$3());
        if (code != -1) {
            AdminNode district = (AdminNode)this.adminData().get((Object)BoxesRunTime.boxToInteger((int)code)).orNull(Predef$.MODULE$.$conforms());
            Enumeration.Value value = district.level();
            Enumeration.Value value2 = DistrictLevel$.MODULE$.District();
            AdminNode city = !(value != null ? !value.equals(value2) : value2 != null) ? (AdminNode)this.adminData().get((Object)BoxesRunTime.boxToInteger((int)district.parentId())).orNull(Predef$.MODULE$.$conforms()) : district;
            Enumeration.Value value3 = city.level();
            Enumeration.Value value4 = DistrictLevel$.MODULE$.City();
            AdminNode province = !(value3 != null ? !value3.equals(value4) : value4 != null) ? (AdminNode)this.adminData().get((Object)BoxesRunTime.boxToInteger((int)city.parentId())).orNull(Predef$.MODULE$.$conforms()) : city;
            int streetCode = 0;
            String streetName = "";
            if (needStreet && district.children().nonEmpty()) {
                AdminNode street = (AdminNode)((Option)((TraversableOnce)district.children().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<AdminNode> apply(int s) {
                        return GeoTransImpl$.MODULE$.streetData().get((Object)BoxesRunTime.boxToInteger((int)s));
                    }
                }, List$.MODULE$.canBuildFrom())).minBy((Function1)new Serializable(wgs84LonLat){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 wgs84LonLat$1;

                    public final double apply(Option<AdminNode> s) {
                        return GeoUtils$.MODULE$.distance(((AdminNode)s.get()).center(), new Location(this.wgs84LonLat$1._1$mcD$sp(), this.wgs84LonLat$1._2$mcD$sp()));
                    }
                    {
                        this.wgs84LonLat$1 = wgs84LonLat$1;
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).get();
                streetCode = street.id();
                streetName = street.name();
            }
            admin = streetCode > 0 ? Admin$.MODULE$.createStreet(province.name(), city.name(), district.name(), streetName, province.id(), city.id(), district.id(), streetCode, district.center()) : Admin$.MODULE$.createDistrict(province.name(), city.name(), district.name(), province.id(), city.id(), district.id(), district.center());
        } else {
            admin = Admin$.MODULE$.createOversea();
        }
        return admin;
    }

    public boolean determineAdmin$default$3() {
        return false;
    }

    public Enumeration.Value determineAdmin$default$4() {
        return CoordinateSystem$.MODULE$.GCJ02();
    }

    public String getCityLevel(Admin admin) {
        return this.getCityLevel(((Object)BoxesRunTime.boxToInteger((int)admin.cityCode())).toString());
    }

    public String getCityLevel(String adcode_or_name) {
        return (String)this.cityLevelData().getOrElse((Object)adcode_or_name, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "\u672a\u77e5";
            }
        });
    }

    public AdminNode normalizeName(int adcode) {
        return (AdminNode)this.adminData().getOrElse((Object)BoxesRunTime.boxToInteger((int)adcode), (Function0)new Serializable(adcode){
            public static final long serialVersionUID = 0L;
            private final int adcode$1;

            public final AdminNode apply() {
                return (AdminNode)GeoTransImpl$.MODULE$.streetData().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.adcode$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            {
                this.adcode$1 = adcode$1;
            }
        });
    }

    public List<AdminNode> normalizeName(String name, Enumeration.Value level, boolean isFullMatch) {
        return ((TraversableOnce)((TraversableLike)this.adminData().values().filter((Function1)new Serializable(level){
            public static final long serialVersionUID = 0L;
            private final Enumeration.Value level$1;

            public final boolean apply(AdminNode x$3) {
                return x$3.level().equals((Object)this.level$1);
            }
            {
                this.level$1 = level$1;
            }
        })).filter((Function1)new Serializable(name, isFullMatch){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final boolean isFullMatch$2;

            public final boolean apply(AdminNode s) {
                return this.isFullMatch$2 ? s.name().equals(this.name$1) : s.shortName().contains(this.name$1) || s.name().contains(this.name$1);
            }
            {
                this.name$1 = name$1;
                this.isFullMatch$2 = isFullMatch$2;
            }
        })).toList();
    }

    private Map<String, String> cityNameMap() {
        return this.cityNameMap;
    }

    private Map<String, String> districtNameMap() {
        return this.districtNameMap;
    }

    public List<Admin> normalizeName(String provinceIn, String cityIn, String districtIn, String streetIn, boolean isFullMatch) {
        Iterable iterable;
        String province = provinceIn == null || provinceIn.equals("\u672a\u77e5") ? "" : provinceIn;
        String city = cityIn == null || cityIn.equals("\u672a\u77e5") ? "" : (String)this.cityNameMap().getOrElse((Object)cityIn, (Function0)new Serializable(cityIn){
            public static final long serialVersionUID = 0L;
            private final String cityIn$1;

            public final String apply() {
                return this.cityIn$1;
            }
            {
                this.cityIn$1 = cityIn$1;
            }
        });
        String district = districtIn == null || districtIn.equals("\u672a\u77e5") ? "" : (String)this.districtNameMap().getOrElse((Object)districtIn, (Function0)new Serializable(districtIn){
            public static final long serialVersionUID = 0L;
            private final String districtIn$1;

            public final String apply() {
                return this.districtIn$1;
            }
            {
                this.districtIn$1 = districtIn$1;
            }
        });
        String street = streetIn == null || streetIn.equals("\u672a\u77e5") ? "" : streetIn;
        Iterable provinceAd = (Iterable)((TraversableLike)this.adminData().values().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AdminNode s) {
                return s.level().equals((Object)DistrictLevel$.MODULE$.Province());
            }
        })).filter((Function1)new Serializable(isFullMatch, province){
            public static final long serialVersionUID = 0L;
            private final boolean isFullMatch$1;
            private final String province$1;

            public final boolean apply(AdminNode s) {
                return StringUtils.isEmpty((CharSequence)this.province$1) || s.name().equals(this.province$1) || !this.isFullMatch$1 && s.shortName().equals(this.province$1);
            }
            {
                this.isFullMatch$1 = isFullMatch$1;
                this.province$1 = province$1;
            }
        });
        if (StringUtils.isEmpty((CharSequence)city) && StringUtils.isEmpty((CharSequence)district) && StringUtils.isEmpty((CharSequence)street)) {
            iterable = provinceAd;
        } else {
            Iterable cityAd = (Iterable)((TraversableLike)provinceAd.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<AdminNode> apply(AdminNode s) {
                    return (List)s.children().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final AdminNode apply(int adCode) {
                            return (AdminNode)GeoTransImpl$.MODULE$.adminData().getOrElse((Object)BoxesRunTime.boxToInteger((int)adCode), (Function0)new Serializable(this, adCode){
                                public static final long serialVersionUID = 0L;
                                private final int adCode$1;

                                public final AdminNode apply() {
                                    return (AdminNode)GeoTransImpl$.MODULE$.streetData().get((Object)BoxesRunTime.boxToInteger((int)this.adCode$1)).orNull(Predef$.MODULE$.$conforms());
                                }
                                {
                                    this.adCode$1 = adCode$1;
                                }
                            });
                        }
                    }, List$.MODULE$.canBuildFrom());
                }
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(isFullMatch, city){
                public static final long serialVersionUID = 0L;
                private final boolean isFullMatch$1;
                private final String city$1;

                public final boolean apply(AdminNode s) {
                    return !s.level().equals((Object)DistrictLevel$.MODULE$.City()) || s.level().equals((Object)DistrictLevel$.MODULE$.City()) && (StringUtils.isEmpty((CharSequence)this.city$1) || s.name().equals(this.city$1) || !this.isFullMatch$1 && s.shortName().equals(this.city$1));
                }
                {
                    this.isFullMatch$1 = isFullMatch$1;
                    this.city$1 = city$1;
                }
            });
            if (cityAd.isEmpty()) {
                iterable = provinceAd;
            } else if (StringUtils.isEmpty((CharSequence)district) && StringUtils.isEmpty((CharSequence)street)) {
                iterable = (Iterable)cityAd.filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AdminNode s) {
                        return s.level().equals((Object)DistrictLevel$.MODULE$.Province()) || s.level().equals((Object)DistrictLevel$.MODULE$.City());
                    }
                });
            } else {
                Iterable districtAd = (Iterable)((TraversableLike)((TraversableLike)cityAd.flatMap((Function1)new Serializable(street){
                    public static final long serialVersionUID = 0L;
                    private final String street$1;

                    public final List<AdminNode> apply(AdminNode s) {
                        return s.level().equals((Object)DistrictLevel$.MODULE$.City()) && StringUtils.isEmpty((CharSequence)this.street$1) ? (List)s.children().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final AdminNode apply(int adCode) {
                                return (AdminNode)GeoTransImpl$.MODULE$.adminData().get((Object)BoxesRunTime.boxToInteger((int)adCode)).orNull(Predef$.MODULE$.$conforms());
                            }
                        }, List$.MODULE$.canBuildFrom()) : (s.level().equals((Object)DistrictLevel$.MODULE$.City()) ? (List)s.children().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final AdminNode apply(int adCode) {
                                return (AdminNode)GeoTransImpl$.MODULE$.adminData().getOrElse((Object)BoxesRunTime.boxToInteger((int)adCode), (Function0)new Serializable(this, adCode){
                                    public static final long serialVersionUID = 0L;
                                    private final int adCode$2;

                                    public final AdminNode apply() {
                                        return (AdminNode)GeoTransImpl$.MODULE$.streetData().get((Object)BoxesRunTime.boxToInteger((int)this.adCode$2)).orNull(Predef$.MODULE$.$conforms());
                                    }
                                    {
                                        this.adCode$2 = adCode$2;
                                    }
                                });
                            }
                        }, List$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AdminNode[]{s})));
                    }
                    {
                        this.street$1 = street$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AdminNode s) {
                        return s != null;
                    }
                })).filter((Function1)new Serializable(isFullMatch, district){
                    public static final long serialVersionUID = 0L;
                    private final boolean isFullMatch$1;
                    private final String district$1;

                    public final boolean apply(AdminNode s) {
                        return !s.level().equals((Object)DistrictLevel$.MODULE$.District()) || s.level().equals((Object)DistrictLevel$.MODULE$.District()) && (StringUtils.isEmpty((CharSequence)this.district$1) || s.name().equals(this.district$1) || !this.isFullMatch$1 && s.shortName().equals(this.district$1));
                    }
                    {
                        this.isFullMatch$1 = isFullMatch$1;
                        this.district$1 = district$1;
                    }
                });
                if (districtAd.isEmpty()) {
                    districtAd = cityAd;
                }
                if (StringUtils.isEmpty((CharSequence)street)) {
                    iterable = (Iterable)districtAd.filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AdminNode s) {
                            return s.level().equals((Object)DistrictLevel$.MODULE$.Province()) || s.level().equals((Object)DistrictLevel$.MODULE$.City()) || s.level().equals((Object)DistrictLevel$.MODULE$.District());
                        }
                    });
                } else {
                    Iterable streetAd = (Iterable)((TraversableLike)districtAd.flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final List<AdminNode> apply(AdminNode s) {
                            return s.level().equals((Object)DistrictLevel$.MODULE$.District()) ? (List)s.children().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final AdminNode apply(int adCode) {
                                    return (AdminNode)GeoTransImpl$.MODULE$.streetData().get((Object)BoxesRunTime.boxToInteger((int)adCode)).orNull(Predef$.MODULE$.$conforms());
                                }
                            }, List$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AdminNode[]{s}));
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(isFullMatch, street){
                        public static final long serialVersionUID = 0L;
                        private final boolean isFullMatch$1;
                        private final String street$1;

                        public final boolean apply(AdminNode s) {
                            return s.name().equals(this.street$1) || !this.isFullMatch$1 && s.shortName().equals(this.street$1);
                        }
                        {
                            this.isFullMatch$1 = isFullMatch$1;
                            this.street$1 = street$1;
                        }
                    });
                    if (streetAd.isEmpty()) {
                        streetAd = districtAd;
                    }
                    iterable = streetAd;
                }
            }
        }
        Iterable adminNodes = iterable;
        return ((TraversableOnce)adminNodes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Admin apply(AdminNode admin) {
                Admin admin2;
                Enumeration.Value value = admin.level();
                Enumeration.Value value2 = DistrictLevel$.MODULE$.Province();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    admin2 = Admin$.MODULE$.createProvince(admin.name(), admin.id(), admin.center());
                } else {
                    Enumeration.Value value4 = DistrictLevel$.MODULE$.City();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        AdminNode province = (AdminNode)GeoTransImpl$.MODULE$.adminData().get((Object)BoxesRunTime.boxToInteger((int)admin.parentId())).orNull(Predef$.MODULE$.$conforms());
                        admin2 = Admin$.MODULE$.createCity(province.name(), admin.name(), province.id(), admin.id(), admin.center());
                    } else {
                        Enumeration.Value value6 = DistrictLevel$.MODULE$.District();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            AdminNode city = (AdminNode)GeoTransImpl$.MODULE$.adminData().get((Object)BoxesRunTime.boxToInteger((int)admin.parentId())).orNull(Predef$.MODULE$.$conforms());
                            Enumeration.Value value8 = city.level();
                            Enumeration.Value value9 = DistrictLevel$.MODULE$.City();
                            AdminNode province = !(value8 != null ? !value8.equals(value9) : value9 != null) ? (AdminNode)GeoTransImpl$.MODULE$.adminData().get((Object)BoxesRunTime.boxToInteger((int)city.parentId())).orNull(Predef$.MODULE$.$conforms()) : city;
                            admin2 = Admin$.MODULE$.createDistrict(province.name(), city.name(), admin.name(), province.id(), city.id(), admin.id(), admin.center());
                        } else {
                            Enumeration.Value value10 = DistrictLevel$.MODULE$.Street();
                            Enumeration.Value value11 = value;
                            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                AdminNode district = (AdminNode)GeoTransImpl$.MODULE$.adminData().get((Object)BoxesRunTime.boxToInteger((int)admin.parentId())).orNull(Predef$.MODULE$.$conforms());
                                Enumeration.Value value12 = district.level();
                                Enumeration.Value value13 = DistrictLevel$.MODULE$.District();
                                AdminNode city = !(value12 != null ? !value12.equals(value13) : value13 != null) ? (AdminNode)GeoTransImpl$.MODULE$.adminData().get((Object)BoxesRunTime.boxToInteger((int)district.parentId())).orNull(Predef$.MODULE$.$conforms()) : district;
                                Enumeration.Value value14 = city.level();
                                Enumeration.Value value15 = DistrictLevel$.MODULE$.City();
                                AdminNode province = !(value14 != null ? !value14.equals(value15) : value15 != null) ? (AdminNode)GeoTransImpl$.MODULE$.adminData().get((Object)BoxesRunTime.boxToInteger((int)city.parentId())).orNull(Predef$.MODULE$.$conforms()) : city;
                                admin2 = Admin$.MODULE$.createStreet(province.name(), city.name(), district.name(), admin.name(), province.id(), city.id(), district.id(), admin.id(), admin.center());
                            } else {
                                admin2 = Admin$.MODULE$.createOversea();
                            }
                        }
                    }
                }
                return admin2;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public String normalizeName$default$1() {
        return "";
    }

    public String normalizeName$default$2() {
        return "";
    }

    public String normalizeName$default$3() {
        return "";
    }

    public String normalizeName$default$4() {
        return "";
    }

    public boolean normalizeName$default$5() {
        return false;
    }

    private int determineAdminCode(double lonIn, double latIn, Enumeration.Value coordSys) {
        int n;
        Tuple2<Object, Object> gcj02LonLat = GeoUtils$.MODULE$.toGCJ02(lonIn, latIn, coordSys);
        double lon = gcj02LonLat._1$mcD$sp();
        double lat = gcj02LonLat._2$mcD$sp();
        S2LatLng s2LatLng = S2LatLng.fromDegrees((double)lat, (double)lon);
        long id = S2CellId.fromLatLng((S2LatLng)s2LatLng).parent(12).id();
        long id2 = S2CellId.fromLatLng((S2LatLng)s2LatLng).parent(10).id();
        if (GeoUtils$.MODULE$.outOfChina(lon, lat)) {
            n = -1;
        } else if (this.boundaryAdminCell().contains((Object)BoxesRunTime.boxToLong((long)id))) {
            n = BoxesRunTime.unboxToInt((Object)this.boundaryAdminCell().getOrElse((Object)BoxesRunTime.boxToLong((long)id), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return -1;
                }
            }));
        } else if (this.boundaryAdminCell().contains((Object)BoxesRunTime.boxToLong((long)id2))) {
            n = BoxesRunTime.unboxToInt((Object)this.boundaryAdminCell().getOrElse((Object)BoxesRunTime.boxToLong((long)id2), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return -1;
                }
            }));
        } else {
            List keys = List$.MODULE$.empty();
            for (int maxLevel = 2000; keys.isEmpty() && maxLevel < 200000; maxLevel *= 2) {
                keys = (List)S2Utils$.MODULE$.getCellId(s2LatLng, maxLevel, 12).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final List<Object> apply(long key) {
                        return (List)GeoTransImpl$.MODULE$.boundaryIndex().getOrElse((Object)BoxesRunTime.boxToLong((long)key), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<Nothing$> apply() {
                                return List$.MODULE$.empty();
                            }
                        });
                    }
                }, List$.MODULE$.canBuildFrom());
            }
            if (keys.nonEmpty()) {
                double minDis;
                List lines1 = (List)((List)((List)((SeqLike)keys.map((Function1)new Serializable(s2LatLng){
                    public static final long serialVersionUID = 0L;
                    private final S2LatLng s2LatLng$1;

                    public final Tuple2<Object, Object> apply(long key) {
                        return new Tuple2.mcJD.sp(key, new S2CellId(key).toLatLng().getEarthDistance(this.s2LatLng$1));
                    }
                    {
                        this.s2LatLng$1 = s2LatLng$1;
                    }
                }, List$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$4) {
                        return x$4._2$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).take(5).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final List<Tuple4<Object, Object, Object, Object>> apply(Tuple2<Object, Object> startPoint) {
                        return (List)((List)GeoTransImpl$.MODULE$.boundaryData().getOrElse((Object)BoxesRunTime.boxToLong((long)startPoint._1$mcJ$sp()), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<Nothing$> apply() {
                                return List$.MODULE$.empty();
                            }
                        })).flatMap((Function1)new Serializable(this, startPoint){
                            public static final long serialVersionUID = 0L;
                            private final Tuple2 startPoint$1;

                            public final List<Tuple4<Object, Object, Object, Object>> apply(Tuple3<Object, Object, Object> value) {
                                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToLong((long)this.startPoint$1._1$mcJ$sp()), value._1(), value._2(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple4((Object)BoxesRunTime.boxToLong((long)this.startPoint$1._1$mcJ$sp()), value._1(), value._3(), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
                            }
                            {
                                this.startPoint$1 = startPoint$1;
                            }
                        }, List$.MODULE$.canBuildFrom());
                    }
                }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(lon, lat){
                    public static final long serialVersionUID = 0L;
                    private final double lon$1;
                    private final double lat$1;

                    public final Tuple2<Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object>, Object> apply(Tuple4<Object, Object, Object, Object> line) {
                        S2LatLng start = new S2CellId(BoxesRunTime.unboxToLong((Object)line._1())).toLatLng();
                        S2LatLng end = new S2CellId(BoxesRunTime.unboxToLong((Object)line._2())).toLatLng();
                        double dis = LineUtils$.MODULE$.pointToLineDis(start.lngDegrees(), start.latDegrees(), end.lngDegrees(), end.latDegrees(), this.lon$1, this.lat$1);
                        return new Tuple2((Object)new Tuple4((Object)new Tuple2.mcDD.sp(start.lngDegrees(), start.latDegrees()), (Object)new Tuple2.mcDD.sp(end.lngDegrees(), end.latDegrees()), line._3(), line._4()), (Object)BoxesRunTime.boxToDouble((double)dis));
                    }
                    {
                        this.lon$1 = lon$1;
                        this.lat$1 = lat$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                List lines = (List)((Tuple2)((TraversableLike)((List)lines1.filter((Function1)new Serializable(minDis = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)lines1.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object>, Object> x$5) {
                        return x$5._2$mcD$sp();
                    }
                }, List$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$))){
                    public static final long serialVersionUID = 0L;
                    private final double minDis$1;

                    public final boolean apply(Tuple2<Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object>, Object> s) {
                        return s._2$mcD$sp() == this.minDis$1;
                    }
                    {
                        this.minDis$1 = minDis$1;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object> apply(Tuple2<Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object>, Object> x$6) {
                        return (Tuple4)x$6._1();
                    }
                }, List$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object> x$7) {
                        return (Tuple2)x$7._1();
                    }
                }).maxBy((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Tuple2<Object, Object>, List<Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object>>> x$8) {
                        return ((SeqLike)x$8._2()).size();
                    }
                }, (Ordering)Ordering.Int$.MODULE$))._2();
                if (lines.size() == 1) {
                    Tuple4 line1 = (Tuple4)lines.head();
                    Tuple2 start = (Tuple2)line1._1();
                    Tuple2 end = (Tuple2)line1._2();
                    double angle = (start._1$mcD$sp() - lon) * (end._2$mcD$sp() - lat) - (end._1$mcD$sp() - lon) * (start._2$mcD$sp() - lat);
                    n = angle < 0.0 == BoxesRunTime.unboxToBoolean((Object)line1._4()) ? BoxesRunTime.unboxToInt((Object)line1._3()) : -1;
                } else if (lines.size() == 2) {
                    Tuple4 line1 = (Tuple4)lines.head();
                    Tuple4 line2 = (Tuple4)lines.last();
                    Tuple2 start = ((Tuple2)line1._2()).equals(line2._2()) ? (Tuple2)line1._1() : (Tuple2)line2._2();
                    Tuple2 end = (Tuple2)line1._2();
                    double angle = (start._1$mcD$sp() - lon) * (end._2$mcD$sp() - lat) - (end._1$mcD$sp() - lon) * (start._2$mcD$sp() - lat);
                    n = angle < 0.0 == BoxesRunTime.unboxToBoolean((Object)line1._4()) ? BoxesRunTime.unboxToInt((Object)line1._3()) : (BoxesRunTime.equals((Object)line1._2(), (Object)line2._2()) && BoxesRunTime.unboxToBoolean((Object)line1._4()) != BoxesRunTime.unboxToBoolean((Object)line2._4()) ? BoxesRunTime.unboxToInt((Object)line2._3()) : -1);
                } else {
                    n = ((Tuple2)((TraversableOnce)lines.groupBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object> x$9) {
                            return BoxesRunTime.unboxToInt((Object)x$9._3());
                        }
                    }).map((Function1)new Serializable(lon, lat){
                        public static final long serialVersionUID = 0L;
                        private final double lon$1;
                        private final double lat$1;

                        public final Tuple2<Object, Object> apply(Tuple2<Object, List<Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object>>> s) {
                            double dis2;
                            Tuple4 line1 = (Tuple4)((IterableLike)((TraversableLike)s._2()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object> x$10) {
                                    return BoxesRunTime.unboxToBoolean((Object)x$10._4());
                                }
                            })).head();
                            Tuple4 line2 = (Tuple4)((IterableLike)((TraversableLike)s._2()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple4<Tuple2<Object, Object>, Tuple2<Object, Object>, Object, Object> x$11) {
                                    return !BoxesRunTime.unboxToBoolean((Object)x$11._4());
                                }
                            })).head();
                            Tuple2 start = (Tuple2)line2._2();
                            Tuple2 end = (Tuple2)line1._2();
                            Tuple2 point = (Tuple2)line1._1();
                            double dis1 = LineUtils$.MODULE$.lineDis(start._1$mcD$sp(), start._2$mcD$sp(), point._1$mcD$sp(), point._2$mcD$sp());
                            if (dis1 > (dis2 = LineUtils$.MODULE$.lineDis(end._1$mcD$sp(), end._2$mcD$sp(), point._1$mcD$sp(), point._2$mcD$sp()))) {
                                start = new Tuple2.mcDD.sp(point._1$mcD$sp() + dis2 / dis1 * (start._1$mcD$sp() - point._1$mcD$sp()), point._2$mcD$sp() + dis2 / dis1 * (start._2$mcD$sp() - point._2$mcD$sp()));
                            } else {
                                end = new Tuple2.mcDD.sp(point._1$mcD$sp() + dis1 / dis2 * (end._1$mcD$sp() - point._1$mcD$sp()), point._2$mcD$sp() + dis1 / dis2 * (end._2$mcD$sp() - point._2$mcD$sp()));
                            }
                            double angle = (start._1$mcD$sp() - this.lon$1) * (end._2$mcD$sp() - this.lat$1) - (end._1$mcD$sp() - this.lon$1) * (start._2$mcD$sp() - this.lat$1);
                            return new Tuple2.mcID.sp(s._1$mcI$sp(), angle);
                        }
                        {
                            this.lon$1 = lon$1;
                            this.lat$1 = lat$1;
                        }
                    }, Map$.MODULE$.canBuildFrom())).minBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, Object> x$12) {
                            return x$12._2$mcD$sp();
                        }
                    }, (Ordering)Ordering.Double$.MODULE$))._1$mcI$sp();
                }
            } else {
                n = -1;
            }
        }
        return n;
    }

    private Enumeration.Value determineAdminCode$default$3() {
        return CoordinateSystem$.MODULE$.GCJ02();
    }

    public BusinessAreaInfo determineAreaByAdmin(double lon, double lat, Admin admin, int radius) {
        Seq<BusinessArea> businessAreas = this.determineAreaByCityId(lon, lat, admin.cityCode(), radius, CoordinateSystem$.MODULE$.GCJ02());
        return new BusinessAreaInfo(admin, businessAreas);
    }

    public Seq<BusinessArea> determineAreaByCityId(double lon, double lat, int cityID, int radius, Enumeration.Value coordSys) {
        Tuple2<Object, Object> gcj02LonLat = GeoUtils$.MODULE$.toGCJ02(lon, lat, coordSys);
        return cityID != -1 ? (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.cityBusinessArea().getOrElse((Object)BoxesRunTime.boxToInteger((int)cityID), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BusinessAreaData[] apply() {
                return (BusinessAreaData[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BusinessAreaData.class));
            }
        })).map((Function1)new Serializable(gcj02LonLat){
            public static final long serialVersionUID = 0L;
            private final Tuple2 gcj02LonLat$1;

            public final Tuple2<Object, BusinessAreaData> apply(BusinessAreaData area) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)GeoUtils$.MODULE$.distance(area.center(), new Location(this.gcj02LonLat$1._1$mcD$sp(), this.gcj02LonLat$1._2$mcD$sp()))), (Object)area);
            }
            {
                this.gcj02LonLat$1 = gcj02LonLat$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(radius){
            public static final long serialVersionUID = 0L;
            private final int radius$1;

            public final boolean apply(Tuple2<Object, BusinessAreaData> x$13) {
                return x$13._1$mcD$sp() <= (double)this.radius$1;
            }
            {
                this.radius$1 = radius$1;
            }
        })).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, BusinessAreaData> x$14) {
                return x$14._1$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BusinessArea apply(Tuple2<Object, BusinessAreaData> s) {
                return new BusinessArea(((BusinessAreaData)s._2()).name(), ((BusinessAreaData)s._2()).areaCode(), (int)s._1$mcD$sp());
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())) : (Seq)Seq$.MODULE$.empty();
    }

    private GeoTransImpl$() {
        MODULE$ = this;
        this.cityNameMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"\u91cd\u5e86\u5e02", (Object)""), new Tuple2((Object)"\u4e0a\u6d77\u5e02", (Object)"\u4e0a\u6d77\u57ce\u533a"), new Tuple2((Object)"\u5317\u4eac\u5e02", (Object)"\u5317\u4eac\u57ce\u533a"), new Tuple2((Object)"\u5929\u6d25\u5e02", (Object)"\u5929\u6d25\u57ce\u533a"), new Tuple2((Object)"\u90a3\u66f2\u5e02", (Object)"\u90a3\u66f2\u5730\u533a")}));
        this.districtNameMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"\u4e91\u5dde\u533a", (Object)"\u5927\u540c\u53bf"), new Tuple2((Object)"\u5e73\u57ce\u533a", (Object)"\u57ce\u533a"), new Tuple2((Object)"\u4e91\u5188\u533a", (Object)"\u5357\u90ca\u533a"), new Tuple2((Object)"\u4f59\u6c5f\u533a", (Object)"\u4f59\u6c5f\u53bf"), new Tuple2((Object)"\u9a6c\u9f99\u533a", (Object)"\u9a6c\u9f99\u53bf"), new Tuple2((Object)"\u5149\u660e\u533a", (Object)"\u5b9d\u5b89\u533a"), new Tuple2((Object)"\u6000\u4ec1\u533a", (Object)"\u6000\u4ec1\u53bf"), new Tuple2((Object)"\u5f6c\u5dde\u5e02", (Object)"\u5f6c\u53bf"), new Tuple2((Object)"\u6d77\u5b89\u5e02", (Object)"\u6d77\u5b89\u53bf"), new Tuple2((Object)"\u6f20\u6cb3\u5e02", (Object)"\u6f20\u6cb3\u53bf"), new Tuple2((Object)"\u4eac\u5c71\u5e02", (Object)"\u4eac\u5c71\u53bf"), new Tuple2((Object)"\u6d4e\u9633\u533a", (Object)"\u6d4e\u9633\u53bf"), new Tuple2((Object)"\u6f5e\u5dde\u533a", (Object)"\u57ce\u533a"), new Tuple2((Object)"\u4e0a\u515a\u533a", (Object)"\u957f\u6cbb\u53bf"), new Tuple2((Object)"\u5c6f\u7559\u533a", (Object)"\u5c6f\u7559\u53bf"), new Tuple2((Object)"\u6f5e\u57ce\u533a", (Object)"\u6f5e\u57ce\u5e02"), new Tuple2((Object)"\u6ee6\u5dde\u5e02", (Object)"\u6ee6\u53bf"), new Tuple2((Object)"\u6f5c\u5c71\u5e02", (Object)"\u6f5c\u5c71\u53bf"), new Tuple2((Object)"\u90b9\u5e73\u5e02", (Object)"\u90b9\u5e73\u53bf"), new Tuple2((Object)"\u8354\u6d66\u5e02", (Object)"\u8354\u6d66\u53bf"), new Tuple2((Object)"\u5174\u4ec1\u5e02", (Object)"\u5174\u4ec1\u53bf"), new Tuple2((Object)"\u6c34\u5bcc\u5e02", (Object)"\u6c34\u5bcc\u53bf"), new Tuple2((Object)"\u534e\u4ead\u5e02", (Object)"\u534e\u4ead\u53bf"), new Tuple2((Object)"\u79ef\u77f3\u5c71\u53bf", (Object)"\u79ef\u77f3\u5c71\u4fdd\u5b89\u65cf\u4e1c\u4e61\u65cf\u6492\u62c9\u65cf\u81ea\u6cbb\u53bf"), new Tuple2((Object)"\u5143\u6c5f\u53bf", (Object)"\u5143\u6c5f\u54c8\u5c3c\u65cf\u5f5d\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf"), new Tuple2((Object)"\u53cc\u6c5f\u53bf", (Object)"\u53cc\u6c5f\u62c9\u795c\u65cf\u4f64\u65cf\u5e03\u6717\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf"), new Tuple2((Object)"\u5b5f\u8fde\u53bf", (Object)"\u5b5f\u8fde\u50a3\u65cf\u62c9\u795c\u65cf\u4f64\u65cf\u81ea\u6cbb\u53bf"), new Tuple2((Object)"\u9547\u6c85\u53bf", (Object)"\u9547\u6c85\u5f5d\u65cf\u54c8\u5c3c\u65cf\u62c9\u795c\u65cf\u81ea\u6cbb\u53bf"), new Tuple2((Object)"\u5927\u67f4\u65e6\u884c\u653f\u59d4\u5458\u4f1a", (Object)"\u6d77\u897f\u8499\u53e4\u65cf\u85cf\u65cf\u81ea\u6cbb\u5dde\u76f4\u8f96"), new Tuple2((Object)"\u51b7\u6e56\u884c\u653f\u59d4\u5458\u4f1a", (Object)"\u6d77\u897f\u8499\u53e4\u65cf\u85cf\u65cf\u81ea\u6cbb\u5dde\u76f4\u8f96"), new Tuple2((Object)"\u832b\u5d16\u884c\u653f\u59d4\u5458\u4f1a", (Object)"\u6d77\u897f\u8499\u53e4\u65cf\u85cf\u65cf\u81ea\u6cbb\u5dde\u76f4\u8f96"), new Tuple2((Object)"\u4e0a\u9976\u53bf", (Object)"\u5e7f\u4fe1\u533a"), new Tuple2((Object)"\u8fbe\u5b5c\u533a", (Object)"\u8fbe\u5b5c\u53bf"), new Tuple2((Object)"\u8272\u5c3c\u533a", (Object)"\u90a3\u66f2\u53bf")}));
    }
}

