/*
 * Decompiled with CFR 0.152.
 */
package com.dengxq.lnglat2Geo.utils;

import com.dengxq.lnglat2Geo.utils.GeoUtils$;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2PolygonBuilder;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2RegionCoverer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class S2Utils$ {
    public static final S2Utils$ MODULE$;
    private final Map<Object, Object> capHeightMap;
    private final double kEarthCircumferenceMeters;

    static {
        new S2Utils$();
    }

    public Map<Object, Object> capHeightMap() {
        return this.capHeightMap;
    }

    public List<Object> getCellId(S2LatLng s2LatLng, int radius, int desLevel) {
        double capHeight = BoxesRunTime.unboxToDouble((Object)this.capHeightMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)radius), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }));
        S2Cap cap = S2Cap.fromAxisHeight((S2Point)s2LatLng.toPoint(), (double)capHeight);
        S2RegionCoverer coverer = new S2RegionCoverer();
        coverer.setMaxLevel(desLevel);
        coverer.setMinLevel(desLevel);
        return ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)coverer.getCovering((S2Region)cap).cellIds()).flatMap((Function1)new Serializable(desLevel){
            public static final long serialVersionUID = 0L;
            private final int desLevel$1;

            public final AbstractSeq<Object> apply(S2CellId s2CellId) {
                int cellLevel = S2Utils$.MODULE$.getLevel(s2CellId.id());
                return cellLevel == this.desLevel$1 ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{s2CellId.id()})) : (AbstractSeq)S2Utils$.MODULE$.childrenCellId(s2CellId, cellLevel, this.desLevel$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(S2CellId x$1) {
                        return x$1.id();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
            }
            {
                this.desLevel$1 = desLevel$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public ArrayBuffer<S2CellId> childrenCellId(S2CellId s2CellId, int curLevel, int desLevel) {
        ArrayBuffer list = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (curLevel < desLevel) {
            long interval = (s2CellId.childEnd().id() - s2CellId.childBegin().id()) / 4L;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1)new Serializable(s2CellId, curLevel, desLevel, list, interval){
                public static final long serialVersionUID = 0L;
                private final S2CellId s2CellId$1;
                private final int curLevel$1;
                private final int desLevel$2;
                private final ArrayBuffer list$1;
                private final long interval$1;

                public final ArrayBuffer<S2CellId> apply(int i) {
                    long id = this.s2CellId$1.childBegin().id() + this.interval$1 * (long)i;
                    S2CellId cellId = new S2CellId(id);
                    return this.list$1.$plus$plus$eq(S2Utils$.MODULE$.childrenCellId(cellId, this.curLevel$1 + 1, this.desLevel$2));
                }
                {
                    this.s2CellId$1 = s2CellId$1;
                    this.curLevel$1 = curLevel$1;
                    this.desLevel$2 = desLevel$2;
                    this.list$1 = list$1;
                    this.interval$1 = interval$1;
                }
            });
        } else {
            list.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new S2CellId[]{s2CellId}));
        }
        return list;
    }

    public int getLevel(long inputs) {
        int n = 0;
        long input = inputs;
        while (input % 2L == 0L) {
            input /= 2L;
            ++n;
        }
        return 30 - n / 2;
    }

    private double kEarthCircumferenceMeters() {
        return this.kEarthCircumferenceMeters;
    }

    public double com$dengxq$lnglat2Geo$utils$S2Utils$$earthMeters2Radians(double meters) {
        return Math.PI * 2 * (meters / (double)40075017);
    }

    public S2CellUnion loadS2CellUnion(String polylineString, int minLevel, int maxLevel, int maxCells, boolean isInner) {
        S2PolygonBuilder s2PolygonBuilder = new S2PolygonBuilder();
        Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(polylineString)).split('|')).foreach((Function1)new Serializable(s2PolygonBuilder){
            public static final long serialVersionUID = 0L;
            private final S2PolygonBuilder s2PolygonBuilder$1;

            public final void apply(String loopStr) {
                S2Point[] points = (S2Point[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(loopStr)).split(';')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final S2Point apply(String coordStr) {
                        String[] parts = new StringOps(Predef$.MODULE$.augmentString(coordStr)).split(',');
                        Tuple2<Object, Object> wgs84 = GeoUtils$.MODULE$.gcj02ToWgs84(new StringOps(Predef$.MODULE$.augmentString(parts[0])).toDouble(), new StringOps(Predef$.MODULE$.augmentString(parts[1])).toDouble());
                        return S2LatLng.fromDegrees((double)wgs84._2$mcD$sp(), (double)wgs84._1$mcD$sp()).toPoint();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(S2Point.class)));
                java.util.List jPoints = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])points).toList()).asJava();
                this.s2PolygonBuilder$1.addLoop(new S2Loop(jPoints));
            }
            {
                this.s2PolygonBuilder$1 = s2PolygonBuilder$1;
            }
        });
        S2Polygon polygon = s2PolygonBuilder.assemblePolygon();
        S2RegionCoverer coverer = new S2RegionCoverer();
        if (minLevel > 0) {
            coverer.setMinLevel(minLevel);
        }
        if (maxLevel > 0) {
            coverer.setMaxLevel(maxLevel);
        }
        if (maxCells > 0) {
            coverer.setMaxCells(maxCells);
        }
        S2CellUnion s2CellUnion = isInner ? coverer.getInteriorCovering((S2Region)polygon) : coverer.getCovering((S2Region)polygon);
        return s2CellUnion;
    }

    public int loadS2CellUnion$default$2() {
        return -1;
    }

    public int loadS2CellUnion$default$3() {
        return -1;
    }

    public int loadS2CellUnion$default$4() {
        return -1;
    }

    public boolean loadS2CellUnion$default$5() {
        return false;
    }

    public S2CellUnion loadS2CellUnionFromId(long[][] polyline, int minLevel, int maxLevel, int maxCells, boolean isInner) {
        S2PolygonBuilder s2PolygonBuilder = new S2PolygonBuilder();
        Predef$.MODULE$.refArrayOps((Object[])polyline).foreach((Function1)new Serializable(s2PolygonBuilder){
            public static final long serialVersionUID = 0L;
            private final S2PolygonBuilder s2PolygonBuilder$2;

            public final void apply(long[] loopStr) {
                S2Point[] points = (S2Point[])Predef$.MODULE$.longArrayOps(loopStr).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final S2Point apply(long id) {
                        return new S2CellId(id).toPoint();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(S2Point.class)));
                java.util.List jPoints = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])points).toList()).asJava();
                this.s2PolygonBuilder$2.addLoop(new S2Loop(jPoints));
            }
            {
                this.s2PolygonBuilder$2 = s2PolygonBuilder$2;
            }
        });
        S2Polygon polygon = s2PolygonBuilder.assemblePolygon();
        S2RegionCoverer coverer = new S2RegionCoverer();
        if (minLevel > 0) {
            coverer.setMinLevel(minLevel);
        }
        if (maxLevel > 0) {
            coverer.setMaxLevel(maxLevel);
        }
        if (maxCells > 0) {
            coverer.setMaxCells(maxCells);
        }
        coverer.setLevelMod(3);
        S2CellUnion s2CellUnion = isInner ? coverer.getInteriorCovering((S2Region)polygon) : coverer.getCovering((S2Region)polygon);
        return s2CellUnion;
    }

    public int loadS2CellUnionFromId$default$2() {
        return -1;
    }

    public int loadS2CellUnionFromId$default$3() {
        return -1;
    }

    public int loadS2CellUnionFromId$default$4() {
        return -1;
    }

    public boolean loadS2CellUnionFromId$default$5() {
        return false;
    }

    private S2Utils$() {
        MODULE$ = this;
        this.capHeightMap = ((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 8, 16, 32, 64, 128, 256})).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int radius) {
                double rad = S2Utils$.MODULE$.com$dengxq$lnglat2Geo$utils$S2Utils$$earthMeters2Radians(radius * 1000);
                return new Tuple2.mcID.sp(radius * 1000, rad * rad * (double)2);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.kEarthCircumferenceMeters = 4.0075017E7;
    }
}

