/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMString;
import com.github.fppt.jedismock.exception.DeserializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public final class Slice
implements Comparable<Slice>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Slice emptySlice = new Slice(new byte[0]);
    private final byte[] storedData;

    private Slice(byte[] storedData) {
        Objects.requireNonNull(storedData);
        this.storedData = storedData;
    }

    public static Slice create(byte[] data) {
        return new Slice(data);
    }

    public static Slice create(String data) {
        return Slice.create((byte[])data.getBytes().clone());
    }

    public static Slice empty() {
        return emptySlice;
    }

    public byte[] data() {
        return (byte[])this.storedData.clone();
    }

    public int length() {
        return this.storedData.length;
    }

    public String toString() {
        return new String(this.storedData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)o;
        return Arrays.equals(this.storedData, other.storedData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.storedData);
    }

    @Override
    public int compareTo(Slice other) {
        Objects.requireNonNull(other, "other");
        int len1 = this.storedData.length;
        int len2 = other.storedData.length;
        int lim = Math.min(len1, len2);
        for (int i = 0; i < lim; ++i) {
            int b;
            int a = Byte.toUnsignedInt(this.storedData[i]);
            if (a == (b = Byte.toUnsignedInt(other.storedData[i]))) continue;
            return Integer.compare(a, b);
        }
        return Integer.compare(len1, len2);
    }

    public RMDataStructure extract() {
        if (this.storedData.length > 2 && this.storedData[0] == -84 && this.storedData[1] == -19) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.storedData));
                Object value = objectInputStream.readObject();
                if (value instanceof RMDataStructure) {
                    return (RMDataStructure)value;
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new DeserializationException("problems with deserialization");
            }
        }
        return RMString.create(this.storedData);
    }
}

