/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.toolkit.TableList;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.MPJAbstractWrapper;
import com.github.yulichang.wrapper.enums.PrefixEnum;
import com.github.yulichang.wrapper.segments.SelectCache;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public abstract class MPJAbstractLambdaWrapper<T, Children extends MPJAbstractLambdaWrapper<T, Children>>
extends MPJAbstractWrapper<T, Children> {
    protected String alias = ConfigProperties.tableAlias;
    protected boolean resultMap = false;
    protected int tableIndex = 1;

    @Override
    protected <X> String columnToString(Integer index, X column, boolean isJoin, PrefixEnum prefixEnum) {
        return this.columnToString(index, (SFunction)column, isJoin, prefixEnum);
    }

    @Override
    @SafeVarargs
    protected final <X> String columnsToString(Integer index, boolean isJoin, PrefixEnum prefixEnum, X ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString(index, (SFunction)i, isJoin, prefixEnum)).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(Integer index, SFunction<?, ?> column, boolean isJoin, PrefixEnum prefixEnum) {
        Class<?> entityClass = LambdaUtils.getEntityClass(column);
        return this.getDefault(index, entityClass, isJoin, prefixEnum) + "." + this.getCache(column).getColumn();
    }

    protected SelectCache getCache(SFunction<?, ?> fn) {
        Class<?> aClass = LambdaUtils.getEntityClass(fn);
        Map<String, SelectCache> cacheMap = ColumnCache.getMapField(aClass);
        return cacheMap.get(LambdaUtils.getName(fn));
    }

    protected String getDefault(Integer index, Class<?> clazz, boolean isJoin, PrefixEnum prefixEnum) {
        if (prefixEnum == PrefixEnum.ON_FIRST) {
            return this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.ON_SECOND) {
            return isJoin ? this.tableList.getPrefixOther(index, clazz) : this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_FIRST) {
            return this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_SECOND) {
            return isJoin ? this.tableList.getPrefixOther(index, clazz) : this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_ON_FIRST) {
            return this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_ON_SECOND) {
            return isJoin ? this.tableList.getPrefixOther(index, clazz) : this.tableList.getPrefix(index, clazz, false);
        }
        return this.tableList.getAlias();
    }

    protected void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
        this.sqlFirst = SharedString.emptyString();
        this.tableList = new TableList();
        this.tableList.setAlias(this.alias);
    }

    public boolean isResultMap() {
        return this.resultMap;
    }
}

