/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.utils;

import com.itranswarp.summer.io.InputStreamCallback;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class ClassPathUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readInputStream(String path, InputStreamCallback<T> inputStreamCallback) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try (InputStream input = ClassPathUtils.getContextClassLoader().getResourceAsStream(path);){
            if (input == null) {
                throw new FileNotFoundException("File not found in classpath: " + path);
            }
            T t = inputStreamCallback.doWithInputStream(input);
            return t;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedIOException(e);
        }
    }

    public static String readString(String path) {
        return ClassPathUtils.readInputStream(path, input -> {
            byte[] data = input.readAllBytes();
            return new String(data, StandardCharsets.UTF_8);
        });
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassPathUtils.class.getClassLoader();
        }
        return cl;
    }
}

