/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.markup.rule;

import com.nhncorp.lucy.security.xss.markup.rule.CharArraySegment;
import com.nhncorp.lucy.security.xss.markup.rule.NonTerminal;
import com.nhncorp.lucy.security.xss.markup.rule.ParsingGrammar;
import com.nhncorp.lucy.security.xss.markup.rule.ParsingRule;
import com.nhncorp.lucy.security.xss.markup.rule.Terminal;
import com.nhncorp.lucy.security.xss.markup.rule.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Group
extends NonTerminal {
    private String name;
    private OPERATOR op;
    private List<ParsingRule> rules = new ArrayList<ParsingRule>();

    public Group() {
    }

    public Group(String name) {
        this();
        this.name = name;
    }

    @Override
    public String getRuleName() {
        return this.name == null ? "" : this.name;
    }

    public OPERATOR getOperator() {
        return this.op;
    }

    public void setOperator(OPERATOR op) {
        this.op = op;
    }

    public boolean hasOrOperation() {
        return this.op != null && this.op == OPERATOR.OR;
    }

    public boolean hasMinusOperation() {
        return this.op != null && this.op == OPERATOR.MINUS;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public void add(ParsingRule rule) {
        this.rules.add(rule);
    }

    public void addAll(Collection<? extends ParsingRule> rules) {
        if (rules == null) {
            return;
        }
        this.rules.addAll(rules);
    }

    public ParsingRule get(int index) {
        return this.rules.get(index);
    }

    public List<ParsingRule> getAll() {
        return this.rules;
    }

    public void remove(ParsingRule rule) {
        this.rules.remove(rule);
    }

    @Override
    public Token nextToken(Token token, CharArraySegment input, ParsingGrammar grammar) {
        if (!this.sliceToken(token, input, grammar)) {
            return null;
        }
        List<Token> children = token.getChildren();
        Token child = children.get(0);
        return child;
    }

    @Override
    public boolean sliceTokens(Token parent, CharArraySegment input, ParsingGrammar grammar) {
        boolean isTokenized = false;
        int start = input.pos();
        do {
            Token token;
            if (this.sliceToken(token = new Token(parent.getName()), input, grammar)) {
                parent.addChild(token);
                isTokenized = true;
                start = input.pos();
                if (!"contents".equals(parent.getName())) continue;
                break;
            }
            input.pos(start);
            break;
        } while (this.isRepeat());
        return isTokenized;
    }

    boolean sliceToken(Token parent, CharArraySegment input, ParsingGrammar grammar) {
        boolean isTokenized = false;
        if (input == null || !input.hasRemaining()) {
            return isTokenized;
        }
        if (this.hasOrOperation()) {
            ParsingRule rule;
            Iterator<ParsingRule> iterator = this.getAll().iterator();
            while (iterator.hasNext() && !(isTokenized = this.sliceTokenByRule(parent, rule = iterator.next(), input, grammar))) {
            }
        } else if (this.hasMinusOperation()) {
            ParsingRule left = this.get(0);
            ParsingRule right = this.get(1);
            int pos = -1;
            pos = right instanceof NonTerminal ? ((NonTerminal)NonTerminal.class.cast(right)).matchPos(input, grammar) : ((Terminal)Terminal.class.cast(right)).matchPos(input);
            if (pos >= input.pos()) {
                CharArraySegment segment = input.subSegment(input.pos(), pos);
                isTokenized = this.sliceTokenByRule(parent, left, segment, grammar);
                input.pos(input.pos() + segment.pos());
            } else {
                isTokenized = this.sliceTokenByRule(parent, left, input, grammar);
            }
        } else {
            boolean flag = false;
            for (int i = 0; i < this.getRuleCount(); ++i) {
                ParsingRule rule = this.get(i);
                flag = this.sliceTokenByRule(parent, rule, input, grammar);
                if (!rule.isOptional() && !flag) {
                    isTokenized = false;
                    break;
                }
                if (!flag) continue;
                isTokenized = true;
            }
        }
        return isTokenized;
    }

    @Override
    public int matchPos(CharArraySegment input, ParsingGrammar grammar) {
        int pos = -1;
        List<Terminal> terms = this.getFirstNonOptTerminals(grammar);
        if (terms != null && !terms.isEmpty()) {
            for (Terminal term : terms) {
                int tmp = term.matchPos(input);
                if (tmp < 0 || pos >= 0 && tmp >= pos) continue;
                pos = tmp;
            }
        }
        return pos;
    }

    @Override
    public List<Terminal> getFirstNonOptTerminals(ParsingGrammar grammar) {
        if (this.hasMinusOperation() || this.isOptional()) {
            return null;
        }
        ArrayList<Terminal> terms = new ArrayList<Terminal>();
        for (ParsingRule rule : this.getAll()) {
            if (rule.isOptional()) continue;
            if (rule instanceof NonTerminal) {
                List<Terminal> tmp = ((NonTerminal)NonTerminal.class.cast(rule)).getFirstNonOptTerminals(grammar);
                if (tmp != null && !tmp.isEmpty()) {
                    terms.addAll(tmp);
                }
            } else {
                terms.add((Terminal)Terminal.class.cast(rule));
            }
            if (this.hasOrOperation() || terms.isEmpty()) continue;
            break;
        }
        return terms;
    }

    private boolean sliceTokenByRule(Token parent, ParsingRule rule, CharArraySegment input, ParsingGrammar grammar) {
        boolean isTokenized = false;
        isTokenized = rule instanceof NonTerminal ? ((NonTerminal)NonTerminal.class.cast(rule)).sliceTokens(parent, input, grammar) : ((Terminal)Terminal.class.cast(rule)).sliceToken(parent, input);
        return isTokenized;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPERATOR {
        OR,
        MINUS;


        public static OPERATOR getValue(char ch) {
            if (ch == '|') {
                return OR;
            }
            if (ch == '-') {
                return MINUS;
            }
            return null;
        }
    }
}

