/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.markup.rule;

import com.nhncorp.lucy.security.xss.markup.rule.CharArraySegment;
import com.nhncorp.lucy.security.xss.markup.rule.CharCode;
import com.nhncorp.lucy.security.xss.markup.rule.CharCodeSet;
import com.nhncorp.lucy.security.xss.markup.rule.Group;
import com.nhncorp.lucy.security.xss.markup.rule.Literal;
import com.nhncorp.lucy.security.xss.markup.rule.NonTerminal;
import com.nhncorp.lucy.security.xss.markup.rule.ParsingRule;
import com.nhncorp.lucy.security.xss.markup.rule.Reference;
import com.nhncorp.lucy.security.xss.markup.rule.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ParsingGrammar {
    private static final String RULE_FILE = "markup.rule";
    private static final String START_SYMBOL = "contents";
    private static final String DEFINE = "::=";
    private static ParsingGrammar instance = new ParsingGrammar();
    private Map<String, Group> rules = new HashMap<String, Group>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsingGrammar() {
        BufferedReader reader = null;
        try {
            String line;
            InputStream input = ParsingGrammar.class.getResourceAsStream(RULE_FILE);
            reader = new BufferedReader(new InputStreamReader(input));
            StringBuffer buffer = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//")) {
                    if (buffer == null) continue;
                    this.readNotation(buffer.toString());
                    buffer = null;
                    continue;
                }
                if (line.contains(DEFINE)) {
                    if (buffer != null) {
                        this.readNotation(buffer.toString());
                    }
                    buffer = new StringBuffer();
                    buffer.append(line.trim());
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(line.trim());
            }
            if (buffer != null) {
                this.readNotation(buffer.toString());
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static ParsingGrammar getInstance() {
        return instance;
    }

    Group getRule(String ruleName) {
        return this.rules.get(ruleName);
    }

    public Token tokenize(String input) {
        Token token;
        if (input == null || input.length() <= 0) {
            return null;
        }
        Group start = instance.getRule(START_SYMBOL);
        if (!((NonTerminal)start).sliceTokens(token = new Token(((NonTerminal)start).getRuleName()), new CharArraySegment(input), instance)) {
            return null;
        }
        return token;
    }

    public Token nextToken(CharArraySegment input) {
        if (input == null || input.length() <= 0) {
            return null;
        }
        Group start = instance.getRule(START_SYMBOL);
        Token startToken = new Token(((NonTerminal)start).getRuleName());
        Token token = ((NonTerminal)start).nextToken(startToken, input, instance);
        return token;
    }

    private void readNotation(String notation) {
        if (!notation.contains(DEFINE)) {
            return;
        }
        String[] pair = notation.split(DEFINE);
        String name = pair[0].trim();
        String exp = pair[1].trim();
        Group group = new Group(name);
        this.builRules(group, new CharArraySegment(exp.toCharArray()));
        this.rules.put(name, group);
    }

    private void builRules(Group parent, CharArraySegment input) {
        ArrayList<ParsingRule> tmp = new ArrayList<ParsingRule>();
        ParsingRule preRule = null;
        while (input.hasRemaining()) {
            RuleType type = RuleType.getType(input);
            if (type == null) {
                input.move();
                continue;
            }
            CharArraySegment segment = type.sliceFrom(input);
            if (type == RuleType.LITERAL && segment.length() == 1) {
                type = RuleType.CHARCODE;
                char code = segment.getChar();
                segment = new CharArraySegment(Integer.toHexString(code).toCharArray());
            }
            switch (type) {
                case LITERAL: {
                    Literal literal = new Literal(segment.toString());
                    tmp.add(literal);
                    preRule = literal;
                    break;
                }
                case CHARCODESET: {
                    if (preRule != null && parent.hasOrOperation() && preRule instanceof CharCodeSet) {
                        CharCodeSet set = (CharCodeSet)CharCodeSet.class.cast(preRule);
                        set.setAll(new CharCodeSet(segment));
                        break;
                    }
                    if (preRule != null && parent.hasMinusOperation() && preRule instanceof CharCodeSet) {
                        CharCodeSet set = (CharCodeSet)CharCodeSet.class.cast(preRule);
                        set.flipAll(new CharCodeSet(segment));
                        break;
                    }
                    if (preRule != null && parent.hasOrOperation() && preRule instanceof CharCode) {
                        CharCodeSet set = new CharCodeSet(segment);
                        set.set(((CharCode)CharCode.class.cast(preRule)).getCode());
                        parent.remove(preRule);
                        tmp.add(set);
                        preRule = set;
                        break;
                    }
                    CharCodeSet set = new CharCodeSet(segment);
                    tmp.add(set);
                    preRule = set;
                    break;
                }
                case CHARCODE: {
                    if (preRule != null && parent.hasOrOperation() && preRule instanceof CharCodeSet) {
                        CharCodeSet set = (CharCodeSet)CharCodeSet.class.cast(preRule);
                        set.set(CharCode.parse(segment.toString()));
                        break;
                    }
                    if (preRule != null && parent.hasMinusOperation() && preRule instanceof CharCodeSet) {
                        CharCodeSet set = (CharCodeSet)CharCodeSet.class.cast(preRule);
                        set.flip(CharCode.parse(segment.toString()));
                        break;
                    }
                    if (preRule != null && parent.hasOrOperation() && preRule instanceof CharCode) {
                        CharCodeSet set = new CharCodeSet();
                        set.set(((CharCode)CharCode.class.cast(preRule)).getCode());
                        set.set(CharCode.parse(segment.toString()));
                        parent.remove(preRule);
                        tmp.add(set);
                        preRule = set;
                        break;
                    }
                    CharCode code = new CharCode(CharCode.parse(segment.toString()));
                    tmp.add(code);
                    preRule = code;
                    break;
                }
                case UNARY: {
                    ParsingRule.UNARY unary = ParsingRule.UNARY.getValue(segment.charAt(0));
                    if (preRule == null || unary == ParsingRule.UNARY.ONE) break;
                    if (preRule.isRepeat() && unary == ParsingRule.UNARY.OPTION) {
                        preRule.setUnary(ParsingRule.UNARY.REPEAT0);
                        break;
                    }
                    preRule.setUnary(unary);
                    break;
                }
                case OPERATOR: {
                    Group.OPERATOR op = Group.OPERATOR.getValue(segment.charAt(0));
                    if (op == null) break;
                    if (tmp.size() > 1) {
                        Group group = new Group();
                        group.addAll(tmp);
                        parent.add(group);
                    } else {
                        parent.addAll(tmp);
                    }
                    parent.setOperator(op);
                    preRule = parent.get(parent.getRuleCount() - 1);
                    tmp = new ArrayList();
                    break;
                }
                case GROUP: {
                    Group group = new Group();
                    this.builRules(group, segment);
                    if (group.getRuleCount() == 1) {
                        ParsingRule rule = group.get(0);
                        tmp.add(rule);
                        preRule = rule;
                        break;
                    }
                    tmp.add(group);
                    preRule = group;
                    break;
                }
                case REFERENCE: {
                    Reference ref = new Reference(segment.toString());
                    tmp.add(ref);
                    preRule = ref;
                    break;
                }
            }
        }
        if (tmp.size() > 1 && parent.hasOrOperation()) {
            Group group = new Group();
            group.addAll(tmp);
            parent.add(group);
        } else {
            parent.addAll(tmp);
        }
        if (parent.getRuleCount() == 1) {
            parent.setOperator(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RuleType {
        LITERAL{

            boolean startAt(CharArraySegment input) {
                char ch = input.getChar();
                return ch == '\"' || ch == '\'';
            }

            CharArraySegment sliceFrom(CharArraySegment input) {
                char ch = input.getChar();
                int pos = input.move().posOf(ch);
                CharArraySegment result = input.subSegment(input.pos(), pos);
                input.move(result.length() + 1);
                return result;
            }
        }
        ,
        CHARCODESET{

            boolean startAt(CharArraySegment input) {
                return input.getChar() == '[';
            }

            CharArraySegment sliceFrom(CharArraySegment input) {
                int pos = input.move(1).posOf(']');
                CharArraySegment result = input.subSegment(input.pos(), pos);
                input.move(result.length() + 1);
                return result;
            }
        }
        ,
        CHARCODE{

            boolean startAt(CharArraySegment input) {
                return input.startWith("#x");
            }

            CharArraySegment sliceFrom(CharArraySegment input) {
                char ch;
                int start;
                int end = start = input.move(2).pos();
                while (input.hasRemaining() && CharArraySegment.isHexChar(ch = input.getChar())) {
                    end = input.move(1).pos();
                }
                return input.subSegment(start, end);
            }
        }
        ,
        UNARY{

            boolean startAt(CharArraySegment input) {
                char ch = input.getChar();
                return ch == '?' || ch == '*' || ch == '+';
            }

            CharArraySegment sliceFrom(CharArraySegment input) {
                return input.move(1).subSegment(input.pos() - 1, input.pos());
            }
        }
        ,
        OPERATOR{

            boolean startAt(CharArraySegment input) {
                char ch = input.getChar();
                return ch == '|' || ch == '-';
            }

            CharArraySegment sliceFrom(CharArraySegment input) {
                return input.move(1).subSegment(input.pos() - 1, input.pos());
            }
        }
        ,
        GROUP{

            boolean startAt(CharArraySegment input) {
                return input.getChar() == '(';
            }

            CharArraySegment sliceFrom(CharArraySegment input) {
                int start;
                int end = start = input.move(1).pos();
                int depth = 0;
                while (input.hasRemaining()) {
                    char ch = input.getChar();
                    if (ch == '(') {
                        ++depth;
                    } else if (ch == ')') {
                        if (depth > 0) {
                            --depth;
                        } else {
                            end = input.pos();
                            input.move(1);
                            break;
                        }
                    }
                    input.move(1);
                }
                return input.subSegment(start, end);
            }
        }
        ,
        REFERENCE{

            boolean startAt(CharArraySegment input) {
                return Character.isLetter(input.getChar());
            }

            CharArraySegment sliceFrom(CharArraySegment input) {
                int start;
                int end = start = input.pos();
                while (input.hasRemaining() && Character.isLetterOrDigit(input.getChar())) {
                    end = input.move(1).pos();
                }
                return input.subSegment(start, end);
            }
        };


        static RuleType getType(CharArraySegment input) {
            RuleType result = null;
            for (RuleType type : RuleType.values()) {
                if (!type.startAt(input)) continue;
                result = type;
                break;
            }
            return result;
        }

        abstract boolean startAt(CharArraySegment var1);

        abstract CharArraySegment sliceFrom(CharArraySegment var1);
    }
}

