/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.pili;

import com.qiniu.pili.Config;
import com.qiniu.pili.Mac;
import com.qiniu.pili.PiliException;
import java.net.URL;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

final class RPC {
    private Mac mac;
    private OkHttpClient okHttpClient;

    public RPC(Mac mac) {
        this.mac = mac;
        this.okHttpClient = new OkHttpClient();
    }

    public Mac getMac() {
        return this.mac;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public String callWithJson(String urlStr, String json) throws Exception {
        String contentType = "application/json";
        URL url = new URL(urlStr);
        byte[] body = json.getBytes("UTF-8");
        String macToken = this.mac.signRequest(url, "POST", body, contentType);
        RequestBody rBody = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])body);
        Request request = new Request.Builder().url(url).post(rBody).header("User-Agent", Config.APIUserAgent).addHeader("Authorization", "Qiniu " + macToken).addHeader("Content-Type", contentType).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new PiliException(response);
    }

    public String callWithGet(String urlStr) throws Exception {
        URL url = new URL(urlStr);
        String macToken = this.mac.signRequest(url, "GET", null, null);
        Request request = new Request.Builder().url(url).get().header("User-Agent", Config.APIUserAgent).addHeader("Authorization", "Qiniu " + macToken).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new PiliException(response);
    }
}

