/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.crawler.model;

import com.taobao.kelude.aps.crawler.model.BaseCrawlerEntity;
import com.taobao.kelude.aps.crawler.model.NeteaseEntity;
import com.taobao.kelude.aps.crawler.model.TiebaEntity;
import com.taobao.kelude.aps.crawler.model.WeiboEntity;
import com.taobao.kelude.aps.utils.StringUtils;
import com.taobao.kelude.common.BaseModel;
import java.util.Date;

public class MonitorData
extends BaseModel {
    private static final long serialVersionUID = 6955949476659284549L;
    private Integer id;
    private Integer monitorId;
    private Integer productId;
    private String title;
    private Long commentCount;
    private Long repostCount;
    private Date createdAt;
    private String visitUrl;
    private Integer emotion;
    private Integer hot;

    public MonitorData() {
    }

    public MonitorData(Integer monitorId, Integer productId, String title, Long commentCount, Long repostCount, String visitUrl, Integer emotion) {
        this.monitorId = monitorId;
        this.productId = productId;
        this.title = title;
        this.commentCount = commentCount;
        this.repostCount = repostCount;
        this.visitUrl = visitUrl;
        this.emotion = emotion;
    }

    public static MonitorData convertWeibo(WeiboEntity entity) {
        MonitorData data = new MonitorData();
        MonitorData.convertBase(data, entity);
        String title = StringUtils.filterString(entity.getContent());
        if (title != null && (title = title.trim()).startsWith(":")) {
            title = title.substring(1);
        }
        data.title = title == null ? "Unknown title" : title;
        data.commentCount = entity.getCommentCount();
        data.repostCount = entity.getRepostCount();
        return data;
    }

    public static MonitorData convertNetease(NeteaseEntity entity) {
        MonitorData data = new MonitorData();
        MonitorData.convertBase(data, entity);
        data.title = entity.getTitle();
        data.commentCount = entity.getReplyCount();
        data.repostCount = 0L;
        return data;
    }

    public static MonitorData convertTieba(TiebaEntity entity) {
        MonitorData data = new MonitorData();
        MonitorData.convertBase(data, entity);
        data.title = entity.getTitle();
        data.commentCount = entity.getReplyCount();
        data.repostCount = 0L;
        return data;
    }

    private static void convertBase(MonitorData data, BaseCrawlerEntity entity) {
        data.visitUrl = entity.getVisitUrl();
        data.emotion = entity.getEmotionScore();
        data.hot = entity.computeHot();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getMonitorId() {
        return this.monitorId;
    }

    public void setMonitorId(Integer monitorId) {
        this.monitorId = monitorId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(Long commentCount) {
        this.commentCount = commentCount;
    }

    public Long getRepostCount() {
        return this.repostCount;
    }

    public void setRepostCount(Long repostCount) {
        this.repostCount = repostCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getVisitUrl() {
        return this.visitUrl;
    }

    public void setVisitUrl(String visitUrl) {
        this.visitUrl = visitUrl;
    }

    public Integer getEmotion() {
        return this.emotion;
    }

    public void setEmotion(Integer emotion) {
        this.emotion = emotion;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public Integer getHot() {
        return this.hot;
    }

    public void setHot(Integer hot) {
        this.hot = hot;
    }

    public String toString() {
        return "MonitorData [id=" + this.id + ", monitorId=" + this.monitorId + ", productId=" + this.productId + ", title=" + this.title + ", commentCount=" + this.commentCount + ", repostCount=" + this.repostCount + ", createdAt=" + this.createdAt + ", visitUrl=" + this.visitUrl + ", emotion=" + this.emotion + ", hot=" + this.hot + "]";
    }
}

