/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.crawler.model;

import com.taobao.kelude.aps.crawler.model.BaseCrawlerEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeteaseEntity
extends BaseCrawlerEntity {
    private static final long serialVersionUID = 4543995271410053589L;
    private static Logger log = LoggerFactory.getLogger(NeteaseEntity.class);
    private String title;
    private String detailURL;
    private String commentURL;
    private String boardId;
    private int replyCount;
    private String date;

    public NeteaseEntity() {
    }

    public NeteaseEntity(String title, String content, String detailURL) {
        this.title = title;
        this.detailURL = detailURL;
        this.parseId();
        this.setContent(content);
    }

    private void parseId() {
        int index = this.detailURL.lastIndexOf("/");
        int end = this.detailURL.lastIndexOf(".html");
        this.id = this.detailURL.substring(index + 1, end);
        index = this.id.indexOf("_");
        if (index >= 0) {
            this.id = this.id.substring(0, index).trim();
        }
    }

    @Override
    public int computeHot() {
        this.hot = this.replyCount;
        return this.hot;
    }

    @Override
    public boolean checkTimeFilter() {
        if (this.date == null || "".equals(this.date) || this.date.indexOf("\u5206\u949f\u524d") >= 0 || this.date.indexOf("\u5c0f\u65f6\u524d") >= 0 || this.date.indexOf("\u6628\u5929") >= 0) {
            return false;
        }
        this.date = this.date.trim();
        StringTokenizer token = new StringTokenizer(this.date, " \n\t\f");
        if (token.countTokens() < 2) {
            return false;
        }
        token.nextToken();
        String time = token.nextToken().replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "-");
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date lastDate = dateFormat.parse(time);
            return this.checkTimeFilter(lastDate);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDetailURL() {
        return this.detailURL;
    }

    public void setDetailURL(String detailURL) {
        this.detailURL = detailURL;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public void setCommentURL(String commentURL) {
        this.commentURL = commentURL;
    }

    public int getReplyCount() {
        return this.replyCount;
    }

    public void setReplyCount(int replyCount) {
        this.replyCount = replyCount;
    }

    public String getBoardId() {
        return this.boardId;
    }

    public void setBoardId(String boardId) {
        this.boardId = boardId;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public String toString() {
        return "NeteaseEntity [id=" + this.id + ", title=" + this.title + ", detailURL=" + this.detailURL + ", commentURL=" + this.commentURL + ", boardId=" + this.boardId + ", replyCount=" + this.replyCount + ", content=" + this.content + ", emotionScore=" + this.emotionScore + ", posCount=" + this.posCount + ", negCount=" + this.negCount + ", midCount=" + this.midCount + ", visitUrl=" + this.visitUrl + "]";
    }
}

