/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.crawler.model;

import com.taobao.kelude.aps.crawler.model.BaseCrawlerEntity;
import com.taobao.kelude.aps.utils.HttpUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiboEntity
extends BaseCrawlerEntity {
    private static final long serialVersionUID = -4273675217635552922L;
    private static Logger log = LoggerFactory.getLogger(WeiboEntity.class);
    String name;
    String source;
    long repostCount;
    int goodCount;
    long commentCount;
    String repostURL;
    String commentURL;
    String date;

    public WeiboEntity() {
    }

    public WeiboEntity(String name, String content, int repostCount, int goodCount, int commentCount, String repostURL, String commentURL) {
        this.name = name;
        this.content = content;
        this.repostCount = repostCount;
        this.goodCount = goodCount;
        this.commentCount = commentCount;
        this.repostURL = repostURL;
        this.commentURL = commentURL;
    }

    public boolean parse(Element el) {
        try {
            Map<String, String> map;
            String preUrl;
            this.id = el.attr("id");
            this.id = this.id.substring("M_".length()).trim();
            Element man = el.select("a[class=nk]").first();
            this.name = man.text();
            Element cct = el.select("span[class=ctt]").first();
            this.content = cct.text();
            Element repostEl = el.select("a[href^=http://weibo.cn/repost/" + this.id + "]").first();
            Element commentEl = el.select("a[href^=http://weibo.cn/comment/" + this.id + "]").first();
            Element goodEl = el.select("a[href^=http://weibo.cn/attitude/" + this.id + "]").first();
            this.repostURL = repostEl.attr("href");
            this.commentURL = commentEl.attr("href");
            String repost = repostEl.text();
            String comment = commentEl.text();
            String good = goodEl.text();
            this.repostCount = this.getCountLong(repost);
            this.commentCount = this.getCountLong(comment);
            this.goodCount = this.getCount(good);
            Element cmt = el.select("span.cmt").last();
            if (cmt != null) {
                this.source = this.content;
                this.content = cmt.parent().text().replace("\u8f6c\u53d1\u7406\u7531:", "");
                int index = this.content.indexOf("\u8d5e[");
                this.content = this.content.substring(0, index - 1).trim();
            }
            String string = preUrl = this.repostURL == null ? this.commentURL : this.repostURL;
            if (preUrl != null && (map = HttpUtils.parseHttpUrl(preUrl)) != null) {
                String uid = map.get("uid");
                this.visitUrl = this.buildVisitUrl(uid);
            }
            if (this.content == null || this.id == null || "".equals(this.id)) {
                return false;
            }
            this.setContent(this.content);
            this.date = this.getWeiboDate(el);
            return true;
        }
        catch (Exception e) {
            log.error("Fail to parse entity. Cause " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean checkTimeFilter() {
        if (this.date.indexOf("\u5206\u949f\u524d") >= 0 || this.date.indexOf("\u4eca\u5929") >= 0 || this.date.indexOf("\u5c0f\u65f6\u524d") >= 0) {
            return false;
        }
        if (this.date.indexOf("\u5e74") >= 0) {
            return true;
        }
        String time = this.date.replace("\u6708", "-").replace("\u65e5", "-");
        Calendar calc = Calendar.getInstance();
        int year = calc.get(1);
        time = year + "-" + time;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date lastDate = dateFormat.parse(time);
            return this.checkTimeFilter(lastDate);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private int getCount(String s) {
        int start = s.indexOf("[");
        int end = s.indexOf("]", start);
        if (start < 0 || end < 0) {
            return 0;
        }
        String count = s.substring(start + 1, end).trim();
        return Integer.parseInt(count);
    }

    private long getCountLong(String s) {
        int start = s.indexOf("[");
        int end = s.indexOf("]", start);
        if (start < 0 || end < 0) {
            return 0L;
        }
        String count = s.substring(start + 1, end).trim();
        return Long.parseLong(count);
    }

    private String buildVisitUrl(String uid) {
        StringBuilder buf = new StringBuilder();
        buf.append("http://weibo.com/").append(uid).append('/').append(this.id);
        return buf.toString();
    }

    private String getWeiboDate(Element el) {
        Element ctEl = el.select("span.ct").first();
        String time = ctEl.text().trim();
        int index = time.indexOf("\u6765\u81ea");
        if (index >= 0) {
            time = time.substring(0, index).trim();
        }
        if ((index = time.indexOf("\u65e5")) >= 0) {
            time = time.substring(0, index + 1).trim();
        }
        if (time == null || "".equals(time)) {
            return null;
        }
        return time;
    }

    @Override
    public int computeHot() {
        this.hot = (int)((double)this.commentCount * 0.2 + (double)this.repostCount * 0.8);
        return this.hot;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getRepostCount() {
        return this.repostCount;
    }

    public void setRepostCount(long repostCount) {
        this.repostCount = repostCount;
    }

    public int getGoodCount() {
        return this.goodCount;
    }

    public void setGoodCount(int goodCount) {
        this.goodCount = goodCount;
    }

    public long getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(long commentCount) {
        this.commentCount = commentCount;
    }

    public String getRepostURL() {
        return this.repostURL;
    }

    public void setRepostURL(String repostURL) {
        this.repostURL = repostURL;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public void setCommentURL(String commentURL) {
        this.commentURL = commentURL;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public String toString() {
        return "WeiboEntity [id=" + this.id + ", name=" + this.name + ", repostCount=" + this.repostCount + ", goodCount=" + this.goodCount + ", commentCount=" + this.commentCount + ", repostURL=" + this.repostURL + ", commentURL=" + this.commentURL + ", content=" + this.content + ", emotionScore=" + this.emotionScore + ", posCount=" + this.posCount + ", negCount=" + this.negCount + ", midCount=" + this.midCount + ", visitUrl=" + this.visitUrl + "]";
    }
}

