/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.feedback.model;

import com.taobao.kelude.admin.model.Attachment;
import com.taobao.kelude.aps.feedback.enums.FeedbackType;
import com.taobao.kelude.aps.feedback.enums.ImportanceLevel;
import com.taobao.kelude.aps.feedback.enums.ProcStatus;
import com.taobao.kelude.aps.feedback.enums.SourceType;
import com.taobao.kelude.aps.feedback.enums.ValidStatus;
import com.taobao.kelude.aps.feedback.model.ApsFeedbackBase;
import com.taobao.kelude.aps.feedback.model.Tag;
import com.taobao.kelude.aps.opensearch.annotations.FieldPlugin;
import com.taobao.kelude.aps.opensearch.annotations.SearchEntity;
import com.taobao.kelude.aps.opensearch.annotations.SearchFieldMeta;
import com.taobao.kelude.aps.opensearch.annotations.SearchMapping;
import com.taobao.kelude.aps.opensearch.plugins.SearchListFieldPlugin;
import com.taobao.kelude.aps.opensearch.plugins.SearchTagsFieldPlugin;
import com.taobao.kelude.aps.opensearch.plugins.SearchTagsIdsFieldPlugin;
import com.taobao.kelude.aps.utils.DateUtils;
import com.taobao.kelude.aps.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SearchEntity(value="feedbacks")
public class ApsFeedback
extends ApsFeedbackBase {
    private static final long serialVersionUID = 1L;
    private Boolean kqFlag;
    private Boolean kqNoCheckRepeat;
    private Long preId;
    @SearchMapping(value="id", primaryKey=true)
    private Long id;
    @SearchMapping(value="updated_at")
    private Date updatedAt;
    @SearchMapping(value="issue_at")
    private Date issueAt;
    @SearchMapping
    private String province;
    @SearchMapping
    private String city;
    @SearchMapping
    private String country;
    @SearchMapping(value="network_operator")
    private String networkOperator;
    @SearchMapping(value="k_user_id")
    private Long kUserId;
    @SearchMapping(value="account_type")
    private Integer accountType;
    @SearchMapping
    private Integer importance;
    @SearchMapping(value="proc_status")
    private Integer procStatus;
    @SearchMapping(readable=false)
    @FieldPlugin(value=SearchTagsFieldPlugin.class)
    private List<Tag> tags;
    @SearchMapping(value="tags_empty", writeable=false)
    private Boolean tagsEmpty;
    @SearchMapping(value="tag_names", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY, writeable=false)
    @FieldPlugin(value=SearchTagsIdsFieldPlugin.class)
    private String tagsStr;
    @SearchMapping(value="tag_ids", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY, writeable=false)
    @FieldPlugin(value=SearchTagsIdsFieldPlugin.class)
    private String tagIdsStr;
    @SearchMapping(value="event_names", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY, writeable=false)
    @FieldPlugin(value=SearchTagsIdsFieldPlugin.class)
    private String eventsStr;
    @SearchMapping(value="event_ids", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY, writeable=false)
    @FieldPlugin(value=SearchTagsIdsFieldPlugin.class)
    private String eventIdsStr;
    @SearchMapping(value="is_replied")
    private Boolean isReplied;
    private List<Attachment> attachments;
    @SearchMapping(value="kbm_knowledge_id")
    private Integer kbmKnowledgeId;
    @SearchMapping(value="kbm_classify_id")
    private Integer kbmClassifyId;
    @SearchMapping(value="wb_fans_count")
    private Long wbFansCount;
    @SearchMapping(value="wb_repost_count")
    private Long wbRepostCount;
    @SearchMapping(value="wb_comment_count")
    private Long wbCommentCount;
    @SearchMapping(value="wb_like_count")
    private Long wbLikeCount;
    @SearchMapping(value="wb_certificate")
    private Integer wbVerifiedType;
    @SearchMapping(value="crawler_keywords")
    private String crawlerKeywords;
    private String appKey;
    @SearchMapping
    private String cluster;
    @SearchMapping(value="feedback_classify", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY, writeable=false)
    @FieldPlugin(value=SearchTagsIdsFieldPlugin.class)
    private String feedbackClassify;
    @SearchMapping(value="feedback_classify_ids", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY, writeable=false)
    @FieldPlugin(value=SearchTagsIdsFieldPlugin.class)
    private String feedbackClassifyIds;
    @SearchMapping(value="feedback_confirm_classify")
    private String feedbackConfirmClassify;
    @SearchMapping(value="emotion_tendency")
    private Integer emotionTendency;
    @SearchMapping(value="emotion_score")
    private Integer emotionScore;
    @SearchMapping(value="emotion_category")
    private Integer emotionCategory;
    @SearchMapping(value="emotion_confirm_tendency")
    private Integer emotionConfirmTendency;
    @SearchMapping(value="kelude_ids")
    private String keludeIds;
    @SearchMapping(value="url_md5")
    private String urlMD5;
    @SearchMapping(value="pub_time")
    private Date pubTime;
    @SearchMapping(value="first_question_time")
    private Date firstQuestionTime;
    @SearchMapping(value="keywords")
    private String keywords;
    @SearchMapping(value="monitor_topic_id")
    private Integer monitorTopicId;
    @SearchMapping(value="monitor_keyword_id")
    private Integer monitorkeywordId;
    @SearchMapping(value="parent_source")
    private String parentSource;
    @SearchMapping(value="site_name")
    private String siteName;
    @SearchMapping(value="source_id")
    private Integer sourceId;
    @SearchMapping(value="filter_type")
    private Integer filterType;
    private Integer filterFlag;
    @SearchMapping(value="filter_rule")
    private String filterRule;
    private String spiderDataKey;
    private Integer spiderDataType;
    private String spiderAttachmentUrls;
    @SearchMapping(value="newest_time")
    private Date newestTime;
    @SearchMapping(value="cluster_flag")
    private Integer clusterFlag;
    @SearchMapping(value="points_count")
    private Long pointsCount;
    @SearchMapping(value="cluster_id")
    private Long clusterId;
    @SearchMapping(value="cluster_priority")
    private Integer clusterPriority;
    private String spiderTitleKey;
    @SearchMapping(value="priority_modified")
    private Integer priorityModified;
    @SearchMapping(value="cluster_valid_status")
    private Integer clusterValidStatus;
    @SearchMapping(value="cluster_proc_status")
    private Integer clusterProcStatus;
    @SearchMapping(value="cluster_proc_flag")
    private Integer clusterProcFlag;
    @SearchMapping(value="newest_feedback_id")
    private Long newestFeedbackId;
    @SearchMapping(value="newest_feedback_subject")
    private String newestFeedbackSubject;
    @SearchMapping(value="cluster_points_ids")
    private String clusterPointsIds;
    @SearchMapping(value="lang_type")
    private String langType;
    @SearchMapping(value="validity_score")
    private Integer validityScore;
    @SearchMapping(value="summary_keywords", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY)
    @FieldPlugin(value=SearchListFieldPlugin.class)
    private List<String> summaryKeywordList;
    @SearchMapping(value="event_cluster_ids", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY)
    @FieldPlugin(value=SearchListFieldPlugin.class)
    private List<String> eventClusterIds;
    private Integer sourceTopicId;
    @SearchMapping(value="translate_subject")
    private String translateSubject;
    private String translateDescription;
    @SearchMapping(value="read_status")
    private Integer readStatus = 0;
    @SearchMapping(value="cluster_read_status")
    private Integer clusterReadStatus = 0;
    @SearchMapping(value="spider_topic_id")
    private Integer spiderTopicId;
    private Boolean weiboAccountFilter = false;
    private String weiboPriMessageType;
    private String xzUrl;
    private Integer todayFlag = 0;
    @SearchMapping(value="consult_time")
    private String consultTime;
    @SearchMapping(value="consult_read_count")
    private Integer consultReadCount;
    @SearchMapping(value="work_id")
    private Long workId;
    @SearchMapping(value="bc_classify_tags")
    private String bcClassifyTags;
    private String secondTags;
    private Boolean clusterOriginFlag;
    private Integer starValue;
    private Integer newestInfoFlag;
    private Boolean aoneNotifyFlag;
    @SearchMapping(value="newest_message_id")
    private Long newestMessageId;
    @SearchMapping(value="newest_message_time")
    private Date newestMessageTime;
    private String issueStatus;
    private Boolean remindFlag;
    @SearchMapping(value="vone_user_type")
    private Integer voneUserType;
    @SearchMapping(value="watcher_ids", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.INT32_ARRAY)
    @FieldPlugin(value=SearchListFieldPlugin.class)
    private List<Integer> watcherIds;

    public ApsFeedback() {
        this.procStatus = ProcStatus.TODO.key;
        this.clusterProcStatus = ProcStatus.TODO.key;
        this.clusterProcFlag = 0;
        this.clusterValidStatus = ValidStatus.INVALID.getKey();
        this.importance = ImportanceLevel.NORMAL.getKey();
        this.isReplied = false;
        this.updatedAt = new Date();
    }

    public void clearUpdate() {
        this.procStatus = null;
        this.clusterProcStatus = null;
        this.clusterProcFlag = null;
        this.clusterValidStatus = null;
        this.importance = null;
        this.isReplied = null;
        this.updatedAt = new Date();
        this.todayFlag = null;
        this.clusterReadStatus = null;
        this.readStatus = null;
        this.validStatus = null;
        this.setProductType(null);
        this.setPriority(null);
        this.setFeedbackType(null);
    }

    public Integer getStarValue() {
        return this.starValue;
    }

    public Long getPreId() {
        return this.preId;
    }

    public void setPreId(Long preId) {
        this.preId = preId;
    }

    public void setStarValue(Integer starValue) {
        this.starValue = starValue;
    }

    public Boolean getWeiboAccountFilter() {
        return this.weiboAccountFilter;
    }

    public void setWeiboAccountFilter(Boolean weiboAccountFilter) {
        this.weiboAccountFilter = weiboAccountFilter;
    }

    public Integer getSpiderTopicId() {
        return this.spiderTopicId;
    }

    public void setSpiderTopicId(Integer spiderTopicId) {
        this.spiderTopicId = spiderTopicId;
    }

    public Integer getReadStatus() {
        return this.readStatus;
    }

    public void setReadStatus(Integer readStatus) {
        this.readStatus = readStatus;
    }

    public Integer getClusterReadStatus() {
        return this.clusterReadStatus;
    }

    public void setClusterReadStatus(Integer clusterReadStatus) {
        this.clusterReadStatus = clusterReadStatus;
    }

    public boolean valid() {
        return null != this.getProductId() && null != this.getProductType() && org.apache.commons.lang.StringUtils.isNotEmpty((String)this.getDescription());
    }

    public boolean validDataFromSpier() {
        return this.valid() && org.apache.commons.lang.StringUtils.isNotEmpty((String)this.getUrlMD5()) && null != this.getSourceId() && org.apache.commons.lang.StringUtils.isNotEmpty((String)this.getTbNickname()) && org.apache.commons.lang.StringUtils.isNotEmpty((String)this.getCrawlerKeywords()) && org.apache.commons.lang.StringUtils.isNotEmpty((String)this.getSource());
    }

    public static ApsFeedback emptyValue() {
        ApsFeedback fb = new ApsFeedback();
        fb.setProcStatus(null);
        fb.setImportance(null);
        fb.setIsReplied(null);
        fb.setUpdatedAt(null);
        fb.setValidStatus(null);
        fb.setPriority(null);
        fb.setFeedbackType(null);
        return fb;
    }

    public void modifyFlagTendency(Integer tendency) {
        this.emotionTendency = tendency;
        this.emotionConfirmTendency = tendency;
        this.emotionCategory = 0;
        if (null == this.emotionScore) {
            this.emotionScore = 0;
        }
        if (this.emotionScore == 0 && tendency > 0) {
            this.emotionScore = 20;
        } else if (this.emotionScore == 0 && tendency < 0) {
            this.emotionScore = -20;
        } else if (this.emotionScore < 0 && tendency > 0 || this.emotionScore > 0 && tendency < 0) {
            this.emotionScore = -this.emotionScore.intValue();
        }
    }

    public Date getValidTime() {
        return this.pubTime == null ? this.getCreatedAt() : this.pubTime;
    }

    public String getKeludeIds() {
        return this.keludeIds;
    }

    public void setKeludeIds(String keludeIds) {
        this.keludeIds = keludeIds;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getKqFlag() {
        return this.kqFlag;
    }

    public void setKqFlag(Boolean kqFlag) {
        this.kqFlag = kqFlag;
    }

    public Date getUpdatedAt() {
        if (null == this.updatedAt) {
            this.updatedAt = new Date();
        }
        return this.updatedAt;
    }

    public String getUpdatedAtStr() {
        return DateUtils.dateTimeToString(this.getUpdatedAt());
    }

    public String getUpdatedAtAboutTimeFormat() {
        return DateUtils.aboutTimeFormat(this.getUpdatedAt());
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getNetworkOperator() {
        return this.networkOperator;
    }

    public void setNetworkOperator(String networkOperator) {
        this.networkOperator = networkOperator;
    }

    public Long getkUserId() {
        return this.kUserId;
    }

    public void setkUserId(Long kUserId) {
        this.kUserId = kUserId;
    }

    public Integer getAccountType() {
        return this.accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getImportance() {
        return this.importance;
    }

    public void setImportance(Integer importance) {
        this.importance = importance;
    }

    public Integer getProcStatus() {
        return this.procStatus;
    }

    public void setProcStatus(Integer procStatus) {
        this.procStatus = procStatus;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Integer getConsultReadCount() {
        return this.consultReadCount;
    }

    public Boolean getKqNoCheckRepeat() {
        return this.kqNoCheckRepeat;
    }

    public void setKqNoCheckRepeat(Boolean kqNoCheckRepeat) {
        this.kqNoCheckRepeat = kqNoCheckRepeat;
    }

    public void setConsultReadCount(Integer consultReadCount) {
        this.consultReadCount = consultReadCount;
    }

    public String getIssueStatus() {
        return this.issueStatus;
    }

    public void setIssueStatus(String issueStatus) {
        this.issueStatus = issueStatus;
    }

    public Boolean getRemindFlag() {
        return this.remindFlag;
    }

    public void setRemindFlag(Boolean remindFlag) {
        this.remindFlag = remindFlag;
    }

    public static String appendTagIds(List<Tag> tags, Integer tagsType) {
        if (null != tags && !tags.isEmpty()) {
            ArrayList<Integer> tagIds = new ArrayList<Integer>();
            for (Tag tag : tags) {
                if (!tagsType.equals(tag.getTagsType())) continue;
                tagIds.add(tag.getId());
            }
            return org.apache.commons.lang.StringUtils.join(tagIds, (String)"|");
        }
        return "";
    }

    public static String appendTagIds(List<Tag> tags, List<Integer> tagsTypes) {
        if (null != tags && !tags.isEmpty()) {
            ArrayList<Integer> tagIds = new ArrayList<Integer>();
            for (Tag tag : tags) {
                if (!tagsTypes.contains(tag.getTagsType())) continue;
                tagIds.add(tag.getId());
            }
            return org.apache.commons.lang.StringUtils.join(tagIds, (String)"|");
        }
        return "";
    }

    public static String appendTagIdAndEmotions(List<Tag> tags, List<Integer> tagsTypes) {
        if (null != tags && !tags.isEmpty()) {
            ArrayList<String> tagIdAndEmotions = new ArrayList<String>();
            for (Tag tag : tags) {
                if (!tagsTypes.contains(tag.getTagsType())) continue;
                tagIdAndEmotions.add(tag.getId().toString() + "_" + (tag.getEmotionTendency() != null ? tag.getEmotionTendency().toString() : "0"));
            }
            return org.apache.commons.lang.StringUtils.join(tagIdAndEmotions, (String)"|");
        }
        return "";
    }

    public static String appendTagNames(List<Tag> tags, Integer tagsType) {
        if (null != tags && !tags.isEmpty()) {
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags) {
                if (!tagsType.equals(tag.getTagsType())) continue;
                tagNames.add(tag.getName());
            }
            return org.apache.commons.lang.StringUtils.join(tagNames, (String)"|");
        }
        return "";
    }

    public static String appendTagNames(List<Tag> tags, List<Integer> tagsTypes) {
        if (null != tags && !tags.isEmpty()) {
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags) {
                if (!tagsTypes.contains(tag.getTagsType())) continue;
                tagNames.add(tag.getName());
            }
            return org.apache.commons.lang.StringUtils.join(tagNames, (String)"|");
        }
        return "";
    }

    public String getTagsStr() {
        if (null == this.tags) {
            return this.tagsStr;
        }
        return ApsFeedback.appendTagNames(this.tags, Tag.TYPE_NORMAL);
    }

    public void setTagsStr(String tagsStr) {
        this.tagsStr = tagsStr;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getTagIdsStr() {
        if (null == this.tags) {
            return this.tagIdsStr;
        }
        return ApsFeedback.appendTagIds(this.tags, Tag.TYPE_NORMAL);
    }

    public void setTagIdsStr(String tagIdsStr) {
        this.tagIdsStr = tagIdsStr;
    }

    public String getEventsStr() {
        if (null == this.tags) {
            return this.eventsStr;
        }
        return ApsFeedback.appendTagNames(this.tags, Arrays.asList(Tag.TYPE_INTERNAL_EVENTS, Tag.TYPE_EXTERNAL_EVENTS));
    }

    public void setEventsStr(String eventsStr) {
        this.eventsStr = eventsStr;
    }

    public String getEventIdsStr() {
        if (null == this.tags) {
            return this.eventIdsStr;
        }
        return ApsFeedback.appendTagIds(this.tags, Tag.TYPE_INTERNAL_EVENTS);
    }

    public void setEventIdsStr(String eventIdsStr) {
        this.eventIdsStr = eventIdsStr;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public String getAttachmentUrls() {
        if (null == this.attachments) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        for (Attachment att : this.attachments) {
            urls.add(att.getUrl());
        }
        return org.apache.commons.lang.StringUtils.join(urls, (String)",");
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Date getIssueAt() {
        return this.issueAt;
    }

    public String getIssueAtStr() {
        if (null != this.issueAt) {
            return DateUtils.dateTimeToString(this.issueAt);
        }
        return null;
    }

    public void setIssueAt(Date issueAt) {
        this.issueAt = issueAt;
    }

    public Boolean getTagsEmpty() {
        return this.tagsEmpty;
    }

    public void setTagsEmpty(Boolean tagsEmpty) {
        this.tagsEmpty = tagsEmpty;
    }

    public Boolean getIsReplied() {
        return this.isReplied;
    }

    public void setIsReplied(Boolean isReplied) {
        this.isReplied = isReplied;
    }

    public Integer getKbmKnowledgeId() {
        return this.kbmKnowledgeId;
    }

    public void setKbmKnowledgeId(Integer kbmKnowledgeId) {
        this.kbmKnowledgeId = kbmKnowledgeId;
    }

    public Integer getKbmClassifyId() {
        return this.kbmClassifyId;
    }

    public void setKbmClassifyId(Integer kbmClassifyId) {
        this.kbmClassifyId = kbmClassifyId;
    }

    public Long getWbFansCount() {
        return this.wbFansCount == null ? 0L : this.wbFansCount;
    }

    public void setWbFansCount(Long wbFansCount) {
        this.wbFansCount = wbFansCount;
    }

    public Long getWbRepostCount() {
        return this.wbRepostCount == null ? 0L : this.wbRepostCount;
    }

    public void setWbRepostCount(Long wbRepostCount) {
        this.wbRepostCount = wbRepostCount;
    }

    public Long getWbCommentCount() {
        return this.wbCommentCount == null ? 0L : this.wbCommentCount;
    }

    public void setWbCommentCount(Long wbCommentCount) {
        this.wbCommentCount = wbCommentCount;
    }

    public String getCrawlerKeywords() {
        return this.crawlerKeywords;
    }

    public void setCrawlerKeywords(String crawlerKeywords) {
        this.crawlerKeywords = crawlerKeywords;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getFeedbackClassify() {
        if (null == this.tags) {
            return this.feedbackClassify;
        }
        return ApsFeedback.appendTagNames(this.tags, Tag.TYPE_CLASSIFY);
    }

    public void setFeedbackClassify(String feedbackClassify) {
        this.feedbackClassify = feedbackClassify;
    }

    public String getFeedbackConfirmClassify() {
        return this.feedbackConfirmClassify;
    }

    public void setFeedbackConfirmClassify(String feedbackConfirmClassify) {
        this.feedbackConfirmClassify = feedbackConfirmClassify;
    }

    public Integer getEmotionTendency() {
        return this.emotionTendency;
    }

    public void setEmotionTendency(Integer emotionTendency) {
        this.emotionTendency = emotionTendency;
    }

    public Integer getEmotionScore() {
        return this.emotionScore;
    }

    public void setEmotionScore(Integer emotionScore) {
        this.emotionScore = emotionScore;
    }

    public Integer getEmotionCategory() {
        return this.emotionCategory;
    }

    public void setEmotionCategory(Integer emotionCategory) {
        this.emotionCategory = emotionCategory;
    }

    public Integer getEmotionConfirmTendency() {
        return this.emotionConfirmTendency;
    }

    public void setEmotionConfirmTendency(Integer emotionConfirmTendency) {
        this.emotionConfirmTendency = emotionConfirmTendency;
    }

    public String getUrlMD5() {
        return this.urlMD5;
    }

    public String getUmengFeedbackId() {
        if (StringUtils.isEmpty((String)this.urlMD5) || this.urlMD5.length() > 32) {
            return this.urlMD5;
        }
        return "C" + this.urlMD5.substring(0, 8) + "-" + this.urlMD5.substring(8, 12) + "-" + this.urlMD5.substring(12, 16) + "-" + this.urlMD5.substring(16, 20) + "-" + this.urlMD5.substring(20);
    }

    public void setUrlMD5(String urlMD5) {
        this.urlMD5 = urlMD5;
    }

    public Date getPubTime() {
        return this.pubTime;
    }

    public String getPubTimeStr() {
        if (null == this.pubTime) {
            return "";
        }
        return DateUtils.dateTimeToString(this.getPubTime());
    }

    public void setPubTime(Date pubTime) {
        this.pubTime = pubTime;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Integer getMonitorTopicId() {
        return this.monitorTopicId;
    }

    public void setMonitorTopicId(Integer monitorTopicId) {
        this.monitorTopicId = monitorTopicId;
    }

    public Integer getMonitorkeywordId() {
        return this.monitorkeywordId;
    }

    public void setMonitorkeywordId(Integer monitorkeywordId) {
        this.monitorkeywordId = monitorkeywordId;
    }

    public String getParentSource() {
        return this.parentSource;
    }

    public void setParentSource(String parentSource) {
        this.parentSource = parentSource;
    }

    public Integer getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getFilterType() {
        return this.filterType;
    }

    public void setFilterType(Integer filterType) {
        this.filterType = filterType;
    }

    public String getFilterRule() {
        return this.filterRule;
    }

    public void setFilterRule(String filterRule) {
        this.filterRule = filterRule;
    }

    public Integer getWbVerifiedType() {
        return this.wbVerifiedType == null ? 0 : this.wbVerifiedType;
    }

    public void setWbVerifiedType(Integer wbVerifiedType) {
        this.wbVerifiedType = wbVerifiedType;
    }

    public Long getWbLikeCount() {
        return this.wbLikeCount;
    }

    public void setWbLikeCount(Long wbLikeCount) {
        this.wbLikeCount = wbLikeCount;
    }

    public String getSpiderDataKey() {
        return this.spiderDataKey;
    }

    public void setSpiderDataKey(String spiderDataKey) {
        this.spiderDataKey = spiderDataKey;
    }

    public Integer getSpiderDataType() {
        return this.spiderDataType;
    }

    public void setSpiderDataType(Integer spiderDataType) {
        this.spiderDataType = spiderDataType;
    }

    public Date getNewestTime() {
        return this.newestTime;
    }

    public void setNewestTime(Date newestTime) {
        this.newestTime = newestTime;
    }

    public Integer getClusterFlag() {
        return this.clusterFlag;
    }

    public void setClusterFlag(Integer clusterFlag) {
        this.clusterFlag = clusterFlag;
    }

    public Long getPointsCount() {
        return this.pointsCount == null ? 0L : this.pointsCount;
    }

    public void setPointsCount(Long pointsCount) {
        this.pointsCount = pointsCount;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getSpiderTitleKey() {
        return this.spiderTitleKey;
    }

    public void setSpiderTitleKey(String spiderTitleKey) {
        this.spiderTitleKey = spiderTitleKey;
    }

    public Integer getClusterPriority() {
        return this.clusterPriority;
    }

    public void setClusterPriority(Integer clusterPriority) {
        this.clusterPriority = clusterPriority;
    }

    public Integer getPriorityModified() {
        this.priorityModified = this.priorityModified == null ? 0 : this.priorityModified;
        return this.priorityModified;
    }

    public void setPriorityModified(Integer priorityModified) {
        this.priorityModified = priorityModified;
    }

    public Integer getClusterValidStatus() {
        return this.clusterValidStatus;
    }

    public void setClusterValidStatus(Integer clusterValidStatus) {
        this.clusterValidStatus = clusterValidStatus;
    }

    public Integer getClusterProcStatus() {
        return this.clusterProcStatus;
    }

    public void setClusterProcStatus(Integer clusterProcStatus) {
        this.clusterProcStatus = clusterProcStatus;
    }

    public Integer getClusterProcFlag() {
        return this.clusterProcFlag;
    }

    public void setClusterProcFlag(Integer clusterProcFlag) {
        this.clusterProcFlag = clusterProcFlag;
    }

    public Long getNewestFeedbackId() {
        return this.newestFeedbackId;
    }

    public void setNewestFeedbackId(Long newestFeedbackId) {
        this.newestFeedbackId = newestFeedbackId;
    }

    public String getNewestFeedbackSubject() {
        return this.newestFeedbackSubject;
    }

    public void setNewestFeedbackSubject(String newestFeedbackSubject) {
        this.newestFeedbackSubject = newestFeedbackSubject;
    }

    public String getClusterPointsIds() {
        return this.clusterPointsIds;
    }

    public void setClusterPointsIds(String clusterPointsIds) {
        this.clusterPointsIds = clusterPointsIds;
    }

    public String getSpiderAttachmentUrls() {
        return this.spiderAttachmentUrls;
    }

    public void setSpiderAttachmentUrls(String spiderAttachmentUrls) {
        this.spiderAttachmentUrls = spiderAttachmentUrls;
    }

    public String getFeedbackClassifyIds() {
        if (null == this.tags) {
            return this.feedbackClassifyIds;
        }
        return ApsFeedback.appendTagIds(this.tags, Tag.TYPE_CLASSIFY);
    }

    public void setFeedbackClassifyIds(String feedbackClassifyIds) {
        this.feedbackClassifyIds = feedbackClassifyIds;
    }

    public String getLangType() {
        return this.langType;
    }

    public void setLangType(String langType) {
        this.langType = langType;
    }

    public Integer getValidityScore() {
        return this.validityScore;
    }

    public void setValidityScore(Integer validityScore) {
        this.validityScore = validityScore;
    }

    public List<String> getSummaryKeywordList() {
        return this.summaryKeywordList;
    }

    public void setSummaryKeywordList(List<String> summaryKeywordList) {
        this.summaryKeywordList = summaryKeywordList;
    }

    public Integer getSourceTopicId() {
        return this.sourceTopicId;
    }

    public void setSourceTopicId(Integer sourceTopicId) {
        this.sourceTopicId = sourceTopicId;
    }

    public String getTranslateSubject() {
        return this.translateSubject;
    }

    public void setTranslateSubject(String translateSubject) {
        this.translateSubject = translateSubject;
    }

    public String getTranslateDescription() {
        return this.translateDescription;
    }

    public void setTranslateDescription(String translateDescription) {
        this.translateDescription = translateDescription;
    }

    public String getWeiboPriMessageType() {
        return this.weiboPriMessageType;
    }

    public void setWeiboPriMessageType(String weiboPriMessageType) {
        this.weiboPriMessageType = weiboPriMessageType;
    }

    public String getXzUrl() {
        return this.xzUrl;
    }

    public void setXzUrl(String xzUrl) {
        this.xzUrl = xzUrl;
    }

    public Integer getTodayFlag() {
        return this.todayFlag;
    }

    public void setTodayFlag(Integer todayFlag) {
        this.todayFlag = todayFlag;
    }

    public String getConsultTime() {
        return this.consultTime;
    }

    public void setConsultTime(String consultTime) {
        this.consultTime = consultTime;
    }

    public String getSecondTags() {
        return this.secondTags;
    }

    public void setSecondTags(String secondTags) {
        this.secondTags = secondTags;
    }

    public Boolean getClusterOriginFlag() {
        return this.clusterOriginFlag;
    }

    public void setClusterOriginFlag(Boolean clusterOriginFlag) {
        this.clusterOriginFlag = clusterOriginFlag;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public Integer getNewestInfoFlag() {
        return this.newestInfoFlag;
    }

    public void setNewestInfoFlag(Integer newestInfoFlag) {
        this.newestInfoFlag = newestInfoFlag;
    }

    public Date getFirstQuestionTime() {
        return this.firstQuestionTime;
    }

    public void setFirstQuestionTime(Date firstQuestionTime) {
        this.firstQuestionTime = firstQuestionTime;
    }

    public Long getNewestMessageId() {
        return this.newestMessageId;
    }

    public void setNewestMessageId(Long newestMessageId) {
        this.newestMessageId = newestMessageId;
    }

    public Date getNewestMessageTime() {
        return this.newestMessageTime;
    }

    public void setNewestMessageTime(Date newestMessageTime) {
        this.newestMessageTime = newestMessageTime;
    }

    public Integer getFilterFlag() {
        return this.filterFlag;
    }

    public void setFilterFlag(Integer filterFlag) {
        this.filterFlag = filterFlag;
    }

    public Boolean getAoneNotifyFlag() {
        return this.aoneNotifyFlag;
    }

    public void setAoneNotifyFlag(Boolean aoneNotifyFlag) {
        this.aoneNotifyFlag = aoneNotifyFlag;
    }

    public List<String> getEventClusterIds() {
        return this.eventClusterIds;
    }

    public void setEventClusterIds(List<String> eventClusterIds) {
        this.eventClusterIds = eventClusterIds;
    }

    public Long getWorkId() {
        return this.workId;
    }

    public void setWorkId(Long workId) {
        this.workId = workId;
    }

    public String getBcClassifyTags() {
        return this.bcClassifyTags;
    }

    public void setBcClassifyTags(String bcClassifyTags) {
        this.bcClassifyTags = bcClassifyTags;
    }

    public Integer getVoneUserType() {
        return this.voneUserType;
    }

    public void setVoneUserType(Integer voneUserType) {
        this.voneUserType = voneUserType;
    }

    public List<Integer> getWatcherIds() {
        return this.watcherIds;
    }

    public void setWatcherIds(List<Integer> watcherIds) {
        this.watcherIds = watcherIds;
    }

    @Override
    public String toString() {
        return "ApsFeedback [id=" + this.id + ", updatedAt=" + this.updatedAt + ", issueAt=" + this.issueAt + ", province=" + this.province + ", city=" + this.city + ", networkOperator=" + this.networkOperator + ", kUserId=" + this.kUserId + ", accountType=" + this.accountType + ", importance=" + this.importance + ", procStatus=" + this.procStatus + ", tags=" + this.tags + ", tagsEmpty=" + this.tagsEmpty + ", tagsStr=" + this.tagsStr + ", tagIdsStr=" + this.tagIdsStr + ", eventsStr=" + this.eventsStr + ", eventIdsStr=" + this.eventIdsStr + ", isReplied=" + this.isReplied + ", attachments=" + this.attachments + ", kbmKnowledgeId=" + this.kbmKnowledgeId + ", kbmClassifyId=" + this.kbmClassifyId + ", wbFansCount=" + this.wbFansCount + ", wbRepostCount=" + this.wbRepostCount + ", wbCommentCount=" + this.wbCommentCount + ", wbLikeCount=" + this.wbLikeCount + ", wbVerifiedType=" + this.wbVerifiedType + ", crawlerKeywords=" + this.crawlerKeywords + ", appKey=" + this.appKey + ", cluster=" + this.cluster + ", feedbackClassify=" + this.feedbackClassify + ", feedbackConfirmClassify=" + this.feedbackConfirmClassify + ", emotionTendency=" + this.emotionTendency + ", emotionScore=" + this.emotionScore + ", emotionCategory=" + this.emotionCategory + ", emotionConfirmTendency=" + this.emotionConfirmTendency + ", keludeIds=" + this.keludeIds + ", urlMD5=" + this.urlMD5 + ", pubTime=" + this.pubTime + ", keywords=" + this.keywords + ", monitorkeywordId=" + this.monitorkeywordId + ", parentSource=" + this.parentSource + ", sourceId=" + this.sourceId + ", filterType=" + this.filterType + ", filterRule=" + this.filterRule + ", spiderDataKey=" + this.spiderDataKey + ", spiderDataType=" + this.spiderDataType + ", newestTime=" + this.newestTime + ", clusterFlag=" + this.clusterFlag + ", pointsCount=" + this.pointsCount + ", clusterId=" + this.clusterId + ", clusterPriority=" + this.clusterPriority + ", spiderTitleKey=" + this.spiderTitleKey + ", priorityModified=" + this.priorityModified + ", clusterValidStatus=" + this.clusterValidStatus + ", clusterProcStatus=" + this.clusterProcStatus + ", clusterProcFlag=" + this.clusterProcFlag + ", newestFeedbackId=" + this.newestFeedbackId + ", newestFeedbackSubject=" + this.newestFeedbackSubject + ", clusterPointsIds=" + this.clusterPointsIds + ", spiderAttachmentUrls=" + this.spiderAttachmentUrls + ", feedbackClassifyIds=" + this.feedbackClassifyIds + ", monitorTopicId=" + this.monitorTopicId + ", sourceTopicId=" + this.sourceTopicId + ", toString()=" + super.toString() + "]";
    }

    public String toSocietyString() {
        return "ApsFeedback [id=" + this.id + ", city=" + this.city + ", country=" + this.country + ", procStatus=" + this.procStatus + ", tags=" + this.tags + ", tagsEmpty=" + this.tagsEmpty + ", tagsStr=" + this.tagsStr + ", tagIdsStr=" + this.tagIdsStr + ", eventsStr=" + this.eventsStr + ", eventIdsStr=" + this.eventIdsStr + ", attachments=" + this.attachments + ", wbFansCount=" + this.wbFansCount + ", wbRepostCount=" + this.wbRepostCount + ", wbCommentCount=" + this.wbCommentCount + ", wbLikeCount=" + this.wbLikeCount + ", wbVerifiedType=" + this.wbVerifiedType + ", crawlerKeywords=" + this.crawlerKeywords + ", urlMD5=" + this.urlMD5 + ", pubTime=" + this.pubTime + ", keywords=" + this.keywords + ", monitorTopicId=" + this.monitorTopicId + ", monitorkeywordId=" + this.monitorkeywordId + ", parentSource=" + this.parentSource + ", sourceId=" + this.sourceId + ", filterType=" + this.filterType + ", filterRule=" + this.filterRule + ", spiderDataKey=" + this.spiderDataKey + ", spiderDataType=" + this.spiderDataType + ", spiderAttachmentUrls=" + this.spiderAttachmentUrls + ", priorityModified=" + this.priorityModified + ", langType=" + this.langType + ", sourceTopicId=" + this.sourceTopicId + ", translateSubject=" + this.translateSubject + ", translateDescription=" + this.translateDescription + "]";
    }

    public Map<String, Object> toHash() {
        HashMap<String, Object> feedbackData = new HashMap<String, Object>();
        feedbackData.put("id", this.getId());
        feedbackData.put("subject", this.getSubject());
        feedbackData.put("product_id", this.getProductId());
        feedbackData.put("source", this.getSource());
        feedbackData.put("monitor_keyword_id", this.getMonitorkeywordId());
        feedbackData.put("monitor_topic_id", this.getMonitorTopicId());
        feedbackData.put("valid_status", this.getValidStatus());
        feedbackData.put("user_id", this.getTbUserId());
        feedbackData.put("nickname", this.getTbNickname());
        feedbackData.put("cfs", this.getCfs());
        feedbackData.put("pub_time", this.getPubTime());
        feedbackData.put("created_at", this.getCreatedAt());
        feedbackData.put("updated_at", this.getUpdatedAt());
        feedbackData.put("referer_url", this.getRefererUrl());
        return feedbackData;
    }

    public Map<String, Object> toYuQingHash(Boolean trancateDesc) {
        int maxDescription = 100;
        HashMap<String, Object> feedbackData = new HashMap<String, Object>();
        feedbackData.put("id", this.getId());
        feedbackData.put("productId", this.getProductId());
        String source = this.getSource();
        feedbackData.put("source", source);
        feedbackData.put("monitorKeywordId", this.getMonitorkeywordId());
        feedbackData.put("monitorKeywords", this.getCrawlerKeywords());
        feedbackData.put("monitorTopicId", this.getMonitorTopicId());
        feedbackData.put("spiderTopicId", this.getSpiderTopicId() == null ? this.getSourceTopicId() : this.getSpiderTopicId());
        if (this.getFeedbackType() != null && this.getFeedbackType().equals(FeedbackType.EXTERNAL.getKey())) {
            feedbackData.put("from", "Weibo".equals(source) || "WeiboV".equals(source) || "WeiXin".equals(source) ? this.getTbNickname() : this.getParentSource());
        } else {
            feedbackData.put("from", this.getTbNickname());
        }
        feedbackData.put("feedbackType", this.getFeedbackType());
        feedbackData.put("url", this.getRefererUrl());
        feedbackData.put("filterStatus", this.getValidStatus());
        feedbackData.put("filterType", this.getFilterType());
        feedbackData.put("filterRule", this.getFilterRule());
        feedbackData.put("cfs", this.getCfs());
        feedbackData.put("createdAt", this.getCreatedAt());
        feedbackData.put("pubTime", this.getPubTime());
        feedbackData.put("wbId", this.getSourceFeedbackId());
        feedbackData.put("wbUserId", this.getTbUserId());
        feedbackData.put("wbFansCount", this.getWbFansCount());
        feedbackData.put("wbRepostCount", this.getWbRepostCount());
        feedbackData.put("wbCommentCount", this.getWbCommentCount());
        feedbackData.put("wbLikeCount", this.getWbLikeCount());
        feedbackData.put("wbVerifiedType", this.getWbVerifiedType());
        String parentSource = this.getParentSource();
        if (null != parentSource) {
            if (String.valueOf(SourceType.WEIBO_COMMENT.getKey()).equals(parentSource) || String.valueOf(SourceType.ALIPAY_WEIBO_COMMENT.getKey()).equals(parentSource)) {
                feedbackData.put("wbType", 2);
            }
            if (String.valueOf(SourceType.ALIPAY_REPOST_WEIBO_STATUS.getKey()).equals(parentSource) || String.valueOf(SourceType.WEIBO_REPOST_STATUS.getKey()).equals(parentSource)) {
                feedbackData.put("wbType", 1);
            }
            feedbackData.put("wbType", 0);
        } else {
            feedbackData.put("wbType", null);
        }
        feedbackData.put("emotionTendency", this.getEmotionTendency());
        feedbackData.put("emotionScore", this.getEmotionScore());
        feedbackData.put("clusterId", this.getClusterId());
        feedbackData.put("urlMD5", this.getUrlMD5());
        feedbackData.put("tags", this.getTags());
        feedbackData.put("langType", this.getLangType());
        feedbackData.put("osType", this.getOsType());
        feedbackData.put("createdAt", this.getCreatedAt() != null ? Long.valueOf(this.getCreatedAt().getTime()) : null);
        if (trancateDesc.booleanValue()) {
            feedbackData.put("subject", null != this.getSubject() && this.getSubject().length() > 100 ? this.getSubject().substring(0, 100) : this.getSubject());
            feedbackData.put("translateSubject", null != this.getTranslateSubject() && this.getTranslateSubject().length() > 100 ? this.getTranslateSubject().substring(0, 100) : this.getTranslateSubject());
            feedbackData.put("description", null != this.getDescription() && this.getDescription().length() > 100 ? this.getDescription().substring(0, 100) : this.getDescription());
            feedbackData.put("translateDescription", null != this.getTranslateDescription() && this.getTranslateDescription().length() > 100 ? this.getTranslateDescription().substring(0, 100) : this.getTranslateDescription());
        } else {
            feedbackData.put("subject", this.getSubject());
            feedbackData.put("translateSubject", this.getTranslateSubject());
            feedbackData.put("description", this.getDescription());
            feedbackData.put("translateDescription", this.getTranslateDescription());
        }
        feedbackData.put("summaryKeywordList", this.getSummaryKeywordList());
        feedbackData.put("city", this.getCity());
        feedbackData.put("province", this.getProvince());
        feedbackData.put("sourceId", this.getSourceId());
        feedbackData.put("productVersion", this.getProductVersion());
        feedbackData.put("ip", this.getIp());
        feedbackData.put("device_model", this.getDeviceModel());
        feedbackData.put("browser_type", this.getBrowserType());
        feedbackData.put("browser_version", this.getBrowserVersion());
        feedbackData.put("resolution", this.getResolution());
        feedbackData.put("network_type", this.getNetworkType());
        feedbackData.put("network_operator", this.getNetworkOperator());
        feedbackData.put("priority", this.getPriority());
        return feedbackData;
    }

    public Map<String, Object> toKQHash() {
        HashMap<String, Object> feedbackData = new HashMap<String, Object>();
        feedbackData.put("market_content_id", this.getIp());
        feedbackData.put("emotion_tendency", this.getEmotionTendency());
        feedbackData.put("emotion_score", this.getEmotionScore());
        return feedbackData;
    }

    public Map<String, Object> toAliweiHash() {
        HashMap<String, Object> feedbackData = new HashMap<String, Object>();
        feedbackData.put("id", this.getId());
        feedbackData.put("description", this.getDescription());
        feedbackData.put("tbNickName", this.getTbNickname());
        feedbackData.put("url", this.getRefererUrl());
        return feedbackData;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.workId == null ? 0 : this.workId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ApsFeedback other = (ApsFeedback)((Object)obj);
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.workId == null ? other.workId != null : !this.workId.equals(other.workId));
    }
}

