/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.feedback.model;

import com.taobao.kelude.aps.feedback.enums.FeedbackType;
import com.taobao.kelude.aps.feedback.enums.PriorityLevel;
import com.taobao.kelude.aps.feedback.enums.ValidStatus;
import com.taobao.kelude.aps.opensearch.annotations.FieldPlugin;
import com.taobao.kelude.aps.opensearch.annotations.SearchFieldMeta;
import com.taobao.kelude.aps.opensearch.annotations.SearchMapping;
import com.taobao.kelude.aps.opensearch.plugins.SearchCfsFieldPlugin;
import com.taobao.kelude.aps.opensearch.plugins.SearchListFieldPlugin;
import com.taobao.kelude.aps.utils.DateUtils;
import com.taobao.kelude.common.BaseModel;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApsFeedbackBase
extends BaseModel {
    private static final long serialVersionUID = 1L;
    public static final Integer DEFAULT_PRIORITY_P4 = 4;
    public static final String TARGET = "ApsFeedback";
    @SearchMapping(value="created_at")
    protected Date createdAt;
    @SearchMapping
    private String subject;
    @SearchMapping
    private String description;
    @SearchMapping(value="product_id")
    private Integer productId;
    @SearchMapping(value="product_type")
    private Integer productType = 0;
    @SearchMapping(value="product_version")
    private String productVersion;
    @SearchMapping(value="os_type")
    private Integer osType;
    @SearchMapping(value="os_version")
    private String osVersion;
    @SearchMapping(value="device_model")
    private String deviceModel;
    @SearchMapping(value="is_jailbreak")
    private Boolean isJailbreak;
    @SearchMapping(value="user_agent")
    private String userAgent;
    @SearchMapping(value="browser_type")
    private String browserType;
    @SearchMapping(value="browser_version")
    private String browserVersion;
    @SearchMapping(value="resolution")
    private String resolution;
    @SearchMapping(value="referer_url", urlEncode=true)
    private String refererUrl;
    @SearchMapping
    private String ip;
    @SearchMapping(value="network_type")
    private String networkType;
    @SearchMapping(value="tb_user_id")
    private Long tbUserId;
    @SearchMapping(value="tb_nickname")
    private String tbNickname;
    @SearchMapping
    private Integer priority;
    @SearchMapping(value="valid_status")
    protected Integer validStatus;
    @SearchMapping
    private String source;
    @SearchMapping(value="source_feedback_id")
    private Long sourceFeedbackId;
    @SearchMapping(value="source_product")
    private String sourceProduct;
    private List<Integer> tagIds;
    @SearchMapping(value="custom_attributes", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.STRING_ARRAY)
    @FieldPlugin(value=SearchCfsFieldPlugin.class)
    private Map<String, String> cfs = new HashMap<String, String>();
    @SearchMapping(value="custom_fields", fieldType=SearchFieldMeta.SearchFieldType.ARRAY, arrayIndexType=SearchFieldMeta.SearchArrayIndexType.INT32_ARRAY)
    @FieldPlugin(value=SearchListFieldPlugin.class)
    private List<Integer> customFieldsIds;
    @SearchMapping(value="feedback_type")
    private Integer feedbackType;
    @SearchMapping(value="has_attachment")
    private Boolean hasAttachment;
    private String staffId;
    private List<Integer> knowledgeIds;

    public ApsFeedbackBase() {
        this.validStatus = ValidStatus.VALID.getKey();
        this.priority = PriorityLevel.P4.getKey();
        this.feedbackType = FeedbackType.INTERNAL.getKey();
    }

    public String getCreatedAtStr() {
        return DateUtils.dateTimeToString(this.getCreatedAt());
    }

    public String getCreatedAtAboutTimeFormat() {
        return DateUtils.aboutTimeFormat(this.getCreatedAt());
    }

    public String getValidContent() {
        if (this.feedbackType != null && this.feedbackType.equals(0)) {
            return this.description;
        }
        if (!"Weibo".equals(this.source) && !"WeiboV".equals(this.source)) {
            return this.subject + "\r\n" + this.description;
        }
        return this.description;
    }

    public String getSimpleDescription() {
        if (this.description == null || "".equals(this.description)) {
            return this.subject;
        }
        if (this.description.length() > 128) {
            return this.description.substring(0, 128) + "...";
        }
        return this.description;
    }

    public Date getCreatedAt() {
        if (null == this.createdAt) {
            this.createdAt = new Date();
        }
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Integer getFeedbackType() {
        return this.feedbackType;
    }

    public void setFeedbackType(Integer feedbackType) {
        this.feedbackType = feedbackType;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public Integer getProductType() {
        return this.productType;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public Integer getOsType() {
        return this.osType;
    }

    public void setOsType(Integer osType) {
        this.osType = osType;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public Boolean getIsJailbreak() {
        return this.isJailbreak;
    }

    public void setIsJailbreak(Boolean isJailbreak) {
        this.isJailbreak = isJailbreak;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public void setBrowserType(String browserType) {
        this.browserType = browserType;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getRefererUrl() {
        return this.refererUrl;
    }

    public void setRefererUrl(String refererUrl) {
        this.refererUrl = refererUrl;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public Long getTbUserId() {
        return this.tbUserId;
    }

    public void setTbUserId(Long tbUserId) {
        this.tbUserId = tbUserId;
    }

    public String getTbNickname() {
        return this.tbNickname;
    }

    public void setTbNickname(String tbNickname) {
        this.tbNickname = tbNickname;
    }

    public Integer getPriority() {
        this.priority = this.priority == null ? DEFAULT_PRIORITY_P4 : this.priority;
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getValidStatus() {
        return this.validStatus;
    }

    public void setValidStatus(Integer validStatus) {
        this.validStatus = null == validStatus ? Integer.valueOf(ValidStatus.VALID.getKey()) : validStatus;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Long getSourceFeedbackId() {
        return this.sourceFeedbackId;
    }

    public void setSourceFeedbackId(Long sourceFeedbackId) {
        this.sourceFeedbackId = sourceFeedbackId;
    }

    public String getSourceProduct() {
        return this.sourceProduct;
    }

    public void setSourceProduct(String sourceProduct) {
        this.sourceProduct = sourceProduct;
    }

    public List<Integer> getTagIds() {
        return this.tagIds;
    }

    public void setTagIds(List<Integer> tagIds) {
        this.tagIds = tagIds;
    }

    public Map<String, String> getCfs() {
        return this.cfs;
    }

    public void setCfs(Map<String, String> cfs) {
        this.cfs = cfs;
    }

    public Boolean getHasAttachment() {
        return this.hasAttachment;
    }

    public void setHasAttachment(Boolean hasAttachment) {
        this.hasAttachment = hasAttachment;
    }

    public String getStaffId() {
        return this.staffId;
    }

    public void setStaffId(String staffId) {
        this.staffId = staffId;
    }

    public List<Integer> getCustomFieldsIds() {
        return this.customFieldsIds;
    }

    public void setCustomFieldsIds(List<Integer> customFieldsIds) {
        this.customFieldsIds = customFieldsIds;
    }

    public List<Integer> getKnowledgeIds() {
        return this.knowledgeIds;
    }

    public void setKnowledgeIds(List<Integer> knowledgeIds) {
        this.knowledgeIds = knowledgeIds;
    }

    public String toString() {
        return "ApsFeedbackBase [createdAt=" + this.createdAt + ", subject=" + this.subject + ", description=LEN:" + (this.description == null ? 0 : this.description.length()) + ", productId=" + this.productId + ", productType=" + this.productType + ", productVersion=" + this.productVersion + ", osType=" + this.osType + ", osVersion=" + this.osVersion + ", deviceModel=" + this.deviceModel + ", isJailbreak=" + this.isJailbreak + ", userAgent=" + this.userAgent + ", browserType=" + this.browserType + ", browserVersion=" + this.browserVersion + ", resolution=" + this.resolution + ", refererUrl=" + this.refererUrl + ", ip=" + this.ip + ", networkType=" + this.networkType + ", tbUserId=" + this.tbUserId + ", tbNickname=" + this.tbNickname + ", priority=" + this.priority + ", validStatus=" + this.validStatus + ", source=" + this.source + ", sourceFeedbackId=" + this.sourceFeedbackId + ", sourceProduct=" + this.sourceProduct + ", tagIds=" + this.tagIds + ", cfs=" + this.cfs + ", feedbackType=" + this.feedbackType + ", hasAttachment=" + this.hasAttachment + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.feedbackType == null ? 0 : this.feedbackType.hashCode());
        result = 31 * result + (this.productId == null ? 0 : this.productId.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.tbNickname == null ? 0 : this.tbNickname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ApsFeedbackBase other = (ApsFeedbackBase)((Object)obj);
        if (this.createdAt == null ? other.createdAt != null : !this.createdAt.equals(other.createdAt)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.feedbackType == null ? other.feedbackType != null : !this.feedbackType.equals(other.feedbackType)) {
            return false;
        }
        if (this.productId == null ? other.productId != null : !this.productId.equals(other.productId)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        return !(this.tbNickname == null ? other.tbNickname != null : !this.tbNickname.equals(other.tbNickname));
    }
}

