/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.kbm.model;

import com.taobao.kelude.aps.kbm.helper.KbmHelper;
import com.taobao.kelude.aps.opensearch.SearchBuilder;
import com.taobao.kelude.common.BaseModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KnowledgeQuery
extends BaseModel {
    private static final long serialVersionUID = 544447573911883143L;
    private Integer productId;
    private List<Integer> productIds;
    private List<Integer> classifyIds;
    private String classifyTreePath;
    private Integer classifyType;
    private String queryContent;
    private Map<String, List<String>> customAttrubutes;
    private Integer pageIndex = 1;
    private Integer pageSize;
    private Long tbUserId;
    private List<Integer> idsNot;
    private Map<String, Object> options = new HashMap<String, Object>();

    public void addCustomAttribute(String attrName, String attrValue) {
        List<String> values;
        if (this.customAttrubutes == null) {
            this.customAttrubutes = new HashMap<String, List<String>>();
        }
        if ((values = this.customAttrubutes.get(attrName)) == null) {
            values = new ArrayList<String>();
            this.customAttrubutes.put(attrName, values);
        }
        values.add(attrValue);
    }

    public String buildSearchContent() {
        SearchBuilder builder = SearchBuilder.BUILDER();
        if (this.productIds == null || this.productIds.isEmpty()) {
            builder.appendIntField(this.productId, "products_id");
        }
        builder.appendIntField(this.classifyType, "classify_type");
        if (this.queryContent != null && !"".equals(this.queryContent)) {
            builder.appendStrFieldOrPair(new String[]{this.queryContent, this.queryContent, this.queryContent}, new String[]{"title", "answer", "questions"}, false, false);
        }
        if (this.customAttrubutes != null && !this.customAttrubutes.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : this.customAttrubutes.entrySet()) {
                String customName = entry.getKey();
                List<String> values = entry.getValue();
                if (customName == null || values == null || values.isEmpty()) continue;
                ArrayList<String> fields = new ArrayList<String>(values.size());
                for (String value : values) {
                    fields.add(KbmHelper.customAttr(customName, value));
                }
                builder.appendStrListField(fields, "custom_attributes", true);
            }
        }
        builder.appendStrField(this.classifyTreePath, "classify_tree_path", true);
        if (this.idsNot != null && !this.idsNot.isEmpty()) {
            builder.ANDNOT();
            builder.appendIntListField(this.idsNot, "id", false);
        }
        builder.appendIntField(1, "status");
        return builder.build();
    }

    public String buildFilterContent() {
        SearchBuilder builder = SearchBuilder.BUILDER('=');
        if (this.productIds != null && !this.productIds.isEmpty()) {
            builder.appendIntListField(this.productIds, "products_id", true);
        }
        builder.appendIntListField(this.classifyIds, "kbm_classify_id", true);
        builder.leftToken();
        builder.appendLongComparatorField(new Date().getTime(), "expire_date", '>');
        builder.OR();
        builder.appendLongField(0L, "expire_date");
        builder.rightToken();
        return builder.build();
    }

    public List<Integer> getClassifyIds() {
        return this.classifyIds;
    }

    public void setClassifyIds(List<Integer> classifyIds) {
        this.classifyIds = classifyIds;
    }

    public Integer getClassifyType() {
        return this.classifyType;
    }

    public void setClassifyType(Integer classifyType) {
        this.classifyType = classifyType;
    }

    public String getQueryContent() {
        return this.queryContent;
    }

    public void setQueryContent(String queryContent) {
        this.queryContent = queryContent;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public Map<String, List<String>> getCustomAttrubutes() {
        return this.customAttrubutes;
    }

    public void setCustomAttrubutes(Map<String, List<String>> customAttrubutes) {
        this.customAttrubutes = customAttrubutes;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getClassifyTreePath() {
        return this.classifyTreePath;
    }

    public void setClassifyTreePath(String classifyTreePath) {
        this.classifyTreePath = classifyTreePath;
    }

    public Long getTbUserId() {
        return this.tbUserId;
    }

    public void setTbUserId(Long tbUserId) {
        this.tbUserId = tbUserId;
    }

    public List<Integer> getProductIds() {
        return this.productIds;
    }

    public void setProductIds(List<Integer> productIds) {
        this.productIds = productIds;
    }

    public List<Integer> getIdsNot() {
        return this.idsNot;
    }

    public void setIdsNot(List<Integer> idsNot) {
        this.idsNot = idsNot;
    }

    public String toString() {
        return "KnowledgeQuery [productId=" + this.productId + ", classifyIds=" + this.classifyIds + ", classifyTreePath=" + this.classifyTreePath + ", classifyType=" + this.classifyType + ", queryContent=" + this.queryContent + ", customAttrubutes=" + this.customAttrubutes + ", pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ", tbUserId=" + this.tbUserId + ", options=" + this.options + "]";
    }
}

