/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kelude.aps.opensearch;

import com.taobao.kelude.aps.opensearch.OpenSearchException;
import com.taobao.kelude.aps.utils.DateUtils;
import com.taobao.kelude.aps.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public final class SearchBuilder {
    private static final int DEFAULT_BUFFER_LEN = 128;
    private static final String OP_AND = " AND ";
    private static final String OP_ANDNOT = " ANDNOT ";
    private static final String OP_OR = " OR ";
    private static final String[] OP_ARRAY = new String[]{" AND ", " ANDNOT ", " OR "};
    private static final char DEFAULT_VALUE_SEP = ':';
    private StringBuilder buffer = new StringBuilder(128);
    private char valueSep;

    private SearchBuilder(char valueSep) {
        this.valueSep = valueSep;
    }

    public static SearchBuilder BUILDER() {
        return new SearchBuilder(':');
    }

    public static SearchBuilder BUILDER(char valueSep) {
        return new SearchBuilder(valueSep);
    }

    public String build() {
        this.checkTailOper();
        return this.buffer.toString();
    }

    public SearchBuilder RANK() {
        this.checkTailOper();
        this.buffer.append(" RANK ");
        return this;
    }

    public SearchBuilder leftToken() {
        this.buffer.append('(');
        return this;
    }

    public SearchBuilder rightToken() {
        this.checkTailOper();
        this.buffer.append(')');
        return this;
    }

    public SearchBuilder AND() {
        this.checkTailOper();
        if (this.buffer.length() > 0) {
            this.buffer.append(OP_AND);
        }
        return this;
    }

    public SearchBuilder OR() {
        this.checkTailOper();
        if (this.buffer.length() > 0) {
            this.buffer.append(OP_OR);
        }
        return this;
    }

    public SearchBuilder ANDNOT() {
        this.checkTailOper();
        if (this.buffer.length() > 0) {
            this.buffer.append(OP_ANDNOT);
        }
        return this;
    }

    public SearchBuilder appendLongField(Long value, String fieldName) {
        if (value != null) {
            this.buffer.append(fieldName).append(this.valueSep).append('\'').append(value).append('\'').append(OP_AND);
        }
        return this;
    }

    public SearchBuilder appendIntField(Integer value, String fieldName) {
        if (value != null) {
            this.buffer.append(fieldName).append(this.valueSep).append('\'').append(value).append('\'').append(OP_AND);
        }
        return this;
    }

    public SearchBuilder appendBoolField(Boolean value, String fieldName) {
        if (value != null) {
            this.buffer.append(fieldName).append(this.valueSep).append('\'').append(value != false ? 1 : 0).append('\'').append(OP_AND);
        }
        return this;
    }

    public SearchBuilder appendLongComparatorField(Long value, String fieldName, char oper) {
        if (value != null) {
            this.buffer.append(fieldName).append(oper).append('\'').append(value).append('\'').append(OP_AND);
        }
        return this;
    }

    public SearchBuilder appendTimeField(String startDateStr, String endDateStr, Integer duration, String fieldName) {
        try {
            Date startDate = null;
            Date endDate = null;
            if (startDateStr != null && !"".equals(startDateStr.trim())) {
                startDate = DateUtils.formatDate(startDateStr);
            }
            if (endDateStr != null && !"".equals(endDateStr.trim())) {
                endDate = DateUtils.formatDate(endDateStr);
            }
            if (startDate == null && endDate == null && duration != null) {
                startDate = DateUtils.addMinutes(new Date(), -duration.intValue());
                endDate = null;
            }
            if (startDate != null) {
                this.buffer.append(fieldName).append(">=").append(startDate.getTime()).append(OP_AND);
            }
            if (endDate != null) {
                this.buffer.append(fieldName).append("<=").append(endDate.getTime()).append(OP_AND);
            }
        }
        catch (Exception e) {
            throw new OpenSearchException(e.getMessage(), e);
        }
        return this;
    }

    public SearchBuilder appendEmptyField(String value, String fieldName) {
        try {
            if (value != null && !"".equals(value.trim())) {
                this.buffer.append(fieldName).append("!=").append(value).append(OP_AND);
            }
        }
        catch (Exception e) {
            throw new OpenSearchException(e.getMessage(), e);
        }
        return this;
    }

    public SearchBuilder appendConsultDateStrRangeField(String startStr, String endStr, String fieldName) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            Date date = null;
            Long timeStemp = null;
            if (startStr != null && !"".equals(startStr.trim())) {
                date = simpleDateFormat.parse(startStr);
                timeStemp = date.getTime();
                this.buffer.append(fieldName).append(">=").append(timeStemp).append(OP_AND);
            }
            if (endStr != null && !"".equals(endStr.trim())) {
                date = simpleDateFormat.parse(endStr);
                timeStemp = date.getTime();
                this.buffer.append(fieldName).append("<=").append(timeStemp).append(OP_AND);
            }
        }
        catch (Exception e) {
            throw new OpenSearchException(e.getMessage(), e);
        }
        return this;
    }

    public SearchBuilder appendStrField(String value, String fieldName) {
        return this.appendStrField(value, fieldName, false, false);
    }

    public SearchBuilder appendStrField(String value, String fieldName, boolean isFuzzy) {
        return this.appendStrField(value, fieldName, isFuzzy, false);
    }

    public SearchBuilder appendStrField(String value, String fieldName, boolean isFuzzy, boolean doubleQuota) {
        if (!StringUtils.isEmpty((String)value)) {
            String strField = this.getStrField(value, fieldName, isFuzzy, doubleQuota);
            this.buffer.append(strField).append(OP_AND);
        }
        return this;
    }

    public SearchBuilder appendStrFieldOrPair(String[] values, String[] fieldNames, boolean isFuzzy, boolean doubleQuota) {
        int len;
        if (values != null && fieldNames != null && (len = Math.min(values.length, fieldNames.length)) > 0) {
            int valid = 0;
            this.buffer.append('(');
            for (int i = 0; i < len; ++i) {
                String value = values[i];
                if (value == null) continue;
                String fieldName = fieldNames[i];
                String strField = this.getStrField(value, fieldName, isFuzzy, doubleQuota);
                this.buffer.append(strField);
                if (i < len - 1) {
                    this.buffer.append(OP_OR);
                }
                ++valid;
            }
            if (valid > 0) {
                this.buffer.append(')').append(OP_AND);
            } else {
                this.buffer.setLength(this.buffer.length() - 1);
            }
        }
        return this;
    }

    public SearchBuilder appendIntListField(List<Integer> values, String fieldName, boolean orWay) {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                return this.appendIntField(values.get(0), fieldName);
            }
            if (orWay) {
                this.buffer.append('(');
                for (int i = 0; i < values.size(); ++i) {
                    Integer value = values.get(i);
                    if (value == null) continue;
                    this.buffer.append(fieldName).append(this.valueSep).append('\'').append(value).append('\'');
                    if (i >= values.size() - 1) continue;
                    this.buffer.append(OP_OR);
                }
                this.buffer.append(')');
            } else {
                this.buffer.append(fieldName).append(this.valueSep);
                for (Integer value : values) {
                    this.buffer.append('\'').append(value).append('\'').append('|');
                }
                this.buffer.setLength(this.buffer.length() - 1);
            }
            this.buffer.append(OP_AND);
        }
        return this;
    }

    public SearchBuilder appendLongListField(List<Long> values, String fieldName, boolean orWay) {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                return this.appendLongField(values.get(0), fieldName);
            }
            if (orWay) {
                this.buffer.append('(');
                for (int i = 0; i < values.size(); ++i) {
                    Long value = values.get(i);
                    if (value == null) continue;
                    this.buffer.append(fieldName).append(this.valueSep).append('\'').append(value).append('\'');
                    if (i >= values.size() - 1) continue;
                    this.buffer.append(OP_OR);
                }
                this.buffer.append(')');
            } else {
                this.buffer.append(fieldName).append(this.valueSep);
                for (Long value : values) {
                    this.buffer.append('\'').append(value).append('\'').append('|');
                }
                this.buffer.setLength(this.buffer.length() - 1);
            }
            this.buffer.append(OP_AND);
        }
        return this;
    }

    public SearchBuilder appendStrListField(List<String> values, String fieldName, boolean orWay) {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                return this.appendStrField(values.get(0), fieldName);
            }
            if (orWay) {
                this.buffer.append('(');
                for (int i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    if (value == null) continue;
                    String strField = this.getStrField(value, fieldName, false, false);
                    this.buffer.append(strField);
                    if (i >= values.size() - 1) continue;
                    this.buffer.append(OP_OR);
                }
                this.buffer.append(')');
            } else {
                this.buffer.append(fieldName).append(this.valueSep);
                for (String value : values) {
                    this.buffer.append('\'').append(value).append('\'').append('|');
                }
                this.buffer.setLength(this.buffer.length() - 1);
            }
            this.buffer.append(OP_AND);
        }
        return this;
    }

    public void appendClusterOrFields(Long value, Long value1, String ... fieldNames) {
        if (value == null || value < 0L || fieldNames.length == 0) {
            return;
        }
        this.buffer.append('(');
        int index = 0;
        for (String fieldName : fieldNames) {
            if (null == fieldName || !StringUtils.isNotEmpty((String)fieldName)) continue;
            if (index > 0) {
                this.buffer.append(OP_OR);
            }
            this.buffer.append(fieldName).append(this.valueSep).append('\'').append(value).append('\'');
            ++index;
        }
        if (value1 != null) {
            this.buffer.append(OP_OR);
            this.buffer.append("cluster_id").append(this.valueSep).append('\'').append(value1).append('\'');
        }
        this.buffer.append(')');
    }

    private String getStrField(String value, String fieldName, boolean isFuzzy, boolean doubleQuota) {
        char quota;
        value = this.escapeStr(value);
        char c = quota = doubleQuota ? (char)'\"' : '\'';
        if (isFuzzy) {
            if (value.endsWith("*")) {
                value = "^" + value.substring(0, value.length() - 1);
            } else if (value.startsWith("*")) {
                value = value.substring(1, value.length()) + "$";
            }
        }
        return StringUtils.bufferString(fieldName, Character.valueOf(this.valueSep), Character.valueOf(quota), value, Character.valueOf(quota));
    }

    private String escapeStr(String value) {
        if (value.endsWith("\\")) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.replace("\\", "\\\\").replace("'", "\\'");
        return value;
    }

    private String wrapStr(String value, boolean doubleQuota) {
        char quota = doubleQuota ? (char)'\"' : '\'';
        return StringUtils.bufferString(Character.valueOf(quota), this.escapeStr(value), Character.valueOf(quota));
    }

    private void checkTailOper() {
        if (this.buffer.length() == 0) {
            return;
        }
        for (String op : OP_ARRAY) {
            int index = StringUtils.endsWith(this.buffer, op);
            if (index < 0) continue;
            this.buffer.setLength(index);
            break;
        }
    }

    public SearchBuilder appendListField(List<Long> values, String fieldName) {
        if (values != null && !values.isEmpty()) {
            this.buffer.append("in(").append(fieldName).append(",\"").append(StringUtils.toCollectionString(values, '|')).append("\")").append(OP_AND);
        }
        return this;
    }
}

